// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.CertificateProviderOperation
import aws.sdk.kotlin.services.iot.model.DescribeCertificateProviderResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeCertificateProviderOperationDeserializer: HttpDeserializer.NonStreaming<DescribeCertificateProviderResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeCertificateProviderResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCertificateProviderError(context, call, payload)
        }
        val builder = DescribeCertificateProviderResponse.Builder()

        if (payload != null) {
            deserializeDescribeCertificateProviderOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeCertificateProviderError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCertificateProviderOperationBody(builder: DescribeCertificateProviderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTDEFAULTFOROPERATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("accountDefaultForOperations"))
    val CERTIFICATEPROVIDERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateProviderArn"))
    val CERTIFICATEPROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateProviderName"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val LAMBDAFUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lambdaFunctionArn"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTDEFAULTFOROPERATIONS_DESCRIPTOR)
        field(CERTIFICATEPROVIDERARN_DESCRIPTOR)
        field(CERTIFICATEPROVIDERNAME_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(LAMBDAFUNCTIONARN_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTDEFAULTFOROPERATIONS_DESCRIPTOR.index -> builder.accountDefaultForOperations =
                    deserializer.deserializeList(ACCOUNTDEFAULTFOROPERATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CertificateProviderOperation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { CertificateProviderOperation.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CERTIFICATEPROVIDERARN_DESCRIPTOR.index -> builder.certificateProviderArn = deserializeString()
                CERTIFICATEPROVIDERNAME_DESCRIPTOR.index -> builder.certificateProviderName = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LAMBDAFUNCTIONARN_DESCRIPTOR.index -> builder.lambdaFunctionArn = deserializeString()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
