// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AlertTarget
import aws.sdk.kotlin.services.iot.model.AlertTargetType
import aws.sdk.kotlin.services.iot.model.Behavior
import aws.sdk.kotlin.services.iot.model.MetricToRetain
import aws.sdk.kotlin.services.iot.model.MetricsExportConfig
import aws.sdk.kotlin.services.iot.model.UpdateSecurityProfileRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSecurityProfileOperationSerializer: HttpSerializer.NonStreaming<UpdateSecurityProfileRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateSecurityProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.securityProfileName) { "securityProfileName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("security-profiles"))
                add(PercentEncoding.SmithyLabel.encode(input.securityProfileName))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.expectedVersion != null) add("expectedVersion", input.expectedVersion.toString())
            }
        }

        val payload = serializeUpdateSecurityProfileOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSecurityProfileOperationBody(context: ExecutionContext, input: UpdateSecurityProfileRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALMETRICSTORETAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalMetricsToRetain"))
    val ADDITIONALMETRICSTORETAINV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalMetricsToRetainV2"))
    val ALERTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("alertTargets"))
    val BEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("behaviors"))
    val DELETEADDITIONALMETRICSTORETAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deleteAdditionalMetricsToRetain"))
    val DELETEALERTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deleteAlertTargets"))
    val DELETEBEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deleteBehaviors"))
    val DELETEMETRICSEXPORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deleteMetricsExportConfig"))
    val METRICSEXPORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metricsExportConfig"))
    val SECURITYPROFILEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("securityProfileDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALMETRICSTORETAIN_DESCRIPTOR)
        field(ADDITIONALMETRICSTORETAINV2_DESCRIPTOR)
        field(ALERTTARGETS_DESCRIPTOR)
        field(BEHAVIORS_DESCRIPTOR)
        field(DELETEADDITIONALMETRICSTORETAIN_DESCRIPTOR)
        field(DELETEALERTTARGETS_DESCRIPTOR)
        field(DELETEBEHAVIORS_DESCRIPTOR)
        field(DELETEMETRICSEXPORTCONFIG_DESCRIPTOR)
        field(METRICSEXPORTCONFIG_DESCRIPTOR)
        field(SECURITYPROFILEDESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalMetricsToRetain != null) {
            listField(ADDITIONALMETRICSTORETAIN_DESCRIPTOR) {
                for (el0 in input.additionalMetricsToRetain) {
                    serializeString(el0)
                }
            }
        }
        if (input.additionalMetricsToRetainV2 != null) {
            listField(ADDITIONALMETRICSTORETAINV2_DESCRIPTOR) {
                for (el0 in input.additionalMetricsToRetainV2) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricToRetainDocument))
                }
            }
        }
        if (input.alertTargets != null) {
            mapField(ALERTTARGETS_DESCRIPTOR) {
                input.alertTargets.forEach { (key, value) -> entry(key.value, asSdkSerializable(value, ::serializeAlertTargetDocument)) }
            }
        }
        if (input.behaviors != null) {
            listField(BEHAVIORS_DESCRIPTOR) {
                for (el0 in input.behaviors) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBehaviorDocument))
                }
            }
        }
        input.deleteAdditionalMetricsToRetain?.let { field(DELETEADDITIONALMETRICSTORETAIN_DESCRIPTOR, it) }
        input.deleteAlertTargets?.let { field(DELETEALERTTARGETS_DESCRIPTOR, it) }
        input.deleteBehaviors?.let { field(DELETEBEHAVIORS_DESCRIPTOR, it) }
        input.deleteMetricsExportConfig?.let { field(DELETEMETRICSEXPORTCONFIG_DESCRIPTOR, it) }
        input.metricsExportConfig?.let { field(METRICSEXPORTCONFIG_DESCRIPTOR, it, ::serializeMetricsExportConfigDocument) }
        input.securityProfileDescription?.let { field(SECURITYPROFILEDESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
