// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.CreateTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.TopicRulePayload
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateTopicRuleOperationSerializer: HttpSerializer.NonStreaming<CreateTopicRuleRequest> {
    override fun serialize(context: ExecutionContext, input: CreateTopicRuleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.ruleName) { "ruleName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("rules"))
                add(PercentEncoding.SmithyLabel.encode(input.ruleName))
            }
        }

        builder.headers {
            if (input.tags?.isNotEmpty() == true) append("x-amz-tagging", input.tags)
        }

        if (input.topicRulePayload != null) {
            val payload = serializeTopicRulePayloadPayload(input.topicRulePayload)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.topicRulePayload == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
