// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The properties of a virtual private cloud (VPC) destination.
 */
public class VpcDestinationProperties private constructor(builder: Builder) {
    /**
     * The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The security groups of the VPC destination.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The subnet IDs of the VPC destination.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The ID of the VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.VpcDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcDestinationProperties(")
        append("roleArn=$roleArn,")
        append("securityGroups=$securityGroups,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcDestinationProperties

        if (roleArn != other.roleArn) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.VpcDestinationProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The security groups of the VPC destination.
         */
        public var securityGroups: List<String>? = null
        /**
         * The subnet IDs of the VPC destination.
         */
        public var subnetIds: List<String>? = null
        /**
         * The ID of the VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.VpcDestinationProperties) : this() {
            this.roleArn = x.roleArn
            this.securityGroups = x.securityGroups
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.VpcDestinationProperties = VpcDestinationProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
