// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A topic rule destination.
 */
public class TopicRuleDestination private constructor(builder: Builder) {
    /**
     * The topic rule destination URL.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time when the topic rule destination was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Properties of the HTTP URL.
     */
    public val httpUrlProperties: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationProperties? = builder.httpUrlProperties
    /**
     * The date and time when the topic rule destination was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The status of the topic rule destination. Valid values are:
     *
     * ## IN_PROGRESS
     * A topic rule destination was created but has not been confirmed. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     *
     * ## ENABLED
     * Confirmation was completed, and traffic to this destination is allowed. You can set `status` to `DISABLED` by calling `UpdateTopicRuleDestination`.
     *
     * ## DISABLED
     * Confirmation was completed, and traffic to this destination is not allowed. You can set `status` to `ENABLED` by calling `UpdateTopicRuleDestination`.
     *
     * ## ERROR
     * Confirmation could not be completed, for example if the confirmation timed out. You can call `GetTopicRuleDestination` for details about the error. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     */
    public val status: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationStatus? = builder.status
    /**
     * Additional details or reason why the topic rule destination is in the current status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * Properties of the virtual private cloud (VPC) connection.
     */
    public val vpcProperties: aws.sdk.kotlin.services.iot.model.VpcDestinationProperties? = builder.vpcProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TopicRuleDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicRuleDestination(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("httpUrlProperties=$httpUrlProperties,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("vpcProperties=$vpcProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (httpUrlProperties?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (vpcProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicRuleDestination

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (httpUrlProperties != other.httpUrlProperties) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (vpcProperties != other.vpcProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TopicRuleDestination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The topic rule destination URL.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time when the topic rule destination was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Properties of the HTTP URL.
         */
        public var httpUrlProperties: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationProperties? = null
        /**
         * The date and time when the topic rule destination was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the topic rule destination. Valid values are:
         *
         * ## IN_PROGRESS
         * A topic rule destination was created but has not been confirmed. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
         *
         * ## ENABLED
         * Confirmation was completed, and traffic to this destination is allowed. You can set `status` to `DISABLED` by calling `UpdateTopicRuleDestination`.
         *
         * ## DISABLED
         * Confirmation was completed, and traffic to this destination is not allowed. You can set `status` to `ENABLED` by calling `UpdateTopicRuleDestination`.
         *
         * ## ERROR
         * Confirmation could not be completed, for example if the confirmation timed out. You can call `GetTopicRuleDestination` for details about the error. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
         */
        public var status: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationStatus? = null
        /**
         * Additional details or reason why the topic rule destination is in the current status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * Properties of the virtual private cloud (VPC) connection.
         */
        public var vpcProperties: aws.sdk.kotlin.services.iot.model.VpcDestinationProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TopicRuleDestination) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.httpUrlProperties = x.httpUrlProperties
            this.lastUpdatedAt = x.lastUpdatedAt
            this.status = x.status
            this.statusReason = x.statusReason
            this.vpcProperties = x.vpcProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TopicRuleDestination = TopicRuleDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.HttpUrlDestinationProperties] inside the given [block]
         */
        public fun httpUrlProperties(block: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationProperties.Builder.() -> kotlin.Unit) {
            this.httpUrlProperties = aws.sdk.kotlin.services.iot.model.HttpUrlDestinationProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.VpcDestinationProperties] inside the given [block]
         */
        public fun vpcProperties(block: aws.sdk.kotlin.services.iot.model.VpcDestinationProperties.Builder.() -> kotlin.Unit) {
            this.vpcProperties = aws.sdk.kotlin.services.iot.model.VpcDestinationProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
