// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a rule.
 */
public class TopicRule private constructor(builder: Builder) {
    /**
     * The actions associated with the rule.
     */
    public val actions: List<Action>? = builder.actions
    /**
     * The version of the SQL rules engine to use when evaluating the rule.
     */
    public val awsIotSqlVersion: kotlin.String? = builder.awsIotSqlVersion
    /**
     * The date and time the rule was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of the rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The action to perform when an error occurs.
     */
    public val errorAction: aws.sdk.kotlin.services.iot.model.Action? = builder.errorAction
    /**
     * Specifies whether the rule is disabled.
     */
    public val ruleDisabled: kotlin.Boolean? = builder.ruleDisabled
    /**
     * The name of the rule.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the newline characters.
     */
    public val sql: kotlin.String? = builder.sql

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TopicRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicRule(")
        append("actions=$actions,")
        append("awsIotSqlVersion=$awsIotSqlVersion,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("errorAction=$errorAction,")
        append("ruleDisabled=$ruleDisabled,")
        append("ruleName=$ruleName,")
        append("sql=$sql")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (awsIotSqlVersion?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorAction?.hashCode() ?: 0)
        result = 31 * result + (ruleDisabled?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (sql?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicRule

        if (actions != other.actions) return false
        if (awsIotSqlVersion != other.awsIotSqlVersion) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (errorAction != other.errorAction) return false
        if (ruleDisabled != other.ruleDisabled) return false
        if (ruleName != other.ruleName) return false
        if (sql != other.sql) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TopicRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The actions associated with the rule.
         */
        public var actions: List<Action>? = null
        /**
         * The version of the SQL rules engine to use when evaluating the rule.
         */
        public var awsIotSqlVersion: kotlin.String? = null
        /**
         * The date and time the rule was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the rule.
         */
        public var description: kotlin.String? = null
        /**
         * The action to perform when an error occurs.
         */
        public var errorAction: aws.sdk.kotlin.services.iot.model.Action? = null
        /**
         * Specifies whether the rule is disabled.
         */
        public var ruleDisabled: kotlin.Boolean? = null
        /**
         * The name of the rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the newline characters.
         */
        public var sql: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TopicRule) : this() {
            this.actions = x.actions
            this.awsIotSqlVersion = x.awsIotSqlVersion
            this.createdAt = x.createdAt
            this.description = x.description
            this.errorAction = x.errorAction
            this.ruleDisabled = x.ruleDisabled
            this.ruleName = x.ruleName
            this.sql = x.sql
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TopicRule = TopicRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.Action] inside the given [block]
         */
        public fun errorAction(block: aws.sdk.kotlin.services.iot.model.Action.Builder.() -> kotlin.Unit) {
            this.errorAction = aws.sdk.kotlin.services.iot.model.Action.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
