// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an action to write data to an Amazon Kinesis stream.
 */
public class KinesisAction private constructor(builder: Builder) {
    /**
     * The partition key.
     */
    public val partitionKey: kotlin.String? = builder.partitionKey
    /**
     * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The name of the Amazon Kinesis stream.
     */
    public val streamName: kotlin.String = requireNotNull(builder.streamName) { "A non-null value must be provided for streamName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.KinesisAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisAction(")
        append("partitionKey=$partitionKey,")
        append("roleArn=$roleArn,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = partitionKey?.hashCode() ?: 0
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (streamName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisAction

        if (partitionKey != other.partitionKey) return false
        if (roleArn != other.roleArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.KinesisAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The partition key.
         */
        public var partitionKey: kotlin.String? = null
        /**
         * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the Amazon Kinesis stream.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.KinesisAction) : this() {
            this.partitionKey = x.partitionKey
            this.roleArn = x.roleArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.KinesisAction = KinesisAction(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (streamName == null) streamName = ""
            return this
        }
    }
}
