// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateScheduledAuditRequest private constructor(builder: Builder) {
    /**
     * The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to `MONTHLY`. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the `LAST` day of the month.
     */
    public val dayOfMonth: kotlin.String? = builder.dayOfMonth
    /**
     * The day of the week on which the scheduled audit takes place, either `SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, or `SAT`. This field is required if the `frequency` parameter is set to `WEEKLY` or `BIWEEKLY`.
     */
    public val dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = builder.dayOfWeek
    /**
     * How often the scheduled audit takes place, either `DAILY`, `WEEKLY`, `BIWEEKLY` or `MONTHLY`. The start time of each audit is determined by the system.
     */
    public val frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = builder.frequency
    /**
     * The name you want to give to the scheduled audit. (Max. 128 chars)
     */
    public val scheduledAuditName: kotlin.String? = builder.scheduledAuditName
    /**
     * Metadata that can be used to manage the scheduled audit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
     */
    public val targetCheckNames: List<String>? = builder.targetCheckNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateScheduledAuditRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateScheduledAuditRequest(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("frequency=$frequency,")
        append("scheduledAuditName=$scheduledAuditName,")
        append("tags=$tags,")
        append("targetCheckNames=$targetCheckNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth?.hashCode() ?: 0
        result = 31 * result + (dayOfWeek?.hashCode() ?: 0)
        result = 31 * result + (frequency?.hashCode() ?: 0)
        result = 31 * result + (scheduledAuditName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetCheckNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateScheduledAuditRequest

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (frequency != other.frequency) return false
        if (scheduledAuditName != other.scheduledAuditName) return false
        if (tags != other.tags) return false
        if (targetCheckNames != other.targetCheckNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateScheduledAuditRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to `MONTHLY`. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the `LAST` day of the month.
         */
        public var dayOfMonth: kotlin.String? = null
        /**
         * The day of the week on which the scheduled audit takes place, either `SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, or `SAT`. This field is required if the `frequency` parameter is set to `WEEKLY` or `BIWEEKLY`.
         */
        public var dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = null
        /**
         * How often the scheduled audit takes place, either `DAILY`, `WEEKLY`, `BIWEEKLY` or `MONTHLY`. The start time of each audit is determined by the system.
         */
        public var frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = null
        /**
         * The name you want to give to the scheduled audit. (Max. 128 chars)
         */
        public var scheduledAuditName: kotlin.String? = null
        /**
         * Metadata that can be used to manage the scheduled audit.
         */
        public var tags: List<Tag>? = null
        /**
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
         */
        public var targetCheckNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateScheduledAuditRequest) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.frequency = x.frequency
            this.scheduledAuditName = x.scheduledAuditName
            this.tags = x.tags
            this.targetCheckNames = x.targetCheckNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateScheduledAuditRequest = CreateScheduledAuditRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
