// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Used in MitigationActionParams, this information identifies the target findings to which the mitigation actions are applied. Only one entry appears.
 */
public class AuditMitigationActionsTaskTarget private constructor(builder: Builder) {
    /**
     * Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.
     */
    public val auditCheckToReasonCodeFilter: Map<String, List<String>>? = builder.auditCheckToReasonCodeFilter
    /**
     * If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.
     */
    public val auditTaskId: kotlin.String? = builder.auditTaskId
    /**
     * If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.
     */
    public val findingIds: List<String>? = builder.findingIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AuditMitigationActionsTaskTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuditMitigationActionsTaskTarget(")
        append("auditCheckToReasonCodeFilter=$auditCheckToReasonCodeFilter,")
        append("auditTaskId=$auditTaskId,")
        append("findingIds=$findingIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditCheckToReasonCodeFilter?.hashCode() ?: 0
        result = 31 * result + (auditTaskId?.hashCode() ?: 0)
        result = 31 * result + (findingIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuditMitigationActionsTaskTarget

        if (auditCheckToReasonCodeFilter != other.auditCheckToReasonCodeFilter) return false
        if (auditTaskId != other.auditTaskId) return false
        if (findingIds != other.findingIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AuditMitigationActionsTaskTarget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.
         */
        public var auditCheckToReasonCodeFilter: Map<String, List<String>>? = null
        /**
         * If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.
         */
        public var auditTaskId: kotlin.String? = null
        /**
         * If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.
         */
        public var findingIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AuditMitigationActionsTaskTarget) : this() {
            this.auditCheckToReasonCodeFilter = x.auditCheckToReasonCodeFilter
            this.auditTaskId = x.auditTaskId
            this.findingIds = x.findingIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AuditMitigationActionsTaskTarget = AuditMitigationActionsTaskTarget(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
