// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an OTA update.
 */
public class OtaUpdateInfo private constructor(builder: Builder) {
    /**
     * A collection of name/value pairs
     */
    public val additionalParameters: Map<String, String>? = builder.additionalParameters
    /**
     * The IoT job ARN associated with the OTA update.
     */
    public val awsIotJobArn: kotlin.String? = builder.awsIotJobArn
    /**
     * The IoT job ID associated with the OTA update.
     */
    public val awsIotJobId: kotlin.String? = builder.awsIotJobId
    /**
     * Configuration for the rollout of OTA updates.
     */
    public val awsJobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig? = builder.awsJobExecutionsRolloutConfig
    /**
     * Configuration information for pre-signed URLs. Valid when `protocols` contains HTTP.
     */
    public val awsJobPresignedUrlConfig: aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig? = builder.awsJobPresignedUrlConfig
    /**
     * The date when the OTA update was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A description of the OTA update.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Error information associated with the OTA update.
     */
    public val errorInfo: aws.sdk.kotlin.services.iot.model.ErrorInfo? = builder.errorInfo
    /**
     * The date when the OTA update was last updated.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The OTA update ARN.
     */
    public val otaUpdateArn: kotlin.String? = builder.otaUpdateArn
    /**
     * A list of files associated with the OTA update.
     */
    public val otaUpdateFiles: List<OtaUpdateFile>? = builder.otaUpdateFiles
    /**
     * The OTA update ID.
     */
    public val otaUpdateId: kotlin.String? = builder.otaUpdateId
    /**
     * The status of the OTA update.
     */
    public val otaUpdateStatus: aws.sdk.kotlin.services.iot.model.OtaUpdateStatus? = builder.otaUpdateStatus
    /**
     * The protocol used to transfer the OTA update image. Valid values are &#91;HTTP&#93;, &#91;MQTT&#93;, &#91;HTTP, MQTT&#93;. When both HTTP and MQTT are specified, the target device can choose the protocol.
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when the thing is added to a target group, even after the OTA update was completed by all things originally in the group.
     */
    public val targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = builder.targetSelection
    /**
     * The targets of the OTA update.
     */
    public val targets: List<String>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.OtaUpdateInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OtaUpdateInfo(")
        append("additionalParameters=$additionalParameters,")
        append("awsIotJobArn=$awsIotJobArn,")
        append("awsIotJobId=$awsIotJobId,")
        append("awsJobExecutionsRolloutConfig=$awsJobExecutionsRolloutConfig,")
        append("awsJobPresignedUrlConfig=$awsJobPresignedUrlConfig,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("errorInfo=$errorInfo,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("otaUpdateArn=$otaUpdateArn,")
        append("otaUpdateFiles=$otaUpdateFiles,")
        append("otaUpdateId=$otaUpdateId,")
        append("otaUpdateStatus=$otaUpdateStatus,")
        append("protocols=$protocols,")
        append("targetSelection=$targetSelection,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalParameters?.hashCode() ?: 0
        result = 31 * result + (awsIotJobArn?.hashCode() ?: 0)
        result = 31 * result + (awsIotJobId?.hashCode() ?: 0)
        result = 31 * result + (awsJobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (awsJobPresignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (otaUpdateArn?.hashCode() ?: 0)
        result = 31 * result + (otaUpdateFiles?.hashCode() ?: 0)
        result = 31 * result + (otaUpdateId?.hashCode() ?: 0)
        result = 31 * result + (otaUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (targetSelection?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OtaUpdateInfo

        if (additionalParameters != other.additionalParameters) return false
        if (awsIotJobArn != other.awsIotJobArn) return false
        if (awsIotJobId != other.awsIotJobId) return false
        if (awsJobExecutionsRolloutConfig != other.awsJobExecutionsRolloutConfig) return false
        if (awsJobPresignedUrlConfig != other.awsJobPresignedUrlConfig) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (errorInfo != other.errorInfo) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (otaUpdateArn != other.otaUpdateArn) return false
        if (otaUpdateFiles != other.otaUpdateFiles) return false
        if (otaUpdateId != other.otaUpdateId) return false
        if (otaUpdateStatus != other.otaUpdateStatus) return false
        if (protocols != other.protocols) return false
        if (targetSelection != other.targetSelection) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.OtaUpdateInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A collection of name/value pairs
         */
        public var additionalParameters: Map<String, String>? = null
        /**
         * The IoT job ARN associated with the OTA update.
         */
        public var awsIotJobArn: kotlin.String? = null
        /**
         * The IoT job ID associated with the OTA update.
         */
        public var awsIotJobId: kotlin.String? = null
        /**
         * Configuration for the rollout of OTA updates.
         */
        public var awsJobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig? = null
        /**
         * Configuration information for pre-signed URLs. Valid when `protocols` contains HTTP.
         */
        public var awsJobPresignedUrlConfig: aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig? = null
        /**
         * The date when the OTA update was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the OTA update.
         */
        public var description: kotlin.String? = null
        /**
         * Error information associated with the OTA update.
         */
        public var errorInfo: aws.sdk.kotlin.services.iot.model.ErrorInfo? = null
        /**
         * The date when the OTA update was last updated.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The OTA update ARN.
         */
        public var otaUpdateArn: kotlin.String? = null
        /**
         * A list of files associated with the OTA update.
         */
        public var otaUpdateFiles: List<OtaUpdateFile>? = null
        /**
         * The OTA update ID.
         */
        public var otaUpdateId: kotlin.String? = null
        /**
         * The status of the OTA update.
         */
        public var otaUpdateStatus: aws.sdk.kotlin.services.iot.model.OtaUpdateStatus? = null
        /**
         * The protocol used to transfer the OTA update image. Valid values are &#91;HTTP&#93;, &#91;MQTT&#93;, &#91;HTTP, MQTT&#93;. When both HTTP and MQTT are specified, the target device can choose the protocol.
         */
        public var protocols: List<Protocol>? = null
        /**
         * Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when the thing is added to a target group, even after the OTA update was completed by all things originally in the group.
         */
        public var targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = null
        /**
         * The targets of the OTA update.
         */
        public var targets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.OtaUpdateInfo) : this() {
            this.additionalParameters = x.additionalParameters
            this.awsIotJobArn = x.awsIotJobArn
            this.awsIotJobId = x.awsIotJobId
            this.awsJobExecutionsRolloutConfig = x.awsJobExecutionsRolloutConfig
            this.awsJobPresignedUrlConfig = x.awsJobPresignedUrlConfig
            this.creationDate = x.creationDate
            this.description = x.description
            this.errorInfo = x.errorInfo
            this.lastModifiedDate = x.lastModifiedDate
            this.otaUpdateArn = x.otaUpdateArn
            this.otaUpdateFiles = x.otaUpdateFiles
            this.otaUpdateId = x.otaUpdateId
            this.otaUpdateStatus = x.otaUpdateStatus
            this.protocols = x.protocols
            this.targetSelection = x.targetSelection
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.OtaUpdateInfo = OtaUpdateInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig] inside the given [block]
         */
        public fun awsJobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.awsJobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig] inside the given [block]
         */
        public fun awsJobPresignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.awsJobPresignedUrlConfig = aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ErrorInfo] inside the given [block]
         */
        public fun errorInfo(block: aws.sdk.kotlin.services.iot.model.ErrorInfo.Builder.() -> kotlin.Unit) {
            this.errorInfo = aws.sdk.kotlin.services.iot.model.ErrorInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
