// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.DescribeMitigationActionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.MitigationActionParams
import aws.sdk.kotlin.services.iot.model.MitigationActionType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeMitigationActionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMitigationActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMitigationActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMitigationActionError(context, call, payload)
        }
        val builder = DescribeMitigationActionResponse.Builder()

        if (payload != null) {
            deserializeDescribeMitigationActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMitigationActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMitigationActionOperationBody(builder: DescribeMitigationActionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionArn"))
    val ACTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionId"))
    val ACTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionName"))
    val ACTIONPARAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("actionParams"))
    val ACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("actionType"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONARN_DESCRIPTOR)
        field(ACTIONID_DESCRIPTOR)
        field(ACTIONNAME_DESCRIPTOR)
        field(ACTIONPARAMS_DESCRIPTOR)
        field(ACTIONTYPE_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONARN_DESCRIPTOR.index -> builder.actionArn = deserializeString()
                ACTIONID_DESCRIPTOR.index -> builder.actionId = deserializeString()
                ACTIONNAME_DESCRIPTOR.index -> builder.actionName = deserializeString()
                ACTIONPARAMS_DESCRIPTOR.index -> builder.actionParams = deserializeMitigationActionParamsDocument(deserializer)
                ACTIONTYPE_DESCRIPTOR.index -> builder.actionType = deserializeString().let { MitigationActionType.fromValue(it) }
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
