// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.CreateOtaUpdateResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.OtaUpdateStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOTAUpdateOperationDeserializer: HttpDeserializer.NonStreaming<CreateOtaUpdateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateOtaUpdateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateOtaUpdateError(context, call, payload)
        }
        val builder = CreateOtaUpdateResponse.Builder()

        if (payload != null) {
            deserializeCreateOTAUpdateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateOtaUpdateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOTAUpdateOperationBody(builder: CreateOtaUpdateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSIOTJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsIotJobArn"))
    val AWSIOTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsIotJobId"))
    val OTAUPDATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("otaUpdateArn"))
    val OTAUPDATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("otaUpdateId"))
    val OTAUPDATESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("otaUpdateStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSIOTJOBARN_DESCRIPTOR)
        field(AWSIOTJOBID_DESCRIPTOR)
        field(OTAUPDATEARN_DESCRIPTOR)
        field(OTAUPDATEID_DESCRIPTOR)
        field(OTAUPDATESTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSIOTJOBARN_DESCRIPTOR.index -> builder.awsIotJobArn = deserializeString()
                AWSIOTJOBID_DESCRIPTOR.index -> builder.awsIotJobId = deserializeString()
                OTAUPDATEARN_DESCRIPTOR.index -> builder.otaUpdateArn = deserializeString()
                OTAUPDATEID_DESCRIPTOR.index -> builder.otaUpdateId = deserializeString()
                OTAUPDATESTATUS_DESCRIPTOR.index -> builder.otaUpdateStatus = deserializeString().let { OtaUpdateStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
