// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the topic rule destination.
 */
public class TopicRuleDestinationSummary private constructor(builder: Builder) {
    /**
     * The topic rule destination ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time when the topic rule destination was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Information about the HTTP URL.
     */
    public val httpUrlSummary: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary? = builder.httpUrlSummary
    /**
     * The date and time when the topic rule destination was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The status of the topic rule destination. Valid values are:
     *
     * ## IN_PROGRESS
     * A topic rule destination was created but has not been confirmed. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     *
     * ## ENABLED
     * Confirmation was completed, and traffic to this destination is allowed. You can set `status` to `DISABLED` by calling `UpdateTopicRuleDestination`.
     *
     * ## DISABLED
     * Confirmation was completed, and traffic to this destination is not allowed. You can set `status` to `ENABLED` by calling `UpdateTopicRuleDestination`.
     *
     * ## ERROR
     * Confirmation could not be completed, for example if the confirmation timed out. You can call `GetTopicRuleDestination` for details about the error. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     */
    public val status: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationStatus? = builder.status
    /**
     * The reason the topic rule destination is in the current status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * Information about the virtual private cloud (VPC) connection.
     */
    public val vpcDestinationSummary: aws.sdk.kotlin.services.iot.model.VpcDestinationSummary? = builder.vpcDestinationSummary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicRuleDestinationSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("httpUrlSummary=$httpUrlSummary,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("vpcDestinationSummary=$vpcDestinationSummary")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (httpUrlSummary?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (vpcDestinationSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicRuleDestinationSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (httpUrlSummary != other.httpUrlSummary) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (vpcDestinationSummary != other.vpcDestinationSummary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The topic rule destination ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time when the topic rule destination was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the HTTP URL.
         */
        public var httpUrlSummary: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary? = null
        /**
         * The date and time when the topic rule destination was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the topic rule destination. Valid values are:
         *
         * ## IN_PROGRESS
         * A topic rule destination was created but has not been confirmed. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
         *
         * ## ENABLED
         * Confirmation was completed, and traffic to this destination is allowed. You can set `status` to `DISABLED` by calling `UpdateTopicRuleDestination`.
         *
         * ## DISABLED
         * Confirmation was completed, and traffic to this destination is not allowed. You can set `status` to `ENABLED` by calling `UpdateTopicRuleDestination`.
         *
         * ## ERROR
         * Confirmation could not be completed, for example if the confirmation timed out. You can call `GetTopicRuleDestination` for details about the error. You can set `status` to `IN_PROGRESS` by calling `UpdateTopicRuleDestination`. Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
         */
        public var status: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationStatus? = null
        /**
         * The reason the topic rule destination is in the current status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * Information about the virtual private cloud (VPC) connection.
         */
        public var vpcDestinationSummary: aws.sdk.kotlin.services.iot.model.VpcDestinationSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.httpUrlSummary = x.httpUrlSummary
            this.lastUpdatedAt = x.lastUpdatedAt
            this.status = x.status
            this.statusReason = x.statusReason
            this.vpcDestinationSummary = x.vpcDestinationSummary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary = TopicRuleDestinationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary] inside the given [block]
         */
        public fun httpUrlSummary(block: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary.Builder.() -> kotlin.Unit) {
            this.httpUrlSummary = aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.VpcDestinationSummary] inside the given [block]
         */
        public fun vpcDestinationSummary(block: aws.sdk.kotlin.services.iot.model.VpcDestinationSummary.Builder.() -> kotlin.Unit) {
            this.vpcDestinationSummary = aws.sdk.kotlin.services.iot.model.VpcDestinationSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
