// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information about a provisioning template.
 */
public class ProvisioningTemplateSummary private constructor(builder: Builder) {
    /**
     * The date when the provisioning template summary was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The description of the provisioning template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * True if the fleet provision template is enabled, otherwise false.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The date when the provisioning template summary was last modified.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The ARN of the provisioning template.
     */
    public val templateArn: kotlin.String? = builder.templateArn
    /**
     * The name of the provisioning template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The type you define in a provisioning template. You can create a template with only one type. You can't change the template type after its creation. The default value is `FLEET_PROVISIONING`. For more information about provisioning template, see: [Provisioning template](https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html).
     */
    public val type: aws.sdk.kotlin.services.iot.model.TemplateType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ProvisioningTemplateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisioningTemplateSummary(")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("templateArn=$templateArn,")
        append("templateName=$templateName,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (templateArn?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisioningTemplateSummary

        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (templateArn != other.templateArn) return false
        if (templateName != other.templateName) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ProvisioningTemplateSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date when the provisioning template summary was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the provisioning template.
         */
        public var description: kotlin.String? = null
        /**
         * True if the fleet provision template is enabled, otherwise false.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The date when the provisioning template summary was last modified.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the provisioning template.
         */
        public var templateArn: kotlin.String? = null
        /**
         * The name of the provisioning template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The type you define in a provisioning template. You can create a template with only one type. You can't change the template type after its creation. The default value is `FLEET_PROVISIONING`. For more information about provisioning template, see: [Provisioning template](https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html).
         */
        public var type: aws.sdk.kotlin.services.iot.model.TemplateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ProvisioningTemplateSummary) : this() {
            this.creationDate = x.creationDate
            this.description = x.description
            this.enabled = x.enabled
            this.lastModifiedDate = x.lastModifiedDate
            this.templateArn = x.templateArn
            this.templateName = x.templateName
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ProvisioningTemplateSummary = ProvisioningTemplateSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
