// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAuthorizerRequest private constructor(builder: Builder) {
    /**
     * The ARN of the authorizer's Lambda function.
     */
    public val authorizerFunctionArn: kotlin.String? = builder.authorizerFunctionArn
    /**
     * The authorizer name.
     */
    public val authorizerName: kotlin.String? = builder.authorizerName
    /**
     * When `true`, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in `refreshAfterInSeconds`. This value does not affect authorization of clients that use MQTT connections.
     *
     * The default value is `false`.
     */
    public val enableCachingForHttp: kotlin.Boolean? = builder.enableCachingForHttp
    /**
     * Specifies whether IoT validates the token signature in an authorization request.
     */
    public val signingDisabled: kotlin.Boolean? = builder.signingDisabled
    /**
     * The status of the create authorizer request.
     */
    public val status: aws.sdk.kotlin.services.iot.model.AuthorizerStatus? = builder.status
    /**
     * Metadata which can be used to manage the custom authorizer.
     *
     * For URI Request parameters use format: ...key1=value1&key2=value2...
     *
     * For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     *
     * For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the token key used to extract the token from the HTTP headers.
     */
    public val tokenKeyName: kotlin.String? = builder.tokenKeyName
    /**
     * The public keys used to verify the digital signature returned by your custom authentication service.
     */
    public val tokenSigningPublicKeys: Map<String, String>? = builder.tokenSigningPublicKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateAuthorizerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAuthorizerRequest(")
        append("authorizerFunctionArn=$authorizerFunctionArn,")
        append("authorizerName=$authorizerName,")
        append("enableCachingForHttp=$enableCachingForHttp,")
        append("signingDisabled=$signingDisabled,")
        append("status=$status,")
        append("tags=$tags,")
        append("tokenKeyName=$tokenKeyName,")
        append("tokenSigningPublicKeys=$tokenSigningPublicKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerFunctionArn?.hashCode() ?: 0
        result = 31 * result + (authorizerName?.hashCode() ?: 0)
        result = 31 * result + (enableCachingForHttp?.hashCode() ?: 0)
        result = 31 * result + (signingDisabled?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tokenKeyName?.hashCode() ?: 0)
        result = 31 * result + (tokenSigningPublicKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAuthorizerRequest

        if (authorizerFunctionArn != other.authorizerFunctionArn) return false
        if (authorizerName != other.authorizerName) return false
        if (enableCachingForHttp != other.enableCachingForHttp) return false
        if (signingDisabled != other.signingDisabled) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (tokenKeyName != other.tokenKeyName) return false
        if (tokenSigningPublicKeys != other.tokenSigningPublicKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateAuthorizerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the authorizer's Lambda function.
         */
        public var authorizerFunctionArn: kotlin.String? = null
        /**
         * The authorizer name.
         */
        public var authorizerName: kotlin.String? = null
        /**
         * When `true`, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in `refreshAfterInSeconds`. This value does not affect authorization of clients that use MQTT connections.
         *
         * The default value is `false`.
         */
        public var enableCachingForHttp: kotlin.Boolean? = null
        /**
         * Specifies whether IoT validates the token signature in an authorization request.
         */
        public var signingDisabled: kotlin.Boolean? = null
        /**
         * The status of the create authorizer request.
         */
        public var status: aws.sdk.kotlin.services.iot.model.AuthorizerStatus? = null
        /**
         * Metadata which can be used to manage the custom authorizer.
         *
         * For URI Request parameters use format: ...key1=value1&key2=value2...
         *
         * For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
         *
         * For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the token key used to extract the token from the HTTP headers.
         */
        public var tokenKeyName: kotlin.String? = null
        /**
         * The public keys used to verify the digital signature returned by your custom authentication service.
         */
        public var tokenSigningPublicKeys: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateAuthorizerRequest) : this() {
            this.authorizerFunctionArn = x.authorizerFunctionArn
            this.authorizerName = x.authorizerName
            this.enableCachingForHttp = x.enableCachingForHttp
            this.signingDisabled = x.signingDisabled
            this.status = x.status
            this.tags = x.tags
            this.tokenKeyName = x.tokenKeyName
            this.tokenSigningPublicKeys = x.tokenSigningPublicKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateAuthorizerRequest = CreateAuthorizerRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
