// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.TransferCertificateRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class TransferCertificateOperationSerializer: HttpSerializer.NonStreaming<TransferCertificateRequest> {
    override fun serialize(context: ExecutionContext, input: TransferCertificateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.certificateId) { "certificateId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("transfer-certificate"))
                add(PercentEncoding.SmithyLabel.encode("${input.certificateId}"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.targetAwsAccount != null) add("targetAwsAccount", input.targetAwsAccount)
            }
        }

        val payload = serializeTransferCertificateOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeTransferCertificateOperationBody(context: ExecutionContext, input: TransferCertificateRequest): ByteArray {
    val serializer = JsonSerializer()
    val TRANSFERMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("transferMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TRANSFERMESSAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.transferMessage?.let { field(TRANSFERMESSAGE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
