// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AuthorizerStatus
import aws.sdk.kotlin.services.iot.model.CreateAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAuthorizerOperationSerializer: HttpSerializer.NonStreaming<CreateAuthorizerRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAuthorizerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.authorizerName) { "authorizerName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("authorizer"))
                add(PercentEncoding.SmithyLabel.encode("${input.authorizerName}"))
            }
        }

        val payload = serializeCreateAuthorizerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAuthorizerOperationBody(context: ExecutionContext, input: CreateAuthorizerRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHORIZERFUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerFunctionArn"))
    val ENABLECACHINGFORHTTP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableCachingForHttp"))
    val SIGNINGDISABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("signingDisabled"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TOKENKEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenKeyName"))
    val TOKENSIGNINGPUBLICKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tokenSigningPublicKeys"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZERFUNCTIONARN_DESCRIPTOR)
        field(ENABLECACHINGFORHTTP_DESCRIPTOR)
        field(SIGNINGDISABLED_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TOKENKEYNAME_DESCRIPTOR)
        field(TOKENSIGNINGPUBLICKEYS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authorizerFunctionArn?.let { field(AUTHORIZERFUNCTIONARN_DESCRIPTOR, it) }
        input.enableCachingForHttp?.let { field(ENABLECACHINGFORHTTP_DESCRIPTOR, it) }
        input.signingDisabled?.let { field(SIGNINGDISABLED_DESCRIPTOR, it) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.tokenKeyName?.let { field(TOKENKEYNAME_DESCRIPTOR, it) }
        if (input.tokenSigningPublicKeys != null) {
            mapField(TOKENSIGNINGPUBLICKEYS_DESCRIPTOR) {
                input.tokenSigningPublicKeys.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
