// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an action to write data to an Amazon S3 bucket.
 */
public class S3Action private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information, see [S3 canned ACLs](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl).
     */
    public val cannedAcl: aws.sdk.kotlin.services.iot.model.CannedAccessControlList? = builder.cannedAcl
    /**
     * The object key. For more information, see [Actions, resources, and condition keys for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html).
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The ARN of the IAM role that grants access.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.S3Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Action(")
        append("bucketName=$bucketName,")
        append("cannedAcl=$cannedAcl,")
        append("key=$key,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (cannedAcl?.hashCode() ?: 0)
        result = 31 * result + (key.hashCode())
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Action

        if (bucketName != other.bucketName) return false
        if (cannedAcl != other.cannedAcl) return false
        if (key != other.key) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.S3Action = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information, see [S3 canned ACLs](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl).
         */
        public var cannedAcl: aws.sdk.kotlin.services.iot.model.CannedAccessControlList? = null
        /**
         * The object key. For more information, see [Actions, resources, and condition keys for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html).
         */
        public var key: kotlin.String? = null
        /**
         * The ARN of the IAM role that grants access.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.S3Action) : this() {
            this.bucketName = x.bucketName
            this.cannedAcl = x.cannedAcl
            this.key = x.key
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.S3Action = S3Action(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (key == null) key = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
