// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an action to republish to another topic.
 */
public class RepublishAction private constructor(builder: Builder) {
    /**
     * MQTT Version 5.0 headers information. For more information, see [ MQTT](https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html) from the Amazon Web Services IoT Core Developer Guide.
     */
    public val headers: aws.sdk.kotlin.services.iot.model.MqttHeaders? = builder.headers
    /**
     * The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
     */
    public val qos: kotlin.Int? = builder.qos
    /**
     * The ARN of the IAM role that grants access.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The name of the MQTT topic.
     */
    public val topic: kotlin.String = requireNotNull(builder.topic) { "A non-null value must be provided for topic" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.RepublishAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepublishAction(")
        append("headers=$headers,")
        append("qos=$qos,")
        append("roleArn=$roleArn,")
        append("topic=$topic")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers?.hashCode() ?: 0
        result = 31 * result + (qos ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (topic.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepublishAction

        if (headers != other.headers) return false
        if (qos != other.qos) return false
        if (roleArn != other.roleArn) return false
        if (topic != other.topic) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.RepublishAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * MQTT Version 5.0 headers information. For more information, see [ MQTT](https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html) from the Amazon Web Services IoT Core Developer Guide.
         */
        public var headers: aws.sdk.kotlin.services.iot.model.MqttHeaders? = null
        /**
         * The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
         */
        public var qos: kotlin.Int? = null
        /**
         * The ARN of the IAM role that grants access.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the MQTT topic.
         */
        public var topic: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.RepublishAction) : this() {
            this.headers = x.headers
            this.qos = x.qos
            this.roleArn = x.roleArn
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.RepublishAction = RepublishAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.MqttHeaders] inside the given [block]
         */
        public fun headers(block: aws.sdk.kotlin.services.iot.model.MqttHeaders.Builder.() -> kotlin.Unit) {
            this.headers = aws.sdk.kotlin.services.iot.model.MqttHeaders.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (topic == null) topic = ""
            return this
        }
    }
}
