// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sends an input to an IoT Events detector.
 */
public class IotEventsAction private constructor(builder: Builder) {
    /**
     * Whether to process the event actions as a batch. The default value is `false`.
     *
     * When `batchMode` is `true`, you can't specify a `messageId`.
     *
     * When `batchMode` is `true` and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when it's sent to IoT Events by calling `BatchPutMessage`[](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html). The resulting array can't have more than 10 messages.
     */
    public val batchMode: kotlin.Boolean? = builder.batchMode
    /**
     * The name of the IoT Events input.
     */
    public val inputName: kotlin.String = requireNotNull(builder.inputName) { "A non-null value must be provided for inputName" }
    /**
     * The ID of the message. The default `messageId` is a new UUID value.
     *
     * When `batchMode` is `true`, you can't specify a `messageId`--a new UUID value will be assigned.
     *
     * Assign a value to this property to ensure that only one input (message) with a given `messageId` will be processed by an IoT Events detector.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The ARN of the role that grants IoT permission to send an input to an IoT Events detector. ("Action":"iotevents:BatchPutMessage").
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.IotEventsAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IotEventsAction(")
        append("batchMode=$batchMode,")
        append("inputName=$inputName,")
        append("messageId=$messageId,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchMode?.hashCode() ?: 0
        result = 31 * result + (inputName.hashCode())
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IotEventsAction

        if (batchMode != other.batchMode) return false
        if (inputName != other.inputName) return false
        if (messageId != other.messageId) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.IotEventsAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to process the event actions as a batch. The default value is `false`.
         *
         * When `batchMode` is `true`, you can't specify a `messageId`.
         *
         * When `batchMode` is `true` and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when it's sent to IoT Events by calling `BatchPutMessage`[](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html). The resulting array can't have more than 10 messages.
         */
        public var batchMode: kotlin.Boolean? = null
        /**
         * The name of the IoT Events input.
         */
        public var inputName: kotlin.String? = null
        /**
         * The ID of the message. The default `messageId` is a new UUID value.
         *
         * When `batchMode` is `true`, you can't specify a `messageId`--a new UUID value will be assigned.
         *
         * Assign a value to this property to ensure that only one input (message) with a given `messageId` will be processed by an IoT Events detector.
         */
        public var messageId: kotlin.String? = null
        /**
         * The ARN of the role that grants IoT permission to send an input to an IoT Events detector. ("Action":"iotevents:BatchPutMessage").
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.IotEventsAction) : this() {
            this.batchMode = x.batchMode
            this.inputName = x.inputName
            this.messageId = x.messageId
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.IotEventsAction = IotEventsAction(this)

        internal fun correctErrors(): Builder {
            if (inputName == null) inputName = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
