// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateJobRequest private constructor(builder: Builder) {
    /**
     * Allows you to create the criteria to abort a job.
     */
    public val abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = builder.abortConfig
    /**
     * A short text description of the job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully completes. The package version must be in either the Published or Deprecated state when the job deploys. For more information, see [Package version lifecycle](https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle).
     *
     * **Note:**The following Length Constraints relates to a single ARN. Up to 25 package version ARNs are allowed.
     */
    public val destinationPackageVersions: List<String>? = builder.destinationPackageVersions
    /**
     * The job document. Required if you don't specify a value for `documentSource`.
     */
    public val document: kotlin.String? = builder.document
    /**
     * Parameters of an Amazon Web Services managed template that you can specify to create the job document.
     *
     * `documentParameters` can only be used when creating jobs from Amazon Web Services managed templates. This parameter can't be used with custom job templates or to create jobs from them.
     */
    public val documentParameters: Map<String, String>? = builder.documentParameters
    /**
     * An S3 link, or S3 object URL, to the job document. The link is an Amazon S3 object URL and is required if you don't specify a value for `document`.
     *
     * For example, `--document-source https://s3.<i>region-code</i>.amazonaws.com/example-firmware/device-firmware.1.0`
     *
     * For more information, see [Methods for accessing a bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html).
     */
    public val documentSource: kotlin.String? = builder.documentSource
    /**
     * Allows you to create the criteria to retry a job.
     */
    public val jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = builder.jobExecutionsRetryConfig
    /**
     * Allows you to create a staged rollout of the job.
     */
    public val jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The ARN of the job template used to create the job.
     */
    public val jobTemplateArn: kotlin.String? = builder.jobTemplateArn
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     *
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
     *
     * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
     *
     * The `namespaceId` feature is only supported by IoT Greengrass at this time. For more information, see [Setting up IoT Greengrass core devices.](https://docs.aws.amazon.com/greengrass/v2/developerguide/setting-up.html)
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * Configuration information for pre-signed S3 URLs.
     */
    public val presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = builder.presignedUrlConfig
    /**
     * The configuration that allows you to schedule a job for a future date and time in addition to specifying the end behavior for each job execution.
     */
    public val schedulingConfig: aws.sdk.kotlin.services.iot.model.SchedulingConfig? = builder.schedulingConfig
    /**
     * Metadata which can be used to manage the job.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.
     *
     * We recommend that you use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using continuous jobs, devices that join the group receive the job execution even after the job has been created.
     */
    public val targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = builder.targetSelection
    /**
     * A list of things and thing groups to which the job should be sent.
     */
    public val targets: List<String>? = builder.targets
    /**
     * Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to `TIMED_OUT`.
     */
    public val timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = builder.timeoutConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("abortConfig=$abortConfig,")
        append("description=$description,")
        append("destinationPackageVersions=$destinationPackageVersions,")
        append("document=$document,")
        append("documentParameters=$documentParameters,")
        append("documentSource=$documentSource,")
        append("jobExecutionsRetryConfig=$jobExecutionsRetryConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("jobId=$jobId,")
        append("jobTemplateArn=$jobTemplateArn,")
        append("namespaceId=$namespaceId,")
        append("presignedUrlConfig=$presignedUrlConfig,")
        append("schedulingConfig=$schedulingConfig,")
        append("tags=$tags,")
        append("targetSelection=$targetSelection,")
        append("targets=$targets,")
        append("timeoutConfig=$timeoutConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationPackageVersions?.hashCode() ?: 0)
        result = 31 * result + (document?.hashCode() ?: 0)
        result = 31 * result + (documentParameters?.hashCode() ?: 0)
        result = 31 * result + (documentSource?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRetryConfig?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobTemplateArn?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (presignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (schedulingConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetSelection?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (abortConfig != other.abortConfig) return false
        if (description != other.description) return false
        if (destinationPackageVersions != other.destinationPackageVersions) return false
        if (document != other.document) return false
        if (documentParameters != other.documentParameters) return false
        if (documentSource != other.documentSource) return false
        if (jobExecutionsRetryConfig != other.jobExecutionsRetryConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (jobId != other.jobId) return false
        if (jobTemplateArn != other.jobTemplateArn) return false
        if (namespaceId != other.namespaceId) return false
        if (presignedUrlConfig != other.presignedUrlConfig) return false
        if (schedulingConfig != other.schedulingConfig) return false
        if (tags != other.tags) return false
        if (targetSelection != other.targetSelection) return false
        if (targets != other.targets) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Allows you to create the criteria to abort a job.
         */
        public var abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = null
        /**
         * A short text description of the job.
         */
        public var description: kotlin.String? = null
        /**
         * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully completes. The package version must be in either the Published or Deprecated state when the job deploys. For more information, see [Package version lifecycle](https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle).
         *
         * **Note:**The following Length Constraints relates to a single ARN. Up to 25 package version ARNs are allowed.
         */
        public var destinationPackageVersions: List<String>? = null
        /**
         * The job document. Required if you don't specify a value for `documentSource`.
         */
        public var document: kotlin.String? = null
        /**
         * Parameters of an Amazon Web Services managed template that you can specify to create the job document.
         *
         * `documentParameters` can only be used when creating jobs from Amazon Web Services managed templates. This parameter can't be used with custom job templates or to create jobs from them.
         */
        public var documentParameters: Map<String, String>? = null
        /**
         * An S3 link, or S3 object URL, to the job document. The link is an Amazon S3 object URL and is required if you don't specify a value for `document`.
         *
         * For example, `--document-source https://s3.<i>region-code</i>.amazonaws.com/example-firmware/device-firmware.1.0`
         *
         * For more information, see [Methods for accessing a bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html).
         */
        public var documentSource: kotlin.String? = null
        /**
         * Allows you to create the criteria to retry a job.
         */
        public var jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = null
        /**
         * Allows you to create a staged rollout of the job.
         */
        public var jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = null
        /**
         * A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.
         */
        public var jobId: kotlin.String? = null
        /**
         * The ARN of the job template used to create the job.
         */
        public var jobTemplateArn: kotlin.String? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         *
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
         *
         * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
         *
         * The `namespaceId` feature is only supported by IoT Greengrass at this time. For more information, see [Setting up IoT Greengrass core devices.](https://docs.aws.amazon.com/greengrass/v2/developerguide/setting-up.html)
         */
        public var namespaceId: kotlin.String? = null
        /**
         * Configuration information for pre-signed S3 URLs.
         */
        public var presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = null
        /**
         * The configuration that allows you to schedule a job for a future date and time in addition to specifying the end behavior for each job execution.
         */
        public var schedulingConfig: aws.sdk.kotlin.services.iot.model.SchedulingConfig? = null
        /**
         * Metadata which can be used to manage the job.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.
         *
         * We recommend that you use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using continuous jobs, devices that join the group receive the job execution even after the job has been created.
         */
        public var targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = null
        /**
         * A list of things and thing groups to which the job should be sent.
         */
        public var targets: List<String>? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to `TIMED_OUT`.
         */
        public var timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateJobRequest) : this() {
            this.abortConfig = x.abortConfig
            this.description = x.description
            this.destinationPackageVersions = x.destinationPackageVersions
            this.document = x.document
            this.documentParameters = x.documentParameters
            this.documentSource = x.documentSource
            this.jobExecutionsRetryConfig = x.jobExecutionsRetryConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.jobId = x.jobId
            this.jobTemplateArn = x.jobTemplateArn
            this.namespaceId = x.namespaceId
            this.presignedUrlConfig = x.presignedUrlConfig
            this.schedulingConfig = x.schedulingConfig
            this.tags = x.tags
            this.targetSelection = x.targetSelection
            this.targets = x.targets
            this.timeoutConfig = x.timeoutConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AbortConfig] inside the given [block]
         */
        public fun abortConfig(block: aws.sdk.kotlin.services.iot.model.AbortConfig.Builder.() -> kotlin.Unit) {
            this.abortConfig = aws.sdk.kotlin.services.iot.model.AbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig] inside the given [block]
         */
        public fun jobExecutionsRetryConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRetryConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig] inside the given [block]
         */
        public fun jobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PresignedUrlConfig] inside the given [block]
         */
        public fun presignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.presignedUrlConfig = aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.SchedulingConfig] inside the given [block]
         */
        public fun schedulingConfig(block: aws.sdk.kotlin.services.iot.model.SchedulingConfig.Builder.() -> kotlin.Unit) {
            this.schedulingConfig = aws.sdk.kotlin.services.iot.model.SchedulingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimeoutConfig] inside the given [block]
         */
        public fun timeoutConfig(block: aws.sdk.kotlin.services.iot.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iot.model.TimeoutConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
