// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
 */
public class AwsJobTimeoutConfig private constructor(builder: Builder) {
    /**
     * Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal `TIMED_OUT` status.
     */
    public val inProgressTimeoutInMinutes: kotlin.Long? = builder.inProgressTimeoutInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsJobTimeoutConfig(")
        append("inProgressTimeoutInMinutes=$inProgressTimeoutInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inProgressTimeoutInMinutes?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsJobTimeoutConfig

        if (inProgressTimeoutInMinutes != other.inProgressTimeoutInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal `TIMED_OUT` status.
         */
        public var inProgressTimeoutInMinutes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig) : this() {
            this.inProgressTimeoutInMinutes = x.inProgressTimeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig = AwsJobTimeoutConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
