// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AbortConfig
import aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig
import aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig
import aws.sdk.kotlin.services.iot.model.PresignedUrlConfig
import aws.sdk.kotlin.services.iot.model.TimeoutConfig
import aws.sdk.kotlin.services.iot.model.UpdateJobRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateJobOperationSerializer: HttpSerializer.NonStreaming<UpdateJobRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.jobId) { "jobId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("jobs"))
                add(PercentEncoding.SmithyLabel.encode("${input.jobId}"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.namespaceId != null) add("namespaceId", input.namespaceId)
            }
        }

        val payload = serializeUpdateJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateJobOperationBody(context: ExecutionContext, input: UpdateJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ABORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("abortConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRetryConfig"))
    val JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRolloutConfig"))
    val PRESIGNEDURLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("presignedUrlConfig"))
    val TIMEOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timeoutConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABORTCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR)
        field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR)
        field(PRESIGNEDURLCONFIG_DESCRIPTOR)
        field(TIMEOUTCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.abortConfig?.let { field(ABORTCONFIG_DESCRIPTOR, it, ::serializeAbortConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.jobExecutionsRetryConfig?.let { field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR, it, ::serializeJobExecutionsRetryConfigDocument) }
        input.jobExecutionsRolloutConfig?.let { field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR, it, ::serializeJobExecutionsRolloutConfigDocument) }
        input.presignedUrlConfig?.let { field(PRESIGNEDURLCONFIG_DESCRIPTOR, it, ::serializePresignedUrlConfigDocument) }
        input.timeoutConfig?.let { field(TIMEOUTCONFIG_DESCRIPTOR, it, ::serializeTimeoutConfigDocument) }
    }
    return serializer.toByteArray()
}
