// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.DetectMitigationActionsTaskTarget
import aws.sdk.kotlin.services.iot.model.StartDetectMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.ViolationEventOccurrenceRange
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartDetectMitigationActionsTaskOperationSerializer: HttpSerializer.NonStreaming<StartDetectMitigationActionsTaskRequest> {
    override fun serialize(context: ExecutionContext, input: StartDetectMitigationActionsTaskRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.taskId) { "taskId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("detect"))
                add(PercentEncoding.Path.encode("mitigationactions"))
                add(PercentEncoding.Path.encode("tasks"))
                add(PercentEncoding.SmithyLabel.encode("${input.taskId}"))
            }
        }

        val payload = serializeStartDetectMitigationActionsTaskOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartDetectMitigationActionsTaskOperationBody(context: ExecutionContext, input: StartDetectMitigationActionsTaskRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actions"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val INCLUDEONLYACTIVEVIOLATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("includeOnlyActiveViolations"))
    val INCLUDESUPPRESSEDALERTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("includeSuppressedAlerts"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("target"))
    val VIOLATIONEVENTOCCURRENCERANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("violationEventOccurrenceRange"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(INCLUDEONLYACTIVEVIOLATIONS_DESCRIPTOR)
        field(INCLUDESUPPRESSEDALERTS_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
        field(VIOLATIONEVENTOCCURRENCERANGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.actions != null) {
            listField(ACTIONS_DESCRIPTOR) {
                for (el0 in input.actions) {
                    serializeString(el0)
                }
            }
        }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.includeOnlyActiveViolations?.let { field(INCLUDEONLYACTIVEVIOLATIONS_DESCRIPTOR, it) }
        input.includeSuppressedAlerts?.let { field(INCLUDESUPPRESSEDALERTS_DESCRIPTOR, it) }
        input.target?.let { field(TARGET_DESCRIPTOR, it, ::serializeDetectMitigationActionsTaskTargetDocument) }
        input.violationEventOccurrenceRange?.let { field(VIOLATIONEVENTOCCURRENCERANGE_DESCRIPTOR, it, ::serializeViolationEventOccurrenceRangeDocument) }
    }
    return serializer.toByteArray()
}
