// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



public class CreateOtaUpdateRequest private constructor(builder: Builder) {
    /**
     * A list of additional OTA update parameters, which are name-value pairs. They won't be sent to devices as a part of the Job document.
     */
    public val additionalParameters: Map<String, String>? = builder.additionalParameters
    /**
     * The criteria that determine when and how a job abort takes place.
     */
    public val awsJobAbortConfig: aws.sdk.kotlin.services.iot.model.AwsJobAbortConfig? = builder.awsJobAbortConfig
    /**
     * Configuration for the rollout of OTA updates.
     */
    public val awsJobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig? = builder.awsJobExecutionsRolloutConfig
    /**
     * Configuration information for pre-signed URLs.
     */
    public val awsJobPresignedUrlConfig: aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig? = builder.awsJobPresignedUrlConfig
    /**
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
     */
    public val awsJobTimeoutConfig: aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig? = builder.awsJobTimeoutConfig
    /**
     * The description of the OTA update.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The files to be streamed by the OTA update.
     */
    public val files: List<OtaUpdateFile>? = builder.files
    /**
     * The ID of the OTA update to be created.
     */
    public val otaUpdateId: kotlin.String? = builder.otaUpdateId
    /**
     * The protocol used to transfer the OTA update image. Valid values are &#91;HTTP&#93;, &#91;MQTT&#93;, &#91;HTTP, MQTT&#93;. When both HTTP and MQTT are specified, the target device can choose the protocol.
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Metadata which can be used to manage updates.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
     */
    public val targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = builder.targetSelection
    /**
     * The devices targeted to receive OTA updates.
     */
    public val targets: List<String>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateOtaUpdateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOtaUpdateRequest(")
        append("additionalParameters=$additionalParameters,")
        append("awsJobAbortConfig=$awsJobAbortConfig,")
        append("awsJobExecutionsRolloutConfig=$awsJobExecutionsRolloutConfig,")
        append("awsJobPresignedUrlConfig=$awsJobPresignedUrlConfig,")
        append("awsJobTimeoutConfig=$awsJobTimeoutConfig,")
        append("description=$description,")
        append("files=$files,")
        append("otaUpdateId=$otaUpdateId,")
        append("protocols=$protocols,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("targetSelection=$targetSelection,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalParameters?.hashCode() ?: 0
        result = 31 * result + (awsJobAbortConfig?.hashCode() ?: 0)
        result = 31 * result + (awsJobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (awsJobPresignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (awsJobTimeoutConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (files?.hashCode() ?: 0)
        result = 31 * result + (otaUpdateId?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetSelection?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOtaUpdateRequest

        if (additionalParameters != other.additionalParameters) return false
        if (awsJobAbortConfig != other.awsJobAbortConfig) return false
        if (awsJobExecutionsRolloutConfig != other.awsJobExecutionsRolloutConfig) return false
        if (awsJobPresignedUrlConfig != other.awsJobPresignedUrlConfig) return false
        if (awsJobTimeoutConfig != other.awsJobTimeoutConfig) return false
        if (description != other.description) return false
        if (files != other.files) return false
        if (otaUpdateId != other.otaUpdateId) return false
        if (protocols != other.protocols) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (targetSelection != other.targetSelection) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateOtaUpdateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of additional OTA update parameters, which are name-value pairs. They won't be sent to devices as a part of the Job document.
         */
        public var additionalParameters: Map<String, String>? = null
        /**
         * The criteria that determine when and how a job abort takes place.
         */
        public var awsJobAbortConfig: aws.sdk.kotlin.services.iot.model.AwsJobAbortConfig? = null
        /**
         * Configuration for the rollout of OTA updates.
         */
        public var awsJobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig? = null
        /**
         * Configuration information for pre-signed URLs.
         */
        public var awsJobPresignedUrlConfig: aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
         */
        public var awsJobTimeoutConfig: aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig? = null
        /**
         * The description of the OTA update.
         */
        public var description: kotlin.String? = null
        /**
         * The files to be streamed by the OTA update.
         */
        public var files: List<OtaUpdateFile>? = null
        /**
         * The ID of the OTA update to be created.
         */
        public var otaUpdateId: kotlin.String? = null
        /**
         * The protocol used to transfer the OTA update image. Valid values are &#91;HTTP&#93;, &#91;MQTT&#93;, &#91;HTTP, MQTT&#93;. When both HTTP and MQTT are specified, the target device can choose the protocol.
         */
        public var protocols: List<Protocol>? = null
        /**
         * The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Metadata which can be used to manage updates.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
         */
        public var targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = null
        /**
         * The devices targeted to receive OTA updates.
         */
        public var targets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateOtaUpdateRequest) : this() {
            this.additionalParameters = x.additionalParameters
            this.awsJobAbortConfig = x.awsJobAbortConfig
            this.awsJobExecutionsRolloutConfig = x.awsJobExecutionsRolloutConfig
            this.awsJobPresignedUrlConfig = x.awsJobPresignedUrlConfig
            this.awsJobTimeoutConfig = x.awsJobTimeoutConfig
            this.description = x.description
            this.files = x.files
            this.otaUpdateId = x.otaUpdateId
            this.protocols = x.protocols
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.targetSelection = x.targetSelection
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateOtaUpdateRequest = CreateOtaUpdateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobAbortConfig] inside the given [block]
         */
        public fun awsJobAbortConfig(block: aws.sdk.kotlin.services.iot.model.AwsJobAbortConfig.Builder.() -> kotlin.Unit) {
            this.awsJobAbortConfig = aws.sdk.kotlin.services.iot.model.AwsJobAbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig] inside the given [block]
         */
        public fun awsJobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.awsJobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.AwsJobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig] inside the given [block]
         */
        public fun awsJobPresignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.awsJobPresignedUrlConfig = aws.sdk.kotlin.services.iot.model.AwsJobPresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig] inside the given [block]
         */
        public fun awsJobTimeoutConfig(block: aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig.Builder.() -> kotlin.Unit) {
            this.awsJobTimeoutConfig = aws.sdk.kotlin.services.iot.model.AwsJobTimeoutConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
