// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.UpdateProvisioningTemplateResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateProvisioningTemplateOperationDeserializer: HttpDeserialize<UpdateProvisioningTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateProvisioningTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateProvisioningTemplateError(context, call)
        }
        val builder = UpdateProvisioningTemplateResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateProvisioningTemplateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictingResourceUpdateException" -> ConflictingResourceUpdateExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
