// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.GetV2LoggingOptionsResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.LogLevel
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetV2LoggingOptionsOperationDeserializer: HttpDeserialize<GetV2LoggingOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetV2LoggingOptionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetV2LoggingOptionsError(context, call)
        }
        val builder = GetV2LoggingOptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetV2LoggingOptionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetV2LoggingOptionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "NotConfiguredException" -> NotConfiguredExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetV2LoggingOptionsOperationBody(builder: GetV2LoggingOptionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEFAULTLOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("defaultLogLevel"))
    val DISABLEALLLOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableAllLogs"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTLOGLEVEL_DESCRIPTOR)
        field(DISABLEALLLOGS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEFAULTLOGLEVEL_DESCRIPTOR.index -> builder.defaultLogLevel = deserializeString().let { LogLevel.fromValue(it) }
                DISABLEALLLOGS_DESCRIPTOR.index -> builder.disableAllLogs = deserializeBoolean()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
