// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AuditMitigationActionsTaskStatus
import aws.sdk.kotlin.services.iot.model.AuditMitigationActionsTaskTarget
import aws.sdk.kotlin.services.iot.model.DescribeAuditMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.MitigationAction
import aws.sdk.kotlin.services.iot.model.TaskStatisticsForAuditCheck
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeAuditMitigationActionsTaskOperationDeserializer: HttpDeserialize<DescribeAuditMitigationActionsTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeAuditMitigationActionsTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAuditMitigationActionsTaskError(context, call)
        }
        val builder = DescribeAuditMitigationActionsTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAuditMitigationActionsTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeAuditMitigationActionsTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAuditMitigationActionsTaskOperationBody(builder: DescribeAuditMitigationActionsTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONSDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actionsDefinition"))
    val AUDITCHECKTOACTIONSMAPPING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("auditCheckToActionsMapping"))
    val AUDITCHECKTOACTIONSMAPPING_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("target"))
    val TASKSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("taskStatistics"))
    val TASKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("taskStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONSDEFINITION_DESCRIPTOR)
        field(AUDITCHECKTOACTIONSMAPPING_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
        field(TASKSTATISTICS_DESCRIPTOR)
        field(TASKSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONSDEFINITION_DESCRIPTOR.index -> builder.actionsDefinition =
                    deserializer.deserializeList(ACTIONSDEFINITION_DESCRIPTOR) {
                        val col0 = mutableListOf<MitigationAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMitigationActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUDITCHECKTOACTIONSMAPPING_DESCRIPTOR.index -> builder.auditCheckToActionsMapping =
                    deserializer.deserializeMap(AUDITCHECKTOACTIONSMAPPING_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(AUDITCHECKTOACTIONSMAPPING_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<String>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TARGET_DESCRIPTOR.index -> builder.target = deserializeAuditMitigationActionsTaskTargetDocument(deserializer)
                TASKSTATISTICS_DESCRIPTOR.index -> builder.taskStatistics =
                    deserializer.deserializeMap(TASKSTATISTICS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, TaskStatisticsForAuditCheck>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeTaskStatisticsForAuditCheckDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TASKSTATUS_DESCRIPTOR.index -> builder.taskStatus = deserializeString().let { AuditMitigationActionsTaskStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
