// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iot.auth.DefaultIotAuthSchemeProvider
import aws.sdk.kotlin.services.iot.auth.IotAuthSchemeProvider
import aws.sdk.kotlin.services.iot.endpoints.DefaultIotEndpointProvider
import aws.sdk.kotlin.services.iot.endpoints.IotEndpointParameters
import aws.sdk.kotlin.services.iot.endpoints.IotEndpointProvider
import aws.sdk.kotlin.services.iot.model.AcceptCertificateTransferRequest
import aws.sdk.kotlin.services.iot.model.AcceptCertificateTransferResponse
import aws.sdk.kotlin.services.iot.model.AddThingToBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.AddThingToBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.AddThingToThingGroupRequest
import aws.sdk.kotlin.services.iot.model.AddThingToThingGroupResponse
import aws.sdk.kotlin.services.iot.model.AssociateTargetsWithJobRequest
import aws.sdk.kotlin.services.iot.model.AssociateTargetsWithJobResponse
import aws.sdk.kotlin.services.iot.model.AttachPolicyRequest
import aws.sdk.kotlin.services.iot.model.AttachPolicyResponse
import aws.sdk.kotlin.services.iot.model.AttachPrincipalPolicyRequest
import aws.sdk.kotlin.services.iot.model.AttachPrincipalPolicyResponse
import aws.sdk.kotlin.services.iot.model.AttachSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.AttachSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.AttachThingPrincipalRequest
import aws.sdk.kotlin.services.iot.model.AttachThingPrincipalResponse
import aws.sdk.kotlin.services.iot.model.CancelAuditMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.CancelAuditMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.CancelAuditTaskRequest
import aws.sdk.kotlin.services.iot.model.CancelAuditTaskResponse
import aws.sdk.kotlin.services.iot.model.CancelCertificateTransferRequest
import aws.sdk.kotlin.services.iot.model.CancelCertificateTransferResponse
import aws.sdk.kotlin.services.iot.model.CancelDetectMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.CancelDetectMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.CancelJobExecutionRequest
import aws.sdk.kotlin.services.iot.model.CancelJobExecutionResponse
import aws.sdk.kotlin.services.iot.model.CancelJobRequest
import aws.sdk.kotlin.services.iot.model.CancelJobResponse
import aws.sdk.kotlin.services.iot.model.ClearDefaultAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.ClearDefaultAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.ConfirmTopicRuleDestinationRequest
import aws.sdk.kotlin.services.iot.model.ConfirmTopicRuleDestinationResponse
import aws.sdk.kotlin.services.iot.model.CreateAuditSuppressionRequest
import aws.sdk.kotlin.services.iot.model.CreateAuditSuppressionResponse
import aws.sdk.kotlin.services.iot.model.CreateAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.CreateAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.CreateBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.CreateBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.CreateCertificateFromCsrRequest
import aws.sdk.kotlin.services.iot.model.CreateCertificateFromCsrResponse
import aws.sdk.kotlin.services.iot.model.CreateCertificateProviderRequest
import aws.sdk.kotlin.services.iot.model.CreateCertificateProviderResponse
import aws.sdk.kotlin.services.iot.model.CreateCustomMetricRequest
import aws.sdk.kotlin.services.iot.model.CreateCustomMetricResponse
import aws.sdk.kotlin.services.iot.model.CreateDimensionRequest
import aws.sdk.kotlin.services.iot.model.CreateDimensionResponse
import aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest
import aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationResponse
import aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupRequest
import aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupResponse
import aws.sdk.kotlin.services.iot.model.CreateFleetMetricRequest
import aws.sdk.kotlin.services.iot.model.CreateFleetMetricResponse
import aws.sdk.kotlin.services.iot.model.CreateJobRequest
import aws.sdk.kotlin.services.iot.model.CreateJobResponse
import aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest
import aws.sdk.kotlin.services.iot.model.CreateJobTemplateResponse
import aws.sdk.kotlin.services.iot.model.CreateKeysAndCertificateRequest
import aws.sdk.kotlin.services.iot.model.CreateKeysAndCertificateResponse
import aws.sdk.kotlin.services.iot.model.CreateMitigationActionRequest
import aws.sdk.kotlin.services.iot.model.CreateMitigationActionResponse
import aws.sdk.kotlin.services.iot.model.CreateOtaUpdateRequest
import aws.sdk.kotlin.services.iot.model.CreateOtaUpdateResponse
import aws.sdk.kotlin.services.iot.model.CreatePackageRequest
import aws.sdk.kotlin.services.iot.model.CreatePackageResponse
import aws.sdk.kotlin.services.iot.model.CreatePackageVersionRequest
import aws.sdk.kotlin.services.iot.model.CreatePackageVersionResponse
import aws.sdk.kotlin.services.iot.model.CreatePolicyRequest
import aws.sdk.kotlin.services.iot.model.CreatePolicyResponse
import aws.sdk.kotlin.services.iot.model.CreatePolicyVersionRequest
import aws.sdk.kotlin.services.iot.model.CreatePolicyVersionResponse
import aws.sdk.kotlin.services.iot.model.CreateProvisioningClaimRequest
import aws.sdk.kotlin.services.iot.model.CreateProvisioningClaimResponse
import aws.sdk.kotlin.services.iot.model.CreateProvisioningTemplateRequest
import aws.sdk.kotlin.services.iot.model.CreateProvisioningTemplateResponse
import aws.sdk.kotlin.services.iot.model.CreateProvisioningTemplateVersionRequest
import aws.sdk.kotlin.services.iot.model.CreateProvisioningTemplateVersionResponse
import aws.sdk.kotlin.services.iot.model.CreateRoleAliasRequest
import aws.sdk.kotlin.services.iot.model.CreateRoleAliasResponse
import aws.sdk.kotlin.services.iot.model.CreateScheduledAuditRequest
import aws.sdk.kotlin.services.iot.model.CreateScheduledAuditResponse
import aws.sdk.kotlin.services.iot.model.CreateSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.CreateSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.CreateStreamRequest
import aws.sdk.kotlin.services.iot.model.CreateStreamResponse
import aws.sdk.kotlin.services.iot.model.CreateThingGroupRequest
import aws.sdk.kotlin.services.iot.model.CreateThingGroupResponse
import aws.sdk.kotlin.services.iot.model.CreateThingRequest
import aws.sdk.kotlin.services.iot.model.CreateThingResponse
import aws.sdk.kotlin.services.iot.model.CreateThingTypeRequest
import aws.sdk.kotlin.services.iot.model.CreateThingTypeResponse
import aws.sdk.kotlin.services.iot.model.CreateTopicRuleDestinationRequest
import aws.sdk.kotlin.services.iot.model.CreateTopicRuleDestinationResponse
import aws.sdk.kotlin.services.iot.model.CreateTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.CreateTopicRuleResponse
import aws.sdk.kotlin.services.iot.model.DeleteAccountAuditConfigurationRequest
import aws.sdk.kotlin.services.iot.model.DeleteAccountAuditConfigurationResponse
import aws.sdk.kotlin.services.iot.model.DeleteAuditSuppressionRequest
import aws.sdk.kotlin.services.iot.model.DeleteAuditSuppressionResponse
import aws.sdk.kotlin.services.iot.model.DeleteAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.DeleteAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.DeleteBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.DeleteBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.DeleteCaCertificateRequest
import aws.sdk.kotlin.services.iot.model.DeleteCaCertificateResponse
import aws.sdk.kotlin.services.iot.model.DeleteCertificateProviderRequest
import aws.sdk.kotlin.services.iot.model.DeleteCertificateProviderResponse
import aws.sdk.kotlin.services.iot.model.DeleteCertificateRequest
import aws.sdk.kotlin.services.iot.model.DeleteCertificateResponse
import aws.sdk.kotlin.services.iot.model.DeleteCustomMetricRequest
import aws.sdk.kotlin.services.iot.model.DeleteCustomMetricResponse
import aws.sdk.kotlin.services.iot.model.DeleteDimensionRequest
import aws.sdk.kotlin.services.iot.model.DeleteDimensionResponse
import aws.sdk.kotlin.services.iot.model.DeleteDomainConfigurationRequest
import aws.sdk.kotlin.services.iot.model.DeleteDomainConfigurationResponse
import aws.sdk.kotlin.services.iot.model.DeleteDynamicThingGroupRequest
import aws.sdk.kotlin.services.iot.model.DeleteDynamicThingGroupResponse
import aws.sdk.kotlin.services.iot.model.DeleteFleetMetricRequest
import aws.sdk.kotlin.services.iot.model.DeleteFleetMetricResponse
import aws.sdk.kotlin.services.iot.model.DeleteJobExecutionRequest
import aws.sdk.kotlin.services.iot.model.DeleteJobExecutionResponse
import aws.sdk.kotlin.services.iot.model.DeleteJobRequest
import aws.sdk.kotlin.services.iot.model.DeleteJobResponse
import aws.sdk.kotlin.services.iot.model.DeleteJobTemplateRequest
import aws.sdk.kotlin.services.iot.model.DeleteJobTemplateResponse
import aws.sdk.kotlin.services.iot.model.DeleteMitigationActionRequest
import aws.sdk.kotlin.services.iot.model.DeleteMitigationActionResponse
import aws.sdk.kotlin.services.iot.model.DeleteOtaUpdateRequest
import aws.sdk.kotlin.services.iot.model.DeleteOtaUpdateResponse
import aws.sdk.kotlin.services.iot.model.DeletePackageRequest
import aws.sdk.kotlin.services.iot.model.DeletePackageResponse
import aws.sdk.kotlin.services.iot.model.DeletePackageVersionRequest
import aws.sdk.kotlin.services.iot.model.DeletePackageVersionResponse
import aws.sdk.kotlin.services.iot.model.DeletePolicyRequest
import aws.sdk.kotlin.services.iot.model.DeletePolicyResponse
import aws.sdk.kotlin.services.iot.model.DeletePolicyVersionRequest
import aws.sdk.kotlin.services.iot.model.DeletePolicyVersionResponse
import aws.sdk.kotlin.services.iot.model.DeleteProvisioningTemplateRequest
import aws.sdk.kotlin.services.iot.model.DeleteProvisioningTemplateResponse
import aws.sdk.kotlin.services.iot.model.DeleteProvisioningTemplateVersionRequest
import aws.sdk.kotlin.services.iot.model.DeleteProvisioningTemplateVersionResponse
import aws.sdk.kotlin.services.iot.model.DeleteRegistrationCodeRequest
import aws.sdk.kotlin.services.iot.model.DeleteRegistrationCodeResponse
import aws.sdk.kotlin.services.iot.model.DeleteRoleAliasRequest
import aws.sdk.kotlin.services.iot.model.DeleteRoleAliasResponse
import aws.sdk.kotlin.services.iot.model.DeleteScheduledAuditRequest
import aws.sdk.kotlin.services.iot.model.DeleteScheduledAuditResponse
import aws.sdk.kotlin.services.iot.model.DeleteSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.DeleteSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.DeleteStreamRequest
import aws.sdk.kotlin.services.iot.model.DeleteStreamResponse
import aws.sdk.kotlin.services.iot.model.DeleteThingGroupRequest
import aws.sdk.kotlin.services.iot.model.DeleteThingGroupResponse
import aws.sdk.kotlin.services.iot.model.DeleteThingRequest
import aws.sdk.kotlin.services.iot.model.DeleteThingResponse
import aws.sdk.kotlin.services.iot.model.DeleteThingTypeRequest
import aws.sdk.kotlin.services.iot.model.DeleteThingTypeResponse
import aws.sdk.kotlin.services.iot.model.DeleteTopicRuleDestinationRequest
import aws.sdk.kotlin.services.iot.model.DeleteTopicRuleDestinationResponse
import aws.sdk.kotlin.services.iot.model.DeleteTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.DeleteTopicRuleResponse
import aws.sdk.kotlin.services.iot.model.DeleteV2LoggingLevelRequest
import aws.sdk.kotlin.services.iot.model.DeleteV2LoggingLevelResponse
import aws.sdk.kotlin.services.iot.model.DeprecateThingTypeRequest
import aws.sdk.kotlin.services.iot.model.DeprecateThingTypeResponse
import aws.sdk.kotlin.services.iot.model.DescribeAccountAuditConfigurationRequest
import aws.sdk.kotlin.services.iot.model.DescribeAccountAuditConfigurationResponse
import aws.sdk.kotlin.services.iot.model.DescribeAuditFindingRequest
import aws.sdk.kotlin.services.iot.model.DescribeAuditFindingResponse
import aws.sdk.kotlin.services.iot.model.DescribeAuditMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.DescribeAuditMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.DescribeAuditSuppressionRequest
import aws.sdk.kotlin.services.iot.model.DescribeAuditSuppressionResponse
import aws.sdk.kotlin.services.iot.model.DescribeAuditTaskRequest
import aws.sdk.kotlin.services.iot.model.DescribeAuditTaskResponse
import aws.sdk.kotlin.services.iot.model.DescribeAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.DescribeAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.DescribeBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.DescribeBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.DescribeCaCertificateRequest
import aws.sdk.kotlin.services.iot.model.DescribeCaCertificateResponse
import aws.sdk.kotlin.services.iot.model.DescribeCertificateProviderRequest
import aws.sdk.kotlin.services.iot.model.DescribeCertificateProviderResponse
import aws.sdk.kotlin.services.iot.model.DescribeCertificateRequest
import aws.sdk.kotlin.services.iot.model.DescribeCertificateResponse
import aws.sdk.kotlin.services.iot.model.DescribeCustomMetricRequest
import aws.sdk.kotlin.services.iot.model.DescribeCustomMetricResponse
import aws.sdk.kotlin.services.iot.model.DescribeDefaultAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.DescribeDefaultAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.DescribeDetectMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.DescribeDetectMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.DescribeDimensionRequest
import aws.sdk.kotlin.services.iot.model.DescribeDimensionResponse
import aws.sdk.kotlin.services.iot.model.DescribeDomainConfigurationRequest
import aws.sdk.kotlin.services.iot.model.DescribeDomainConfigurationResponse
import aws.sdk.kotlin.services.iot.model.DescribeEndpointRequest
import aws.sdk.kotlin.services.iot.model.DescribeEndpointResponse
import aws.sdk.kotlin.services.iot.model.DescribeEventConfigurationsRequest
import aws.sdk.kotlin.services.iot.model.DescribeEventConfigurationsResponse
import aws.sdk.kotlin.services.iot.model.DescribeFleetMetricRequest
import aws.sdk.kotlin.services.iot.model.DescribeFleetMetricResponse
import aws.sdk.kotlin.services.iot.model.DescribeIndexRequest
import aws.sdk.kotlin.services.iot.model.DescribeIndexResponse
import aws.sdk.kotlin.services.iot.model.DescribeJobExecutionRequest
import aws.sdk.kotlin.services.iot.model.DescribeJobExecutionResponse
import aws.sdk.kotlin.services.iot.model.DescribeJobRequest
import aws.sdk.kotlin.services.iot.model.DescribeJobResponse
import aws.sdk.kotlin.services.iot.model.DescribeJobTemplateRequest
import aws.sdk.kotlin.services.iot.model.DescribeJobTemplateResponse
import aws.sdk.kotlin.services.iot.model.DescribeManagedJobTemplateRequest
import aws.sdk.kotlin.services.iot.model.DescribeManagedJobTemplateResponse
import aws.sdk.kotlin.services.iot.model.DescribeMitigationActionRequest
import aws.sdk.kotlin.services.iot.model.DescribeMitigationActionResponse
import aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateRequest
import aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateResponse
import aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateVersionRequest
import aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateVersionResponse
import aws.sdk.kotlin.services.iot.model.DescribeRoleAliasRequest
import aws.sdk.kotlin.services.iot.model.DescribeRoleAliasResponse
import aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditRequest
import aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditResponse
import aws.sdk.kotlin.services.iot.model.DescribeSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.DescribeSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.DescribeStreamRequest
import aws.sdk.kotlin.services.iot.model.DescribeStreamResponse
import aws.sdk.kotlin.services.iot.model.DescribeThingGroupRequest
import aws.sdk.kotlin.services.iot.model.DescribeThingGroupResponse
import aws.sdk.kotlin.services.iot.model.DescribeThingRegistrationTaskRequest
import aws.sdk.kotlin.services.iot.model.DescribeThingRegistrationTaskResponse
import aws.sdk.kotlin.services.iot.model.DescribeThingRequest
import aws.sdk.kotlin.services.iot.model.DescribeThingResponse
import aws.sdk.kotlin.services.iot.model.DescribeThingTypeRequest
import aws.sdk.kotlin.services.iot.model.DescribeThingTypeResponse
import aws.sdk.kotlin.services.iot.model.DetachPolicyRequest
import aws.sdk.kotlin.services.iot.model.DetachPolicyResponse
import aws.sdk.kotlin.services.iot.model.DetachPrincipalPolicyRequest
import aws.sdk.kotlin.services.iot.model.DetachPrincipalPolicyResponse
import aws.sdk.kotlin.services.iot.model.DetachSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.DetachSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.DetachThingPrincipalRequest
import aws.sdk.kotlin.services.iot.model.DetachThingPrincipalResponse
import aws.sdk.kotlin.services.iot.model.DisableTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.DisableTopicRuleResponse
import aws.sdk.kotlin.services.iot.model.EnableTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.EnableTopicRuleResponse
import aws.sdk.kotlin.services.iot.model.GetBehaviorModelTrainingSummariesRequest
import aws.sdk.kotlin.services.iot.model.GetBehaviorModelTrainingSummariesResponse
import aws.sdk.kotlin.services.iot.model.GetBucketsAggregationRequest
import aws.sdk.kotlin.services.iot.model.GetBucketsAggregationResponse
import aws.sdk.kotlin.services.iot.model.GetCardinalityRequest
import aws.sdk.kotlin.services.iot.model.GetCardinalityResponse
import aws.sdk.kotlin.services.iot.model.GetEffectivePoliciesRequest
import aws.sdk.kotlin.services.iot.model.GetEffectivePoliciesResponse
import aws.sdk.kotlin.services.iot.model.GetIndexingConfigurationRequest
import aws.sdk.kotlin.services.iot.model.GetIndexingConfigurationResponse
import aws.sdk.kotlin.services.iot.model.GetJobDocumentRequest
import aws.sdk.kotlin.services.iot.model.GetJobDocumentResponse
import aws.sdk.kotlin.services.iot.model.GetLoggingOptionsRequest
import aws.sdk.kotlin.services.iot.model.GetLoggingOptionsResponse
import aws.sdk.kotlin.services.iot.model.GetOtaUpdateRequest
import aws.sdk.kotlin.services.iot.model.GetOtaUpdateResponse
import aws.sdk.kotlin.services.iot.model.GetPackageConfigurationRequest
import aws.sdk.kotlin.services.iot.model.GetPackageConfigurationResponse
import aws.sdk.kotlin.services.iot.model.GetPackageRequest
import aws.sdk.kotlin.services.iot.model.GetPackageResponse
import aws.sdk.kotlin.services.iot.model.GetPackageVersionRequest
import aws.sdk.kotlin.services.iot.model.GetPackageVersionResponse
import aws.sdk.kotlin.services.iot.model.GetPercentilesRequest
import aws.sdk.kotlin.services.iot.model.GetPercentilesResponse
import aws.sdk.kotlin.services.iot.model.GetPolicyRequest
import aws.sdk.kotlin.services.iot.model.GetPolicyResponse
import aws.sdk.kotlin.services.iot.model.GetPolicyVersionRequest
import aws.sdk.kotlin.services.iot.model.GetPolicyVersionResponse
import aws.sdk.kotlin.services.iot.model.GetRegistrationCodeRequest
import aws.sdk.kotlin.services.iot.model.GetRegistrationCodeResponse
import aws.sdk.kotlin.services.iot.model.GetStatisticsRequest
import aws.sdk.kotlin.services.iot.model.GetStatisticsResponse
import aws.sdk.kotlin.services.iot.model.GetTopicRuleDestinationRequest
import aws.sdk.kotlin.services.iot.model.GetTopicRuleDestinationResponse
import aws.sdk.kotlin.services.iot.model.GetTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.GetTopicRuleResponse
import aws.sdk.kotlin.services.iot.model.GetV2LoggingOptionsRequest
import aws.sdk.kotlin.services.iot.model.GetV2LoggingOptionsResponse
import aws.sdk.kotlin.services.iot.model.ListActiveViolationsRequest
import aws.sdk.kotlin.services.iot.model.ListActiveViolationsResponse
import aws.sdk.kotlin.services.iot.model.ListAttachedPoliciesRequest
import aws.sdk.kotlin.services.iot.model.ListAttachedPoliciesResponse
import aws.sdk.kotlin.services.iot.model.ListAuditFindingsRequest
import aws.sdk.kotlin.services.iot.model.ListAuditFindingsResponse
import aws.sdk.kotlin.services.iot.model.ListAuditMitigationActionsExecutionsRequest
import aws.sdk.kotlin.services.iot.model.ListAuditMitigationActionsExecutionsResponse
import aws.sdk.kotlin.services.iot.model.ListAuditMitigationActionsTasksRequest
import aws.sdk.kotlin.services.iot.model.ListAuditMitigationActionsTasksResponse
import aws.sdk.kotlin.services.iot.model.ListAuditSuppressionsRequest
import aws.sdk.kotlin.services.iot.model.ListAuditSuppressionsResponse
import aws.sdk.kotlin.services.iot.model.ListAuditTasksRequest
import aws.sdk.kotlin.services.iot.model.ListAuditTasksResponse
import aws.sdk.kotlin.services.iot.model.ListAuthorizersRequest
import aws.sdk.kotlin.services.iot.model.ListAuthorizersResponse
import aws.sdk.kotlin.services.iot.model.ListBillingGroupsRequest
import aws.sdk.kotlin.services.iot.model.ListBillingGroupsResponse
import aws.sdk.kotlin.services.iot.model.ListCaCertificatesRequest
import aws.sdk.kotlin.services.iot.model.ListCaCertificatesResponse
import aws.sdk.kotlin.services.iot.model.ListCertificateProvidersRequest
import aws.sdk.kotlin.services.iot.model.ListCertificateProvidersResponse
import aws.sdk.kotlin.services.iot.model.ListCertificatesByCaRequest
import aws.sdk.kotlin.services.iot.model.ListCertificatesByCaResponse
import aws.sdk.kotlin.services.iot.model.ListCertificatesRequest
import aws.sdk.kotlin.services.iot.model.ListCertificatesResponse
import aws.sdk.kotlin.services.iot.model.ListCustomMetricsRequest
import aws.sdk.kotlin.services.iot.model.ListCustomMetricsResponse
import aws.sdk.kotlin.services.iot.model.ListDetectMitigationActionsExecutionsRequest
import aws.sdk.kotlin.services.iot.model.ListDetectMitigationActionsExecutionsResponse
import aws.sdk.kotlin.services.iot.model.ListDetectMitigationActionsTasksRequest
import aws.sdk.kotlin.services.iot.model.ListDetectMitigationActionsTasksResponse
import aws.sdk.kotlin.services.iot.model.ListDimensionsRequest
import aws.sdk.kotlin.services.iot.model.ListDimensionsResponse
import aws.sdk.kotlin.services.iot.model.ListDomainConfigurationsRequest
import aws.sdk.kotlin.services.iot.model.ListDomainConfigurationsResponse
import aws.sdk.kotlin.services.iot.model.ListFleetMetricsRequest
import aws.sdk.kotlin.services.iot.model.ListFleetMetricsResponse
import aws.sdk.kotlin.services.iot.model.ListIndicesRequest
import aws.sdk.kotlin.services.iot.model.ListIndicesResponse
import aws.sdk.kotlin.services.iot.model.ListJobExecutionsForJobRequest
import aws.sdk.kotlin.services.iot.model.ListJobExecutionsForJobResponse
import aws.sdk.kotlin.services.iot.model.ListJobExecutionsForThingRequest
import aws.sdk.kotlin.services.iot.model.ListJobExecutionsForThingResponse
import aws.sdk.kotlin.services.iot.model.ListJobTemplatesRequest
import aws.sdk.kotlin.services.iot.model.ListJobTemplatesResponse
import aws.sdk.kotlin.services.iot.model.ListJobsRequest
import aws.sdk.kotlin.services.iot.model.ListJobsResponse
import aws.sdk.kotlin.services.iot.model.ListManagedJobTemplatesRequest
import aws.sdk.kotlin.services.iot.model.ListManagedJobTemplatesResponse
import aws.sdk.kotlin.services.iot.model.ListMetricValuesRequest
import aws.sdk.kotlin.services.iot.model.ListMetricValuesResponse
import aws.sdk.kotlin.services.iot.model.ListMitigationActionsRequest
import aws.sdk.kotlin.services.iot.model.ListMitigationActionsResponse
import aws.sdk.kotlin.services.iot.model.ListOtaUpdatesRequest
import aws.sdk.kotlin.services.iot.model.ListOtaUpdatesResponse
import aws.sdk.kotlin.services.iot.model.ListOutgoingCertificatesRequest
import aws.sdk.kotlin.services.iot.model.ListOutgoingCertificatesResponse
import aws.sdk.kotlin.services.iot.model.ListPackageVersionsRequest
import aws.sdk.kotlin.services.iot.model.ListPackageVersionsResponse
import aws.sdk.kotlin.services.iot.model.ListPackagesRequest
import aws.sdk.kotlin.services.iot.model.ListPackagesResponse
import aws.sdk.kotlin.services.iot.model.ListPoliciesRequest
import aws.sdk.kotlin.services.iot.model.ListPoliciesResponse
import aws.sdk.kotlin.services.iot.model.ListPolicyPrincipalsRequest
import aws.sdk.kotlin.services.iot.model.ListPolicyPrincipalsResponse
import aws.sdk.kotlin.services.iot.model.ListPolicyVersionsRequest
import aws.sdk.kotlin.services.iot.model.ListPolicyVersionsResponse
import aws.sdk.kotlin.services.iot.model.ListPrincipalPoliciesRequest
import aws.sdk.kotlin.services.iot.model.ListPrincipalPoliciesResponse
import aws.sdk.kotlin.services.iot.model.ListPrincipalThingsRequest
import aws.sdk.kotlin.services.iot.model.ListPrincipalThingsResponse
import aws.sdk.kotlin.services.iot.model.ListProvisioningTemplateVersionsRequest
import aws.sdk.kotlin.services.iot.model.ListProvisioningTemplateVersionsResponse
import aws.sdk.kotlin.services.iot.model.ListProvisioningTemplatesRequest
import aws.sdk.kotlin.services.iot.model.ListProvisioningTemplatesResponse
import aws.sdk.kotlin.services.iot.model.ListRelatedResourcesForAuditFindingRequest
import aws.sdk.kotlin.services.iot.model.ListRelatedResourcesForAuditFindingResponse
import aws.sdk.kotlin.services.iot.model.ListRoleAliasesRequest
import aws.sdk.kotlin.services.iot.model.ListRoleAliasesResponse
import aws.sdk.kotlin.services.iot.model.ListScheduledAuditsRequest
import aws.sdk.kotlin.services.iot.model.ListScheduledAuditsResponse
import aws.sdk.kotlin.services.iot.model.ListSecurityProfilesForTargetRequest
import aws.sdk.kotlin.services.iot.model.ListSecurityProfilesForTargetResponse
import aws.sdk.kotlin.services.iot.model.ListSecurityProfilesRequest
import aws.sdk.kotlin.services.iot.model.ListSecurityProfilesResponse
import aws.sdk.kotlin.services.iot.model.ListStreamsRequest
import aws.sdk.kotlin.services.iot.model.ListStreamsResponse
import aws.sdk.kotlin.services.iot.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iot.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iot.model.ListTargetsForPolicyRequest
import aws.sdk.kotlin.services.iot.model.ListTargetsForPolicyResponse
import aws.sdk.kotlin.services.iot.model.ListTargetsForSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.ListTargetsForSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.ListThingGroupsForThingRequest
import aws.sdk.kotlin.services.iot.model.ListThingGroupsForThingResponse
import aws.sdk.kotlin.services.iot.model.ListThingGroupsRequest
import aws.sdk.kotlin.services.iot.model.ListThingGroupsResponse
import aws.sdk.kotlin.services.iot.model.ListThingPrincipalsRequest
import aws.sdk.kotlin.services.iot.model.ListThingPrincipalsResponse
import aws.sdk.kotlin.services.iot.model.ListThingRegistrationTaskReportsRequest
import aws.sdk.kotlin.services.iot.model.ListThingRegistrationTaskReportsResponse
import aws.sdk.kotlin.services.iot.model.ListThingRegistrationTasksRequest
import aws.sdk.kotlin.services.iot.model.ListThingRegistrationTasksResponse
import aws.sdk.kotlin.services.iot.model.ListThingTypesRequest
import aws.sdk.kotlin.services.iot.model.ListThingTypesResponse
import aws.sdk.kotlin.services.iot.model.ListThingsInBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.ListThingsInBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.ListThingsInThingGroupRequest
import aws.sdk.kotlin.services.iot.model.ListThingsInThingGroupResponse
import aws.sdk.kotlin.services.iot.model.ListThingsRequest
import aws.sdk.kotlin.services.iot.model.ListThingsResponse
import aws.sdk.kotlin.services.iot.model.ListTopicRuleDestinationsRequest
import aws.sdk.kotlin.services.iot.model.ListTopicRuleDestinationsResponse
import aws.sdk.kotlin.services.iot.model.ListTopicRulesRequest
import aws.sdk.kotlin.services.iot.model.ListTopicRulesResponse
import aws.sdk.kotlin.services.iot.model.ListV2LoggingLevelsRequest
import aws.sdk.kotlin.services.iot.model.ListV2LoggingLevelsResponse
import aws.sdk.kotlin.services.iot.model.ListViolationEventsRequest
import aws.sdk.kotlin.services.iot.model.ListViolationEventsResponse
import aws.sdk.kotlin.services.iot.model.PutVerificationStateOnViolationRequest
import aws.sdk.kotlin.services.iot.model.PutVerificationStateOnViolationResponse
import aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest
import aws.sdk.kotlin.services.iot.model.RegisterCaCertificateResponse
import aws.sdk.kotlin.services.iot.model.RegisterCertificateRequest
import aws.sdk.kotlin.services.iot.model.RegisterCertificateResponse
import aws.sdk.kotlin.services.iot.model.RegisterCertificateWithoutCaRequest
import aws.sdk.kotlin.services.iot.model.RegisterCertificateWithoutCaResponse
import aws.sdk.kotlin.services.iot.model.RegisterThingRequest
import aws.sdk.kotlin.services.iot.model.RegisterThingResponse
import aws.sdk.kotlin.services.iot.model.RejectCertificateTransferRequest
import aws.sdk.kotlin.services.iot.model.RejectCertificateTransferResponse
import aws.sdk.kotlin.services.iot.model.RemoveThingFromBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.RemoveThingFromBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.RemoveThingFromThingGroupRequest
import aws.sdk.kotlin.services.iot.model.RemoveThingFromThingGroupResponse
import aws.sdk.kotlin.services.iot.model.ReplaceTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.ReplaceTopicRuleResponse
import aws.sdk.kotlin.services.iot.model.SearchIndexRequest
import aws.sdk.kotlin.services.iot.model.SearchIndexResponse
import aws.sdk.kotlin.services.iot.model.SetDefaultAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.SetDefaultAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.SetDefaultPolicyVersionRequest
import aws.sdk.kotlin.services.iot.model.SetDefaultPolicyVersionResponse
import aws.sdk.kotlin.services.iot.model.SetLoggingOptionsRequest
import aws.sdk.kotlin.services.iot.model.SetLoggingOptionsResponse
import aws.sdk.kotlin.services.iot.model.SetV2LoggingLevelRequest
import aws.sdk.kotlin.services.iot.model.SetV2LoggingLevelResponse
import aws.sdk.kotlin.services.iot.model.SetV2LoggingOptionsRequest
import aws.sdk.kotlin.services.iot.model.SetV2LoggingOptionsResponse
import aws.sdk.kotlin.services.iot.model.StartAuditMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.StartAuditMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.StartDetectMitigationActionsTaskRequest
import aws.sdk.kotlin.services.iot.model.StartDetectMitigationActionsTaskResponse
import aws.sdk.kotlin.services.iot.model.StartOnDemandAuditTaskRequest
import aws.sdk.kotlin.services.iot.model.StartOnDemandAuditTaskResponse
import aws.sdk.kotlin.services.iot.model.StartThingRegistrationTaskRequest
import aws.sdk.kotlin.services.iot.model.StartThingRegistrationTaskResponse
import aws.sdk.kotlin.services.iot.model.StopThingRegistrationTaskRequest
import aws.sdk.kotlin.services.iot.model.StopThingRegistrationTaskResponse
import aws.sdk.kotlin.services.iot.model.TagResourceRequest
import aws.sdk.kotlin.services.iot.model.TagResourceResponse
import aws.sdk.kotlin.services.iot.model.TestAuthorizationRequest
import aws.sdk.kotlin.services.iot.model.TestAuthorizationResponse
import aws.sdk.kotlin.services.iot.model.TestInvokeAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.TestInvokeAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.TransferCertificateRequest
import aws.sdk.kotlin.services.iot.model.TransferCertificateResponse
import aws.sdk.kotlin.services.iot.model.UntagResourceRequest
import aws.sdk.kotlin.services.iot.model.UntagResourceResponse
import aws.sdk.kotlin.services.iot.model.UpdateAccountAuditConfigurationRequest
import aws.sdk.kotlin.services.iot.model.UpdateAccountAuditConfigurationResponse
import aws.sdk.kotlin.services.iot.model.UpdateAuditSuppressionRequest
import aws.sdk.kotlin.services.iot.model.UpdateAuditSuppressionResponse
import aws.sdk.kotlin.services.iot.model.UpdateAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.UpdateAuthorizerResponse
import aws.sdk.kotlin.services.iot.model.UpdateBillingGroupRequest
import aws.sdk.kotlin.services.iot.model.UpdateBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.UpdateCaCertificateRequest
import aws.sdk.kotlin.services.iot.model.UpdateCaCertificateResponse
import aws.sdk.kotlin.services.iot.model.UpdateCertificateProviderRequest
import aws.sdk.kotlin.services.iot.model.UpdateCertificateProviderResponse
import aws.sdk.kotlin.services.iot.model.UpdateCertificateRequest
import aws.sdk.kotlin.services.iot.model.UpdateCertificateResponse
import aws.sdk.kotlin.services.iot.model.UpdateCustomMetricRequest
import aws.sdk.kotlin.services.iot.model.UpdateCustomMetricResponse
import aws.sdk.kotlin.services.iot.model.UpdateDimensionRequest
import aws.sdk.kotlin.services.iot.model.UpdateDimensionResponse
import aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationRequest
import aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationResponse
import aws.sdk.kotlin.services.iot.model.UpdateDynamicThingGroupRequest
import aws.sdk.kotlin.services.iot.model.UpdateDynamicThingGroupResponse
import aws.sdk.kotlin.services.iot.model.UpdateEventConfigurationsRequest
import aws.sdk.kotlin.services.iot.model.UpdateEventConfigurationsResponse
import aws.sdk.kotlin.services.iot.model.UpdateFleetMetricRequest
import aws.sdk.kotlin.services.iot.model.UpdateFleetMetricResponse
import aws.sdk.kotlin.services.iot.model.UpdateIndexingConfigurationRequest
import aws.sdk.kotlin.services.iot.model.UpdateIndexingConfigurationResponse
import aws.sdk.kotlin.services.iot.model.UpdateJobRequest
import aws.sdk.kotlin.services.iot.model.UpdateJobResponse
import aws.sdk.kotlin.services.iot.model.UpdateMitigationActionRequest
import aws.sdk.kotlin.services.iot.model.UpdateMitigationActionResponse
import aws.sdk.kotlin.services.iot.model.UpdatePackageConfigurationRequest
import aws.sdk.kotlin.services.iot.model.UpdatePackageConfigurationResponse
import aws.sdk.kotlin.services.iot.model.UpdatePackageRequest
import aws.sdk.kotlin.services.iot.model.UpdatePackageResponse
import aws.sdk.kotlin.services.iot.model.UpdatePackageVersionRequest
import aws.sdk.kotlin.services.iot.model.UpdatePackageVersionResponse
import aws.sdk.kotlin.services.iot.model.UpdateProvisioningTemplateRequest
import aws.sdk.kotlin.services.iot.model.UpdateProvisioningTemplateResponse
import aws.sdk.kotlin.services.iot.model.UpdateRoleAliasRequest
import aws.sdk.kotlin.services.iot.model.UpdateRoleAliasResponse
import aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditRequest
import aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditResponse
import aws.sdk.kotlin.services.iot.model.UpdateSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.UpdateSecurityProfileResponse
import aws.sdk.kotlin.services.iot.model.UpdateStreamRequest
import aws.sdk.kotlin.services.iot.model.UpdateStreamResponse
import aws.sdk.kotlin.services.iot.model.UpdateThingGroupRequest
import aws.sdk.kotlin.services.iot.model.UpdateThingGroupResponse
import aws.sdk.kotlin.services.iot.model.UpdateThingGroupsForThingRequest
import aws.sdk.kotlin.services.iot.model.UpdateThingGroupsForThingResponse
import aws.sdk.kotlin.services.iot.model.UpdateThingRequest
import aws.sdk.kotlin.services.iot.model.UpdateThingResponse
import aws.sdk.kotlin.services.iot.model.UpdateTopicRuleDestinationRequest
import aws.sdk.kotlin.services.iot.model.UpdateTopicRuleDestinationResponse
import aws.sdk.kotlin.services.iot.model.ValidateSecurityProfileBehaviorsRequest
import aws.sdk.kotlin.services.iot.model.ValidateSecurityProfileBehaviorsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IoT"
public const val SdkVersion: String = "1.0.77"
public const val ServiceApiVersion: String = "2015-05-28"

/**
 * # IoT
 * IoT provides secure, bi-directional communication between Internet-connected devices (such as sensors, actuators, embedded devices, or smart appliances) and the Amazon Web Services cloud. You can discover your custom IoT-Data endpoint to communicate with, configure rules for data processing and integration with other services, organize resources associated with each device (Registry), configure logging, and create and manage policies and credentials to authenticate devices.
 *
 * The service endpoints that expose this API are listed in [Amazon Web Services IoT Core Endpoints and Quotas](https://docs.aws.amazon.com/general/latest/gr/iot-core.html). You must use the endpoint for the region that has the resources you want to access.
 *
 * The service name used by [Amazon Web Services Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) to sign the request is: *execute-api*.
 *
 * For more information about how IoT works, see the [Developer Guide](https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html).
 *
 * For information about how to use the credentials provider for IoT, see [Authorizing Direct Calls to Amazon Web Services Services](https://docs.aws.amazon.com/iot/latest/developerguide/authorizing-direct-aws.html).
 */
public interface IotClient : SdkClient {
    /**
     * IotClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Iot",
                "IOT",
                "iot",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotClient = DefaultIotClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotEndpointProvider = builder.endpointProvider ?: DefaultIotEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     *
     * To check for pending certificate transfers, call ListCertificates to enumerate your certificates.
     *
     * Requires permission to access the [AcceptCertificateTransfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun acceptCertificateTransfer(input: AcceptCertificateTransferRequest): AcceptCertificateTransferResponse

    /**
     * Adds a thing to a billing group.
     *
     * Requires permission to access the [AddThingToBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun addThingToBillingGroup(input: AddThingToBillingGroupRequest = AddThingToBillingGroupRequest { }): AddThingToBillingGroupResponse

    /**
     * Adds a thing to a thing group.
     *
     * Requires permission to access the [AddThingToThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun addThingToThingGroup(input: AddThingToThingGroupRequest = AddThingToThingGroupRequest { }): AddThingToThingGroupResponse

    /**
     * Associates a group with a continuous job. The following criteria must be met:
     * + The job must have been created with the `targetSelection` field set to "CONTINUOUS".
     * + The job status must currently be "IN_PROGRESS".
     * + The total number of targets associated with a job must not exceed 100.
     *
     * Requires permission to access the [AssociateTargetsWithJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun associateTargetsWithJob(input: AssociateTargetsWithJobRequest): AssociateTargetsWithJobResponse

    /**
     * Attaches the specified policy to the specified principal (certificate or other credential).
     *
     * Requires permission to access the [AttachPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun attachPolicy(input: AttachPolicyRequest): AttachPolicyResponse

    /**
     * Attaches the specified policy to the specified principal (certificate or other credential).
     *
     * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use AttachPolicy instead.
     *
     * Requires permission to access the [AttachPrincipalPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun attachPrincipalPolicy(input: AttachPrincipalPolicyRequest): AttachPrincipalPolicyResponse

    /**
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can have up to five security profiles associated with it.
     *
     * Requires permission to access the [AttachSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun attachSecurityProfile(input: AttachSecurityProfileRequest): AttachSecurityProfileResponse

    /**
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, Amazon Cognito identities or federated identities.
     *
     * Requires permission to access the [AttachThingPrincipal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun attachThingPrincipal(input: AttachThingPrincipalRequest): AttachThingPrincipalResponse

    /**
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException occurs.
     *
     * Requires permission to access the [CancelAuditMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun cancelAuditMitigationActionsTask(input: CancelAuditMitigationActionsTaskRequest): CancelAuditMitigationActionsTaskResponse

    /**
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.
     *
     * Requires permission to access the [CancelAuditTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun cancelAuditTask(input: CancelAuditTaskRequest): CancelAuditTaskResponse

    /**
     * Cancels a pending transfer for the specified certificate.
     *
     * **Note** Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use RejectCertificateTransfer instead.) After transfer, IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled.
     *
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.
     *
     * Requires permission to access the [CancelCertificateTransfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun cancelCertificateTransfer(input: CancelCertificateTransferRequest): CancelCertificateTransferResponse

    /**
     * Cancels a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the [CancelDetectMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun cancelDetectMitigationActionsTask(input: CancelDetectMitigationActionsTaskRequest): CancelDetectMitigationActionsTaskResponse

    /**
     * Cancels a job.
     *
     * Requires permission to access the [CancelJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Cancels the execution of a job for a given thing.
     *
     * Requires permission to access the [CancelJobExecution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun cancelJobExecution(input: CancelJobExecutionRequest): CancelJobExecutionResponse

    /**
     * Clears the default authorizer.
     *
     * Requires permission to access the [ClearDefaultAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun clearDefaultAuthorizer(input: ClearDefaultAuthorizerRequest = ClearDefaultAuthorizerRequest { }): ClearDefaultAuthorizerResponse

    /**
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation message to the endpoint or base address you specify. The message includes a token which you pass back when calling `ConfirmTopicRuleDestination` to confirm that you own or have access to the endpoint.
     *
     * Requires permission to access the [ConfirmTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun confirmTopicRuleDestination(input: ConfirmTopicRuleDestinationRequest): ConfirmTopicRuleDestinationResponse

    /**
     * Creates a Device Defender audit suppression.
     *
     * Requires permission to access the [CreateAuditSuppression](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createAuditSuppression(input: CreateAuditSuppressionRequest): CreateAuditSuppressionResponse

    /**
     * Creates an authorizer.
     *
     * Requires permission to access the [CreateAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse

    /**
     * Creates a billing group.
     *
     * Requires permission to access the [CreateBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createBillingGroup(input: CreateBillingGroupRequest): CreateBillingGroupResponse

    /**
     * Creates an X.509 certificate using the specified certificate signing request.
     *
     * Requires permission to access the [CreateCertificateFromCsr](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult [ Certificate signing algorithms supported by IoT](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms).
     *
     * Reusing the same certificate signing request (CSR) results in a distinct certificate.
     *
     * You can create multiple certificates in a batch by creating a directory, copying multiple `.csr` files into that directory, and then specifying that directory on the command line. The following commands show how to create a batch of certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs are located inside of the directory my-csr-directory:
     *
     * On Linux and OS X, the command is:
     *
     * `$ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}`
     *
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the `aws iot create-certificate-from-csr` Amazon Web Services CLI command to create a certificate for the corresponding CSR.
     *
     * You can also run the `aws iot create-certificate-from-csr` part of the command in parallel to speed up the certificate creation process:
     *
     * `$ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{} `
     *
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     *
     * `> ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/$_} `
     *
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     *
     * `> forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path" `
     */
    public suspend fun createCertificateFromCsr(input: CreateCertificateFromCsrRequest): CreateCertificateFromCsrResponse

    /**
     * Creates an Amazon Web Services IoT Core certificate provider. You can use Amazon Web Services IoT Core certificate provider to customize how to sign a certificate signing request (CSR) in IoT fleet provisioning. For more information, see [Customizing certificate signing using Amazon Web Services IoT Core certificate provider](https://docs.aws.amazon.com/iot/latest/developerguide/provisioning-cert-provider.html) from *Amazon Web Services IoT Core Developer Guide*.
     *
     * Requires permission to access the [CreateCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * After you create a certificate provider, the behavior of `CreateCertificateFromCsr`[ API for fleet provisioning](https://docs.aws.amazon.com/iot/latest/developerguide/fleet-provision-api.html#create-cert-csr) will change and all API calls to `CreateCertificateFromCsr` will invoke the certificate provider to create the certificates. It can take up to a few minutes for this behavior to change after a certificate provider is created.
     */
    public suspend fun createCertificateProvider(input: CreateCertificateProviderRequest): CreateCertificateProviderResponse

    /**
     * Use this API to define a Custom Metric published by your devices to Device Defender.
     *
     * Requires permission to access the [CreateCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createCustomMetric(input: CreateCustomMetricRequest): CreateCustomMetricResponse

    /**
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender. For example, using a `TOPIC_FILTER` dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.
     *
     * Requires permission to access the [CreateDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createDimension(input: CreateDimensionRequest): CreateDimensionResponse

    /**
     * Creates a domain configuration.
     *
     * Requires permission to access the [CreateDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createDomainConfiguration(input: CreateDomainConfigurationRequest): CreateDomainConfigurationResponse

    /**
     * Creates a dynamic thing group.
     *
     * Requires permission to access the [CreateDynamicThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createDynamicThingGroup(input: CreateDynamicThingGroupRequest): CreateDynamicThingGroupResponse

    /**
     * Creates a fleet metric.
     *
     * Requires permission to access the [CreateFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createFleetMetric(input: CreateFleetMetricRequest): CreateFleetMetricResponse

    /**
     * Creates a job.
     *
     * Requires permission to access the [CreateJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * Creates a job template.
     *
     * Requires permission to access the [CreateJobTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse

    /**
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call `CreateKeysAndCertificate` over MQTT from a device, for more information, see [Provisioning MQTT API](https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api).
     *
     * **Note** This is the only time IoT issues the private key for this certificate, so it is important to keep it in a secure location.
     *
     * Requires permission to access the [CreateKeysAndCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createKeysAndCertificate(input: CreateKeysAndCertificateRequest = CreateKeysAndCertificateRequest { }): CreateKeysAndCertificateResponse

    /**
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names. For more information, see [Mitigation actions](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html). Each mitigation action can apply only one type of change.
     *
     * Requires permission to access the [CreateMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createMitigationAction(input: CreateMitigationActionRequest): CreateMitigationActionResponse

    /**
     * Creates an IoT OTA update on a target group of things or groups.
     *
     * Requires permission to access the [CreateOTAUpdate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createOtaUpdate(input: CreateOtaUpdateRequest): CreateOtaUpdateResponse

    /**
     * Creates an IoT software package that can be deployed to your fleet.
     *
     * Requires permission to access the [CreatePackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
     */
    public suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse

    /**
     * Creates a new version for an existing IoT software package.
     *
     * Requires permission to access the [CreatePackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
     */
    public suspend fun createPackageVersion(input: CreatePackageVersionRequest): CreatePackageVersionResponse

    /**
     * Creates an IoT policy.
     *
     * The created policy is the default version for the policy. This operation creates a policy version with a version identifier of **1** and sets **1** as the policy's default version.
     *
     * Requires permission to access the [CreatePolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse

    /**
     * Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use DeletePolicyVersion to delete an existing version before you create a new one.
     *
     * Optionally, you can set the new version as the policy's default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).
     *
     * Requires permission to access the [CreatePolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createPolicyVersion(input: CreatePolicyVersionRequest): CreatePolicyVersionResponse

    /**
     * Creates a provisioning claim.
     *
     * Requires permission to access the [CreateProvisioningClaim](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createProvisioningClaim(input: CreateProvisioningClaimRequest): CreateProvisioningClaimResponse

    /**
     * Creates a provisioning template.
     *
     * Requires permission to access the [CreateProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createProvisioningTemplate(input: CreateProvisioningTemplateRequest): CreateProvisioningTemplateResponse

    /**
     * Creates a new version of a provisioning template.
     *
     * Requires permission to access the [CreateProvisioningTemplateVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createProvisioningTemplateVersion(input: CreateProvisioningTemplateVersionRequest): CreateProvisioningTemplateVersionResponse

    /**
     * Creates a role alias.
     *
     * Requires permission to access the [CreateRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createRoleAlias(input: CreateRoleAliasRequest): CreateRoleAliasResponse

    /**
     * Creates a scheduled audit that is run at a specified time interval.
     *
     * Requires permission to access the [CreateScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createScheduledAudit(input: CreateScheduledAuditRequest): CreateScheduledAuditResponse

    /**
     * Creates a Device Defender security profile.
     *
     * Requires permission to access the [CreateSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse

    /**
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with a stream.
     *
     * Requires permission to access the [CreateStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createStream(input: CreateStreamRequest): CreateStreamResponse

    /**
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and configuration, the call will succeed. If this call is made with the same thing name but different configuration a `ResourceAlreadyExistsException` is thrown.
     *
     * This is a control plane operation. See [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html) for information about authorizing control plane actions.
     *
     * Requires permission to access the [CreateThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createThing(input: CreateThingRequest): CreateThingResponse

    /**
     * Create a thing group.
     *
     * This is a control plane operation. See [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html) for information about authorizing control plane actions.
     *
     * If the `ThingGroup` that you create has the exact same attributes as an existing `ThingGroup`, you will get a 200 success response.
     *
     * Requires permission to access the [CreateThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createThingGroup(input: CreateThingGroupRequest): CreateThingGroupResponse

    /**
     * Creates a new thing type.
     *
     * Requires permission to access the [CreateThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createThingType(input: CreateThingTypeRequest): CreateThingTypeResponse

    /**
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.
     *
     * Requires permission to access the [CreateTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createTopicRule(input: CreateTopicRuleRequest): CreateTopicRuleResponse

    /**
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     *
     * Requires permission to access the [CreateTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createTopicRuleDestination(input: CreateTopicRuleDestinationRequest): CreateTopicRuleDestinationResponse

    /**
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is deleted and all audit checks are reset to disabled.
     *
     * Requires permission to access the [DeleteAccountAuditConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteAccountAuditConfiguration(input: DeleteAccountAuditConfigurationRequest = DeleteAccountAuditConfigurationRequest { }): DeleteAccountAuditConfigurationResponse

    /**
     * Deletes a Device Defender audit suppression.
     *
     * Requires permission to access the [DeleteAuditSuppression](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteAuditSuppression(input: DeleteAuditSuppressionRequest): DeleteAuditSuppressionResponse

    /**
     * Deletes an authorizer.
     *
     * Requires permission to access the [DeleteAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse

    /**
     * Deletes the billing group.
     *
     * Requires permission to access the [DeleteBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteBillingGroup(input: DeleteBillingGroupRequest): DeleteBillingGroupResponse

    /**
     * Deletes a registered CA certificate.
     *
     * Requires permission to access the [DeleteCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteCaCertificate(input: DeleteCaCertificateRequest): DeleteCaCertificateResponse

    /**
     * Deletes the specified certificate.
     *
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE. To delete a certificate, first use the DetachPolicy action to detach all policies. Next, use the UpdateCertificate action to set the certificate to the INACTIVE status.
     *
     * Requires permission to access the [DeleteCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes a certificate provider.
     *
     * Requires permission to access the [DeleteCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * If you delete the certificate provider resource, the behavior of `CreateCertificateFromCsr` will resume, and IoT will create certificates signed by IoT from a certificate signing request (CSR).
     */
    public suspend fun deleteCertificateProvider(input: DeleteCertificateProviderRequest): DeleteCertificateProviderResponse

    /**
     * Deletes a Device Defender detect custom metric.
     *
     * Requires permission to access the [DeleteCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a part of. The security profile associated with the custom metric can be found using the [ListSecurityProfiles](https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html) API with `metricName` set to your custom metric name.
     */
    public suspend fun deleteCustomMetric(input: DeleteCustomMetricRequest): DeleteCustomMetricResponse

    /**
     * Removes the specified dimension from your Amazon Web Services accounts.
     *
     * Requires permission to access the [DeleteDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteDimension(input: DeleteDimensionRequest): DeleteDimensionResponse

    /**
     * Deletes the specified domain configuration.
     *
     * Requires permission to access the [DeleteDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteDomainConfiguration(input: DeleteDomainConfigurationRequest): DeleteDomainConfigurationResponse

    /**
     * Deletes a dynamic thing group.
     *
     * Requires permission to access the [DeleteDynamicThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteDynamicThingGroup(input: DeleteDynamicThingGroupRequest): DeleteDynamicThingGroupResponse

    /**
     * Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.
     *
     * Requires permission to access the [DeleteFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteFleetMetric(input: DeleteFleetMetricRequest): DeleteFleetMetricResponse

    /**
     * Deletes a job and its related job executions.
     *
     * Deleting a job may take time, depending on the number of job executions created for the job and various other factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     *
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     *
     * Requires permission to access the [DeleteJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteJob(input: DeleteJobRequest): DeleteJobResponse

    /**
     * Deletes a job execution.
     *
     * Requires permission to access the [DeleteJobExecution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteJobExecution(input: DeleteJobExecutionRequest): DeleteJobExecutionResponse

    /**
     * Deletes the specified job template.
     */
    public suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse

    /**
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     *
     * Requires permission to access the [DeleteMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteMitigationAction(input: DeleteMitigationActionRequest): DeleteMitigationActionResponse

    /**
     * Delete an OTA update.
     *
     * Requires permission to access the [DeleteOTAUpdate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteOtaUpdate(input: DeleteOtaUpdateRequest): DeleteOtaUpdateResponse

    /**
     * Deletes a specific version from a software package.
     *
     * **Note:** All package versions must be deleted before deleting the software package.
     *
     * Requires permission to access the [DeletePackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse

    /**
     * Deletes a specific version from a software package.
     *
     * **Note:** If a package version is designated as default, you must remove the designation from the software package using the UpdatePackage action.
     */
    public suspend fun deletePackageVersion(input: DeletePackageVersionRequest): DeletePackageVersionResponse

    /**
     * Deletes the specified policy.
     *
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     *
     * To delete a policy, use the DeletePolicyVersion action to delete all non-default versions of the policy; use the DetachPolicy action to detach the policy from any certificate; and then use the DeletePolicy action to delete the policy.
     *
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the [DeletePolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this action. To delete the default version of a policy, use DeletePolicy. To find out which version of a policy is marked as the default version, use ListPolicyVersions.
     *
     * Requires permission to access the [DeletePolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deletePolicyVersion(input: DeletePolicyVersionRequest): DeletePolicyVersionResponse

    /**
     * Deletes a provisioning template.
     *
     * Requires permission to access the [DeleteProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteProvisioningTemplate(input: DeleteProvisioningTemplateRequest): DeleteProvisioningTemplateResponse

    /**
     * Deletes a provisioning template version.
     *
     * Requires permission to access the [DeleteProvisioningTemplateVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteProvisioningTemplateVersion(input: DeleteProvisioningTemplateVersionRequest): DeleteProvisioningTemplateVersionResponse

    /**
     * Deletes a CA certificate registration code.
     *
     * Requires permission to access the [DeleteRegistrationCode](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteRegistrationCode(input: DeleteRegistrationCodeRequest = DeleteRegistrationCodeRequest { }): DeleteRegistrationCodeResponse

    /**
     * Deletes a role alias
     *
     * Requires permission to access the [DeleteRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteRoleAlias(input: DeleteRoleAliasRequest): DeleteRoleAliasResponse

    /**
     * Deletes a scheduled audit.
     *
     * Requires permission to access the [DeleteScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteScheduledAudit(input: DeleteScheduledAuditRequest): DeleteScheduledAuditResponse

    /**
     * Deletes a Device Defender security profile.
     *
     * Requires permission to access the [DeleteSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse

    /**
     * Deletes a stream.
     *
     * Requires permission to access the [DeleteStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteStream(input: DeleteStreamRequest): DeleteStreamResponse

    /**
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a thing that doesn't exist.
     *
     * Requires permission to access the [DeleteThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteThing(input: DeleteThingRequest): DeleteThingResponse

    /**
     * Deletes a thing group.
     *
     * Requires permission to access the [DeleteThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteThingGroup(input: DeleteThingGroupRequest): DeleteThingGroupResponse

    /**
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling DeprecateThingType, then remove any associated things by calling UpdateThing to change the thing type on any associated thing, and finally use DeleteThingType to delete the thing type.
     *
     * Requires permission to access the [DeleteThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteThingType(input: DeleteThingTypeRequest): DeleteThingTypeResponse

    /**
     * Deletes the rule.
     *
     * Requires permission to access the [DeleteTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteTopicRule(input: DeleteTopicRuleRequest): DeleteTopicRuleResponse

    /**
     * Deletes a topic rule destination.
     *
     * Requires permission to access the [DeleteTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteTopicRuleDestination(input: DeleteTopicRuleDestinationRequest): DeleteTopicRuleDestinationResponse

    /**
     * Deletes a logging level.
     *
     * Requires permission to access the [DeleteV2LoggingLevel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteV2LoggingLevel(input: DeleteV2LoggingLevelRequest): DeleteV2LoggingLevelResponse

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     *
     * Requires permission to access the [DeprecateThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deprecateThingType(input: DeprecateThingTypeRequest): DeprecateThingTypeResponse

    /**
     * Gets information about the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.
     *
     * Requires permission to access the [DescribeAccountAuditConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeAccountAuditConfiguration(input: DescribeAccountAuditConfigurationRequest = DescribeAccountAuditConfigurationRequest { }): DescribeAccountAuditConfigurationResponse

    /**
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and the start time when the audit that returned the finding.
     *
     * Requires permission to access the [DescribeAuditFinding](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeAuditFinding(input: DescribeAuditFindingRequest): DescribeAuditFindingResponse

    /**
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.
     */
    public suspend fun describeAuditMitigationActionsTask(input: DescribeAuditMitigationActionsTaskRequest): DescribeAuditMitigationActionsTaskResponse

    /**
     * Gets information about a Device Defender audit suppression.
     */
    public suspend fun describeAuditSuppression(input: DescribeAuditSuppressionRequest): DescribeAuditSuppressionResponse

    /**
     * Gets information about a Device Defender audit.
     *
     * Requires permission to access the [DescribeAuditTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeAuditTask(input: DescribeAuditTaskRequest): DescribeAuditTaskResponse

    /**
     * Describes an authorizer.
     *
     * Requires permission to access the [DescribeAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeAuthorizer(input: DescribeAuthorizerRequest): DescribeAuthorizerResponse

    /**
     * Returns information about a billing group.
     *
     * Requires permission to access the [DescribeBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeBillingGroup(input: DescribeBillingGroupRequest): DescribeBillingGroupResponse

    /**
     * Describes a registered CA certificate.
     *
     * Requires permission to access the [DescribeCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeCaCertificate(input: DescribeCaCertificateRequest): DescribeCaCertificateResponse

    /**
     * Gets information about the specified certificate.
     *
     * Requires permission to access the [DescribeCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse

    /**
     * Describes a certificate provider.
     *
     * Requires permission to access the [DescribeCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeCertificateProvider(input: DescribeCertificateProviderRequest): DescribeCertificateProviderResponse

    /**
     * Gets information about a Device Defender detect custom metric.
     *
     * Requires permission to access the [DescribeCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeCustomMetric(input: DescribeCustomMetricRequest): DescribeCustomMetricResponse

    /**
     * Describes the default authorizer.
     *
     * Requires permission to access the [DescribeDefaultAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeDefaultAuthorizer(input: DescribeDefaultAuthorizerRequest = DescribeDefaultAuthorizerRequest { }): DescribeDefaultAuthorizerResponse

    /**
     * Gets information about a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the [DescribeDetectMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeDetectMitigationActionsTask(input: DescribeDetectMitigationActionsTaskRequest): DescribeDetectMitigationActionsTaskResponse

    /**
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     *
     * Requires permission to access the [DescribeDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeDimension(input: DescribeDimensionRequest): DescribeDimensionResponse

    /**
     * Gets summary information about a domain configuration.
     *
     * Requires permission to access the [DescribeDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeDomainConfiguration(input: DescribeDomainConfigurationRequest): DescribeDomainConfigurationResponse

    /**
     * Returns or creates a unique endpoint specific to the Amazon Web Services account making the call.
     *
     * The first time `DescribeEndpoint` is called, an endpoint is created. All subsequent calls to `DescribeEndpoint` return the same endpoint.
     *
     * Requires permission to access the [DescribeEndpoint](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeEndpoint(input: DescribeEndpointRequest = DescribeEndpointRequest { }): DescribeEndpointResponse

    /**
     * Describes event configurations.
     *
     * Requires permission to access the [DescribeEventConfigurations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeEventConfigurations(input: DescribeEventConfigurationsRequest = DescribeEventConfigurationsRequest { }): DescribeEventConfigurationsResponse

    /**
     * Gets information about the specified fleet metric.
     *
     * Requires permission to access the [DescribeFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeFleetMetric(input: DescribeFleetMetricRequest): DescribeFleetMetricResponse

    /**
     * Describes a search index.
     *
     * Requires permission to access the [DescribeIndex](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeIndex(input: DescribeIndexRequest): DescribeIndexResponse

    /**
     * Describes a job.
     *
     * Requires permission to access the [DescribeJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeJob(input: DescribeJobRequest): DescribeJobResponse

    /**
     * Describes a job execution.
     *
     * Requires permission to access the [DescribeJobExecution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeJobExecution(input: DescribeJobExecutionRequest): DescribeJobExecutionResponse

    /**
     * Returns information about a job template.
     */
    public suspend fun describeJobTemplate(input: DescribeJobTemplateRequest): DescribeJobTemplateResponse

    /**
     * View details of a managed job template.
     */
    public suspend fun describeManagedJobTemplate(input: DescribeManagedJobTemplateRequest): DescribeManagedJobTemplateResponse

    /**
     * Gets information about a mitigation action.
     *
     * Requires permission to access the [DescribeMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeMitigationAction(input: DescribeMitigationActionRequest): DescribeMitigationActionResponse

    /**
     * Returns information about a provisioning template.
     *
     * Requires permission to access the [DescribeProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeProvisioningTemplate(input: DescribeProvisioningTemplateRequest): DescribeProvisioningTemplateResponse

    /**
     * Returns information about a provisioning template version.
     *
     * Requires permission to access the [DescribeProvisioningTemplateVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeProvisioningTemplateVersion(input: DescribeProvisioningTemplateVersionRequest): DescribeProvisioningTemplateVersionResponse

    /**
     * Describes a role alias.
     *
     * Requires permission to access the [DescribeRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeRoleAlias(input: DescribeRoleAliasRequest): DescribeRoleAliasResponse

    /**
     * Gets information about a scheduled audit.
     *
     * Requires permission to access the [DescribeScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeScheduledAudit(input: DescribeScheduledAuditRequest): DescribeScheduledAuditResponse

    /**
     * Gets information about a Device Defender security profile.
     *
     * Requires permission to access the [DescribeSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse

    /**
     * Gets information about a stream.
     *
     * Requires permission to access the [DescribeStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeStream(input: DescribeStreamRequest): DescribeStreamResponse

    /**
     * Gets information about the specified thing.
     *
     * Requires permission to access the [DescribeThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeThing(input: DescribeThingRequest): DescribeThingResponse

    /**
     * Describe a thing group.
     *
     * Requires permission to access the [DescribeThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeThingGroup(input: DescribeThingGroupRequest): DescribeThingGroupResponse

    /**
     * Describes a bulk thing provisioning task.
     *
     * Requires permission to access the [DescribeThingRegistrationTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeThingRegistrationTask(input: DescribeThingRegistrationTaskRequest): DescribeThingRegistrationTaskResponse

    /**
     * Gets information about the specified thing type.
     *
     * Requires permission to access the [DescribeThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeThingType(input: DescribeThingTypeRequest): DescribeThingTypeResponse

    /**
     * Detaches a policy from the specified target.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the [DetachPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun detachPolicy(input: DetachPolicyRequest): DetachPolicyResponse

    /**
     * Removes the specified policy from the specified certificate.
     *
     * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use DetachPolicy instead.
     *
     * Requires permission to access the [DetachPrincipalPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun detachPrincipalPolicy(input: DetachPrincipalPolicyRequest): DetachPrincipalPolicyResponse

    /**
     * Disassociates a Device Defender security profile from a thing group or from this account.
     *
     * Requires permission to access the [DetachSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun detachSecurityProfile(input: DetachSecurityProfileRequest): DetachSecurityProfileResponse

    /**
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.
     *
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     *
     * Requires permission to access the [DetachThingPrincipal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun detachThingPrincipal(input: DetachThingPrincipalRequest): DetachThingPrincipalResponse

    /**
     * Disables the rule.
     *
     * Requires permission to access the [DisableTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun disableTopicRule(input: DisableTopicRuleRequest): DisableTopicRuleResponse

    /**
     * Enables the rule.
     *
     * Requires permission to access the [EnableTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun enableTopicRule(input: EnableTopicRuleRequest): EnableTopicRuleResponse

    /**
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     *
     * Requires permission to access the [GetBehaviorModelTrainingSummaries](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getBehaviorModelTrainingSummaries(input: GetBehaviorModelTrainingSummariesRequest = GetBehaviorModelTrainingSummariesRequest { }): GetBehaviorModelTrainingSummariesResponse

    /**
     * Aggregates on indexed data with search queries pertaining to particular fields.
     *
     * Requires permission to access the [GetBucketsAggregation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getBucketsAggregation(input: GetBucketsAggregationRequest): GetBucketsAggregationResponse

    /**
     * Returns the approximate count of unique values that match the query.
     *
     * Requires permission to access the [GetCardinality](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getCardinality(input: GetCardinalityRequest): GetCardinalityResponse

    /**
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it connects to the IoT device gateway.
     *
     * Requires permission to access the [GetEffectivePolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getEffectivePolicies(input: GetEffectivePoliciesRequest = GetEffectivePoliciesRequest { }): GetEffectivePoliciesResponse

    /**
     * Gets the indexing configuration.
     *
     * Requires permission to access the [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getIndexingConfiguration(input: GetIndexingConfigurationRequest = GetIndexingConfigurationRequest { }): GetIndexingConfigurationResponse

    /**
     * Gets a job document.
     *
     * Requires permission to access the [GetJobDocument](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getJobDocument(input: GetJobDocumentRequest): GetJobDocumentResponse

    /**
     * Gets the logging options.
     *
     * NOTE: use of this command is not recommended. Use `GetV2LoggingOptions` instead.
     *
     * Requires permission to access the [GetLoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getLoggingOptions(input: GetLoggingOptionsRequest = GetLoggingOptionsRequest { }): GetLoggingOptionsResponse

    /**
     * Gets an OTA update.
     *
     * Requires permission to access the [GetOTAUpdate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getOtaUpdate(input: GetOtaUpdateRequest): GetOtaUpdateResponse

    /**
     * Gets information about the specified software package.
     *
     * Requires permission to access the [GetPackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getPackage(input: GetPackageRequest): GetPackageResponse

    /**
     * Gets information about the specified software package's configuration.
     *
     * Requires permission to access the [GetPackageConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getPackageConfiguration(input: GetPackageConfigurationRequest = GetPackageConfigurationRequest { }): GetPackageConfigurationResponse

    /**
     * Gets information about the specified package version.
     *
     * Requires permission to access the [GetPackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getPackageVersion(input: GetPackageVersionRequest): GetPackageVersionResponse

    /**
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own when you call `GetPercentiles`. This function returns a value for each percentile group specified (or the default percentile groupings). The percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately five percent of the values that match the query, and so on. The result is an approximation, the more values that match the query, the more accurate the percentile values.
     *
     * Requires permission to access the [GetPercentiles](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getPercentiles(input: GetPercentilesRequest): GetPercentilesResponse

    /**
     * Gets information about the specified policy with the policy document of the default version.
     *
     * Requires permission to access the [GetPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Gets information about the specified policy version.
     *
     * Requires permission to access the [GetPolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getPolicyVersion(input: GetPolicyVersionRequest): GetPolicyVersionResponse

    /**
     * Gets a registration code used to register a CA certificate with IoT.
     *
     * IoT will create a registration code as part of this API call if the registration code doesn't exist or has been deleted. If you already have a registration code, this API call will return the same registration code.
     *
     * Requires permission to access the [GetRegistrationCode](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getRegistrationCode(input: GetRegistrationCodeRequest = GetRegistrationCodeRequest { }): GetRegistrationCodeResponse

    /**
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the specified aggregated field. If the aggregation field is of type `String`, only the count statistic is returned.
     *
     * Requires permission to access the [GetStatistics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getStatistics(input: GetStatisticsRequest): GetStatisticsResponse

    /**
     * Gets information about the rule.
     *
     * Requires permission to access the [GetTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getTopicRule(input: GetTopicRuleRequest): GetTopicRuleResponse

    /**
     * Gets information about a topic rule destination.
     *
     * Requires permission to access the [GetTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getTopicRuleDestination(input: GetTopicRuleDestinationRequest): GetTopicRuleDestinationResponse

    /**
     * Gets the fine grained logging options.
     *
     * Requires permission to access the [GetV2LoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getV2LoggingOptions(input: GetV2LoggingOptionsRequest = GetV2LoggingOptionsRequest { }): GetV2LoggingOptionsResponse

    /**
     * Lists the active violations for a given Device Defender security profile.
     *
     * Requires permission to access the [ListActiveViolations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listActiveViolations(input: ListActiveViolationsRequest = ListActiveViolationsRequest { }): ListActiveViolationsResponse

    /**
     * Lists the policies attached to the specified thing group.
     *
     * Requires permission to access the [ListAttachedPolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAttachedPolicies(input: ListAttachedPoliciesRequest): ListAttachedPoliciesResponse

    /**
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time period. (Findings are retained for 90 days.)
     *
     * Requires permission to access the [ListAuditFindings](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAuditFindings(input: ListAuditFindingsRequest = ListAuditFindingsRequest { }): ListAuditFindingsResponse

    /**
     * Gets the status of audit mitigation action tasks that were executed.
     *
     * Requires permission to access the [ListAuditMitigationActionsExecutions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAuditMitigationActionsExecutions(input: ListAuditMitigationActionsExecutionsRequest): ListAuditMitigationActionsExecutionsResponse

    /**
     * Gets a list of audit mitigation action tasks that match the specified filters.
     *
     * Requires permission to access the [ListAuditMitigationActionsTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAuditMitigationActionsTasks(input: ListAuditMitigationActionsTasksRequest): ListAuditMitigationActionsTasksResponse

    /**
     * Lists your Device Defender audit listings.
     *
     * Requires permission to access the [ListAuditSuppressions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAuditSuppressions(input: ListAuditSuppressionsRequest = ListAuditSuppressionsRequest { }): ListAuditSuppressionsResponse

    /**
     * Lists the Device Defender audits that have been performed during a given time period.
     *
     * Requires permission to access the [ListAuditTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAuditTasks(input: ListAuditTasksRequest): ListAuditTasksResponse

    /**
     * Lists the authorizers registered in your account.
     *
     * Requires permission to access the [ListAuthorizers](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listAuthorizers(input: ListAuthorizersRequest = ListAuthorizersRequest { }): ListAuthorizersResponse

    /**
     * Lists the billing groups you have created.
     *
     * Requires permission to access the [ListBillingGroups](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listBillingGroups(input: ListBillingGroupsRequest = ListBillingGroupsRequest { }): ListBillingGroupsResponse

    /**
     * Lists the CA certificates registered for your Amazon Web Services account.
     *
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.
     *
     * Requires permission to access the [ListCACertificates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listCaCertificates(input: ListCaCertificatesRequest = ListCaCertificatesRequest { }): ListCaCertificatesResponse

    /**
     * Lists all your certificate providers in your Amazon Web Services account.
     *
     * Requires permission to access the [ListCertificateProviders](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listCertificateProviders(input: ListCertificateProvidersRequest = ListCertificateProvidersRequest { }): ListCertificateProvidersResponse

    /**
     * Lists the certificates registered in your Amazon Web Services account.
     *
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.
     *
     * Requires permission to access the [ListCertificates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listCertificates(input: ListCertificatesRequest = ListCertificatesRequest { }): ListCertificatesResponse

    /**
     * List the device certificates signed by the specified CA certificate.
     *
     * Requires permission to access the [ListCertificatesByCA](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listCertificatesByCa(input: ListCertificatesByCaRequest): ListCertificatesByCaResponse

    /**
     * Lists your Device Defender detect custom metrics.
     *
     * Requires permission to access the [ListCustomMetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listCustomMetrics(input: ListCustomMetricsRequest = ListCustomMetricsRequest { }): ListCustomMetricsResponse

    /**
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     *
     * Requires permission to access the [ListDetectMitigationActionsExecutions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listDetectMitigationActionsExecutions(input: ListDetectMitigationActionsExecutionsRequest = ListDetectMitigationActionsExecutionsRequest { }): ListDetectMitigationActionsExecutionsResponse

    /**
     * List of Device Defender ML Detect mitigation actions tasks.
     *
     * Requires permission to access the [ListDetectMitigationActionsTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listDetectMitigationActionsTasks(input: ListDetectMitigationActionsTasksRequest): ListDetectMitigationActionsTasksResponse

    /**
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     *
     * Requires permission to access the [ListDimensions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listDimensions(input: ListDimensionsRequest = ListDimensionsRequest { }): ListDimensionsResponse

    /**
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration name.
     *
     * Requires permission to access the [ListDomainConfigurations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listDomainConfigurations(input: ListDomainConfigurationsRequest = ListDomainConfigurationsRequest { }): ListDomainConfigurationsResponse

    /**
     * Lists all your fleet metrics.
     *
     * Requires permission to access the [ListFleetMetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listFleetMetrics(input: ListFleetMetricsRequest = ListFleetMetricsRequest { }): ListFleetMetricsResponse

    /**
     * Lists the search indices.
     *
     * Requires permission to access the [ListIndices](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listIndices(input: ListIndicesRequest = ListIndicesRequest { }): ListIndicesResponse

    /**
     * Lists the job executions for a job.
     *
     * Requires permission to access the [ListJobExecutionsForJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listJobExecutionsForJob(input: ListJobExecutionsForJobRequest): ListJobExecutionsForJobResponse

    /**
     * Lists the job executions for the specified thing.
     *
     * Requires permission to access the [ListJobExecutionsForThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listJobExecutionsForThing(input: ListJobExecutionsForThingRequest): ListJobExecutionsForThingResponse

    /**
     * Returns a list of job templates.
     *
     * Requires permission to access the [ListJobTemplates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listJobTemplates(input: ListJobTemplatesRequest = ListJobTemplatesRequest { }): ListJobTemplatesResponse

    /**
     * Lists jobs.
     *
     * Requires permission to access the [ListJobs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listJobs(input: ListJobsRequest = ListJobsRequest { }): ListJobsResponse

    /**
     * Returns a list of managed job templates.
     */
    public suspend fun listManagedJobTemplates(input: ListManagedJobTemplatesRequest = ListManagedJobTemplatesRequest { }): ListManagedJobTemplatesResponse

    /**
     * Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side metric, or custom metric) by the given thing during the specified time period.
     */
    public suspend fun listMetricValues(input: ListMetricValuesRequest): ListMetricValuesResponse

    /**
     * Gets a list of all mitigation actions that match the specified filter criteria.
     *
     * Requires permission to access the [ListMitigationActions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listMitigationActions(input: ListMitigationActionsRequest = ListMitigationActionsRequest { }): ListMitigationActionsResponse

    /**
     * Lists OTA updates.
     *
     * Requires permission to access the [ListOTAUpdates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listOtaUpdates(input: ListOtaUpdatesRequest = ListOtaUpdatesRequest { }): ListOtaUpdatesResponse

    /**
     * Lists certificates that are being transferred but not yet accepted.
     *
     * Requires permission to access the [ListOutgoingCertificates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listOutgoingCertificates(input: ListOutgoingCertificatesRequest = ListOutgoingCertificatesRequest { }): ListOutgoingCertificatesResponse

    /**
     * Lists the software package versions associated to the account.
     *
     * Requires permission to access the [ListPackageVersions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listPackageVersions(input: ListPackageVersionsRequest): ListPackageVersionsResponse

    /**
     * Lists the software packages associated to the account.
     *
     * Requires permission to access the [ListPackages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listPackages(input: ListPackagesRequest = ListPackagesRequest { }): ListPackagesResponse

    /**
     * Lists your policies.
     *
     * Requires permission to access the [ListPolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listPolicies(input: ListPoliciesRequest = ListPoliciesRequest { }): ListPoliciesResponse

    /**
     * Lists the principals associated with the specified policy.
     *
     * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use ListTargetsForPolicy instead.
     *
     * Requires permission to access the [ListPolicyPrincipals](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listPolicyPrincipals(input: ListPolicyPrincipalsRequest): ListPolicyPrincipalsResponse

    /**
     * Lists the versions of the specified policy and identifies the default version.
     *
     * Requires permission to access the [ListPolicyVersions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listPolicyVersions(input: ListPolicyVersionsRequest): ListPolicyVersionsResponse

    /**
     * Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in [AmazonCognito Identity format](https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax).
     *
     * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use ListAttachedPolicies instead.
     *
     * Requires permission to access the [ListPrincipalPolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listPrincipalPolicies(input: ListPrincipalPoliciesRequest): ListPrincipalPoliciesResponse

    /**
     * Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.
     *
     * Requires permission to access the [ListPrincipalThings](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listPrincipalThings(input: ListPrincipalThingsRequest): ListPrincipalThingsResponse

    /**
     * A list of provisioning template versions.
     *
     * Requires permission to access the [ListProvisioningTemplateVersions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listProvisioningTemplateVersions(input: ListProvisioningTemplateVersionsRequest): ListProvisioningTemplateVersionsResponse

    /**
     * Lists the provisioning templates in your Amazon Web Services account.
     *
     * Requires permission to access the [ListProvisioningTemplates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listProvisioningTemplates(input: ListProvisioningTemplatesRequest = ListProvisioningTemplatesRequest { }): ListProvisioningTemplatesResponse

    /**
     * The related resources of an Audit finding. The following resources can be returned from calling this API:
     * + DEVICE_CERTIFICATE
     * + CA_CERTIFICATE
     * + IOT_POLICY
     * + COGNITO_IDENTITY_POOL
     * + CLIENT_ID
     * + ACCOUNT_SETTINGS
     * + ROLE_ALIAS
     * + IAM_ROLE
     * + ISSUER_CERTIFICATE
     *
     * This API is similar to DescribeAuditFinding's [RelatedResources](https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html) but provides pagination and is not limited to 10 resources. When calling [DescribeAuditFinding](https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html) for the intermediate CA revoked for active device certificates check, RelatedResources will not be populated. You must use this API, ListRelatedResourcesForAuditFinding, to list the certificates.
     */
    public suspend fun listRelatedResourcesForAuditFinding(input: ListRelatedResourcesForAuditFindingRequest): ListRelatedResourcesForAuditFindingResponse

    /**
     * Lists the role aliases registered in your account.
     *
     * Requires permission to access the [ListRoleAliases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listRoleAliases(input: ListRoleAliasesRequest = ListRoleAliasesRequest { }): ListRoleAliasesResponse

    /**
     * Lists all of your scheduled audits.
     *
     * Requires permission to access the [ListScheduledAudits](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listScheduledAudits(input: ListScheduledAuditsRequest = ListScheduledAuditsRequest { }): ListScheduledAuditsResponse

    /**
     * Lists the Device Defender security profiles you've created. You can filter security profiles by dimension or custom metric.
     *
     * Requires permission to access the [ListSecurityProfiles](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * `dimensionName` and `metricName` cannot be used in the same request.
     */
    public suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest = ListSecurityProfilesRequest { }): ListSecurityProfilesResponse

    /**
     * Lists the Device Defender security profiles attached to a target (thing group).
     *
     * Requires permission to access the [ListSecurityProfilesForTarget](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listSecurityProfilesForTarget(input: ListSecurityProfilesForTargetRequest): ListSecurityProfilesForTargetResponse

    /**
     * Lists all of the streams in your Amazon Web Services account.
     *
     * Requires permission to access the [ListStreams](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listStreams(input: ListStreamsRequest = ListStreamsRequest { }): ListStreamsResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     *
     * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List targets for the specified policy.
     *
     * Requires permission to access the [ListTargetsForPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTargetsForPolicy(input: ListTargetsForPolicyRequest): ListTargetsForPolicyResponse

    /**
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     *
     * Requires permission to access the [ListTargetsForSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTargetsForSecurityProfile(input: ListTargetsForSecurityProfileRequest): ListTargetsForSecurityProfileResponse

    /**
     * List the thing groups in your account.
     *
     * Requires permission to access the [ListThingGroups](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingGroups(input: ListThingGroupsRequest = ListThingGroupsRequest { }): ListThingGroupsResponse

    /**
     * List the thing groups to which the specified thing belongs.
     *
     * Requires permission to access the [ListThingGroupsForThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingGroupsForThing(input: ListThingGroupsForThingRequest): ListThingGroupsForThingResponse

    /**
     * Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.
     *
     * Requires permission to access the [ListThingPrincipals](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingPrincipals(input: ListThingPrincipalsRequest): ListThingPrincipalsResponse

    /**
     * Information about the thing registration tasks.
     */
    public suspend fun listThingRegistrationTaskReports(input: ListThingRegistrationTaskReportsRequest): ListThingRegistrationTaskReportsResponse

    /**
     * List bulk thing provisioning tasks.
     *
     * Requires permission to access the [ListThingRegistrationTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingRegistrationTasks(input: ListThingRegistrationTasksRequest = ListThingRegistrationTasksRequest { }): ListThingRegistrationTasksResponse

    /**
     * Lists the existing thing types.
     *
     * Requires permission to access the [ListThingTypes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingTypes(input: ListThingTypesRequest = ListThingTypesRequest { }): ListThingTypesResponse

    /**
     * Lists your things. Use the **attributeName** and **attributeValue** parameters to filter your things. For example, calling `ListThings` with attributeName=Color and attributeValue=Red retrieves all things in the registry that contain an attribute **Color** with the value **Red**. For more information, see [List Things](https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html#list-things) from the *Amazon Web Services IoT Core Developer Guide*.
     *
     * Requires permission to access the [ListThings](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * You will not be charged for calling this API if an `Access denied` error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.
     */
    public suspend fun listThings(input: ListThingsRequest = ListThingsRequest { }): ListThingsResponse

    /**
     * Lists the things you have added to the given billing group.
     *
     * Requires permission to access the [ListThingsInBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingsInBillingGroup(input: ListThingsInBillingGroupRequest): ListThingsInBillingGroupResponse

    /**
     * Lists the things in the specified group.
     *
     * Requires permission to access the [ListThingsInThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listThingsInThingGroup(input: ListThingsInThingGroupRequest): ListThingsInThingGroupResponse

    /**
     * Lists all the topic rule destinations in your Amazon Web Services account.
     *
     * Requires permission to access the [ListTopicRuleDestinations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTopicRuleDestinations(input: ListTopicRuleDestinationsRequest = ListTopicRuleDestinationsRequest { }): ListTopicRuleDestinationsResponse

    /**
     * Lists the rules for the specific topic.
     *
     * Requires permission to access the [ListTopicRules](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTopicRules(input: ListTopicRulesRequest = ListTopicRulesRequest { }): ListTopicRulesResponse

    /**
     * Lists logging levels.
     *
     * Requires permission to access the [ListV2LoggingLevels](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listV2LoggingLevels(input: ListV2LoggingLevelsRequest = ListV2LoggingLevelsRequest { }): ListV2LoggingLevelsResponse

    /**
     * Lists the Device Defender security profile violations discovered during the given time period. You can use filters to limit the results to those alerts issued for a particular security profile, behavior, or thing (device).
     *
     * Requires permission to access the [ListViolationEvents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listViolationEvents(input: ListViolationEventsRequest): ListViolationEventsResponse

    /**
     * Set a verification state and provide a description of that verification state on a violation (detect alarm).
     */
    public suspend fun putVerificationStateOnViolation(input: PutVerificationStateOnViolationRequest): PutVerificationStateOnViolationResponse

    /**
     * Registers a CA certificate with Amazon Web Services IoT Core. There is no limit to the number of CA certificates you can register in your Amazon Web Services account. You can register up to 10 CA certificates with the same `CA subject field` per Amazon Web Services account.
     *
     * Requires permission to access the [RegisterCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun registerCaCertificate(input: RegisterCaCertificateRequest): RegisterCaCertificateResponse

    /**
     * Registers a device certificate with IoT in the same [certificate mode](https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode) as the signing CA. If you have more than one CA certificate that has the same subject field, you must specify the CA certificate that was used to sign the device certificate being registered.
     *
     * Requires permission to access the [RegisterCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun registerCertificate(input: RegisterCertificateRequest): RegisterCertificateResponse

    /**
     * Register a certificate that does not have a certificate authority (CA). For supported certificates, consult [ Certificate signing algorithms supported by IoT](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms).
     */
    public suspend fun registerCertificateWithoutCa(input: RegisterCertificateWithoutCaRequest): RegisterCertificateWithoutCaResponse

    /**
     * Provisions a thing in the device registry. RegisterThing calls other IoT control plane APIs. These calls might exceed your account level [ IoT Throttling Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot) and cause throttle errors. Please contact [Amazon Web Services Customer Support](https://console.aws.amazon.com/support/home) to raise your throttling limits if necessary.
     *
     * Requires permission to access the [RegisterThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun registerThing(input: RegisterThingRequest): RegisterThingResponse

    /**
     * Rejects a pending certificate transfer. After IoT rejects a certificate transfer, the certificate status changes from **PENDING_TRANSFER** to **INACTIVE**.
     *
     * To check for pending certificate transfers, call ListCertificates to enumerate your certificates.
     *
     * This operation can only be called by the transfer destination. After it is called, the certificate will be returned to the source's account in the INACTIVE state.
     *
     * Requires permission to access the [RejectCertificateTransfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun rejectCertificateTransfer(input: RejectCertificateTransferRequest): RejectCertificateTransferResponse

    /**
     * Removes the given thing from the billing group.
     *
     * Requires permission to access the [RemoveThingFromBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     */
    public suspend fun removeThingFromBillingGroup(input: RemoveThingFromBillingGroupRequest = RemoveThingFromBillingGroupRequest { }): RemoveThingFromBillingGroupResponse

    /**
     * Remove the specified thing from the specified group.
     *
     * You must specify either a `thingGroupArn` or a `thingGroupName` to identify the thing group and either a `thingArn` or a `thingName` to identify the thing to remove from the thing group.
     *
     * Requires permission to access the [RemoveThingFromThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun removeThingFromThingGroup(input: RemoveThingFromThingGroupRequest = RemoveThingFromThingGroupRequest { }): RemoveThingFromThingGroupResponse

    /**
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.
     *
     * Requires permission to access the [ReplaceTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun replaceTopicRule(input: ReplaceTopicRuleRequest): ReplaceTopicRuleResponse

    /**
     * The query search index.
     *
     * Requires permission to access the [SearchIndex](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun searchIndex(input: SearchIndexRequest): SearchIndexResponse

    /**
     * Sets the default authorizer. This will be used if a websocket connection is made without specifying an authorizer.
     *
     * Requires permission to access the [SetDefaultAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun setDefaultAuthorizer(input: SetDefaultAuthorizerRequest): SetDefaultAuthorizerResponse

    /**
     * Sets the specified version of the specified policy as the policy's default (operative) version. This action affects all certificates to which the policy is attached. To list the principals the policy is attached to, use the ListPrincipalPolicies action.
     *
     * Requires permission to access the [SetDefaultPolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun setDefaultPolicyVersion(input: SetDefaultPolicyVersionRequest): SetDefaultPolicyVersionResponse

    /**
     * Sets the logging options.
     *
     * NOTE: use of this command is not recommended. Use `SetV2LoggingOptions` instead.
     *
     * Requires permission to access the [SetLoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun setLoggingOptions(input: SetLoggingOptionsRequest): SetLoggingOptionsResponse

    /**
     * Sets the logging level.
     *
     * Requires permission to access the [SetV2LoggingLevel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun setV2LoggingLevel(input: SetV2LoggingLevelRequest): SetV2LoggingLevelResponse

    /**
     * Sets the logging options for the V2 logging service.
     *
     * Requires permission to access the [SetV2LoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun setV2LoggingOptions(input: SetV2LoggingOptionsRequest = SetV2LoggingOptionsRequest { }): SetV2LoggingOptionsResponse

    /**
     * Starts a task that applies a set of mitigation actions to the specified target.
     *
     * Requires permission to access the [StartAuditMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun startAuditMitigationActionsTask(input: StartAuditMitigationActionsTaskRequest): StartAuditMitigationActionsTaskResponse

    /**
     * Starts a Device Defender ML Detect mitigation actions task.
     *
     * Requires permission to access the [StartDetectMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun startDetectMitigationActionsTask(input: StartDetectMitigationActionsTaskRequest): StartDetectMitigationActionsTaskResponse

    /**
     * Starts an on-demand Device Defender audit.
     *
     * Requires permission to access the [StartOnDemandAuditTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun startOnDemandAuditTask(input: StartOnDemandAuditTaskRequest): StartOnDemandAuditTaskResponse

    /**
     * Creates a bulk thing provisioning task.
     *
     * Requires permission to access the [StartThingRegistrationTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun startThingRegistrationTask(input: StartThingRegistrationTaskRequest): StartThingRegistrationTaskResponse

    /**
     * Cancels a bulk thing provisioning task.
     *
     * Requires permission to access the [StopThingRegistrationTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun stopThingRegistrationTask(input: StopThingRegistrationTaskRequest): StopThingRegistrationTaskResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     *
     * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests if a specified principal is authorized to perform an IoT action on a specified resource. Use this to test and debug the authorization behavior of devices that connect to the IoT device gateway.
     *
     * Requires permission to access the [TestAuthorization](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun testAuthorization(input: TestAuthorizationRequest): TestAuthorizationResponse

    /**
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the custom authorization behavior of devices that connect to the IoT device gateway.
     *
     * Requires permission to access the [TestInvokeAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun testInvokeAuthorizer(input: TestInvokeAuthorizerRequest): TestInvokeAuthorizerResponse

    /**
     * Transfers the specified certificate to the specified Amazon Web Services account.
     *
     * Requires permission to access the [TransferCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * You can cancel the transfer until it is acknowledged by the recipient.
     *
     * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer target.
     *
     * The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate action to deactivate it.
     *
     * The certificate must not have any policies attached to it. You can use the DetachPolicy action to detach them.
     */
    public suspend fun transferCertificate(input: TransferCertificateRequest): TransferCertificateResponse

    /**
     * Removes the given tags (metadata) from the resource.
     *
     * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.
     *
     * Requires permission to access the [UpdateAccountAuditConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateAccountAuditConfiguration(input: UpdateAccountAuditConfigurationRequest = UpdateAccountAuditConfigurationRequest { }): UpdateAccountAuditConfigurationResponse

    /**
     * Updates a Device Defender audit suppression.
     */
    public suspend fun updateAuditSuppression(input: UpdateAuditSuppressionRequest): UpdateAuditSuppressionResponse

    /**
     * Updates an authorizer.
     *
     * Requires permission to access the [UpdateAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse

    /**
     * Updates information about the billing group.
     *
     * Requires permission to access the [UpdateBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateBillingGroup(input: UpdateBillingGroupRequest): UpdateBillingGroupResponse

    /**
     * Updates a registered CA certificate.
     *
     * Requires permission to access the [UpdateCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateCaCertificate(input: UpdateCaCertificateRequest): UpdateCaCertificateResponse

    /**
     * Updates the status of the specified certificate. This operation is idempotent.
     *
     * Requires permission to access the [UpdateCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * Certificates must be in the ACTIVE state to authenticate devices that use a certificate to connect to IoT.
     *
     * Within a few minutes of updating a certificate from the ACTIVE state to any other state, IoT disconnects all devices that used that certificate to connect. Devices cannot use a certificate that is not in the ACTIVE state to reconnect.
     */
    public suspend fun updateCertificate(input: UpdateCertificateRequest): UpdateCertificateResponse

    /**
     * Updates a certificate provider.
     *
     * Requires permission to access the [UpdateCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateCertificateProvider(input: UpdateCertificateProviderRequest): UpdateCertificateProviderResponse

    /**
     * Updates a Device Defender detect custom metric.
     *
     * Requires permission to access the [UpdateCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateCustomMetric(input: UpdateCustomMetricRequest): UpdateCustomMetricResponse

    /**
     * Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can delete it and recreate it).
     *
     * Requires permission to access the [UpdateDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateDimension(input: UpdateDimensionRequest): UpdateDimensionResponse

    /**
     * Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.
     *
     * Requires permission to access the [UpdateDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateDomainConfiguration(input: UpdateDomainConfigurationRequest): UpdateDomainConfigurationResponse

    /**
     * Updates a dynamic thing group.
     *
     * Requires permission to access the [UpdateDynamicThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateDynamicThingGroup(input: UpdateDynamicThingGroupRequest): UpdateDynamicThingGroupResponse

    /**
     * Updates the event configurations.
     *
     * Requires permission to access the [UpdateEventConfigurations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateEventConfigurations(input: UpdateEventConfigurationsRequest = UpdateEventConfigurationsRequest { }): UpdateEventConfigurationsResponse

    /**
     * Updates the data for a fleet metric.
     *
     * Requires permission to access the [UpdateFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateFleetMetric(input: UpdateFleetMetricRequest): UpdateFleetMetricResponse

    /**
     * Updates the search configuration.
     *
     * Requires permission to access the [UpdateIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateIndexingConfiguration(input: UpdateIndexingConfigurationRequest = UpdateIndexingConfigurationRequest { }): UpdateIndexingConfigurationResponse

    /**
     * Updates supported fields of the specified job.
     *
     * Requires permission to access the [UpdateJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateJob(input: UpdateJobRequest): UpdateJobResponse

    /**
     * Updates the definition for the specified mitigation action.
     *
     * Requires permission to access the [UpdateMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateMitigationAction(input: UpdateMitigationActionRequest): UpdateMitigationActionResponse

    /**
     * Updates the supported fields for a specific software package.
     *
     * Requires permission to access the [UpdatePackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
     */
    public suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse

    /**
     * Updates the software package configuration.
     *
     * Requires permission to access the [UpdatePackageConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [iam:PassRole](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html) actions.
     */
    public suspend fun updatePackageConfiguration(input: UpdatePackageConfigurationRequest = UpdatePackageConfigurationRequest { }): UpdatePackageConfigurationResponse

    /**
     * Updates the supported fields for a specific package version.
     *
     * Requires permission to access the [UpdatePackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
     */
    public suspend fun updatePackageVersion(input: UpdatePackageVersionRequest): UpdatePackageVersionResponse

    /**
     * Updates a provisioning template.
     *
     * Requires permission to access the [UpdateProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateProvisioningTemplate(input: UpdateProvisioningTemplateRequest): UpdateProvisioningTemplateResponse

    /**
     * Updates a role alias.
     *
     * Requires permission to access the [UpdateRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateRoleAlias(input: UpdateRoleAliasRequest): UpdateRoleAliasResponse

    /**
     * Updates a scheduled audit, including which checks are performed and how often the audit takes place.
     *
     * Requires permission to access the [UpdateScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateScheduledAudit(input: UpdateScheduledAuditRequest): UpdateScheduledAuditResponse

    /**
     * Updates a Device Defender security profile.
     *
     * Requires permission to access the [UpdateSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse

    /**
     * Updates an existing stream. The stream version will be incremented by one.
     *
     * Requires permission to access the [UpdateStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateStream(input: UpdateStreamRequest): UpdateStreamResponse

    /**
     * Updates the data for a thing.
     *
     * Requires permission to access the [UpdateThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateThing(input: UpdateThingRequest): UpdateThingResponse

    /**
     * Update a thing group.
     *
     * Requires permission to access the [UpdateThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateThingGroup(input: UpdateThingGroupRequest): UpdateThingGroupResponse

    /**
     * Updates the groups to which the thing belongs.
     *
     * Requires permission to access the [UpdateThingGroupsForThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateThingGroupsForThing(input: UpdateThingGroupsForThingRequest = UpdateThingGroupsForThingRequest { }): UpdateThingGroupsForThingResponse

    /**
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the destination.
     *
     * Requires permission to access the [UpdateTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateTopicRuleDestination(input: UpdateTopicRuleDestinationRequest): UpdateTopicRuleDestinationResponse

    /**
     * Validates a Device Defender security profile behaviors specification.
     *
     * Requires permission to access the [ValidateSecurityProfileBehaviors](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun validateSecurityProfileBehaviors(input: ValidateSecurityProfileBehaviorsRequest): ValidateSecurityProfileBehaviorsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotClient.withConfig(block: IotClient.Config.Builder.() -> Unit): IotClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotClient(newConfig)
}

/**
 * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
 *
 * To check for pending certificate transfers, call ListCertificates to enumerate your certificates.
 *
 * Requires permission to access the [AcceptCertificateTransfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.acceptCertificateTransfer(crossinline block: AcceptCertificateTransferRequest.Builder.() -> Unit): AcceptCertificateTransferResponse = acceptCertificateTransfer(AcceptCertificateTransferRequest.Builder().apply(block).build())

/**
 * Adds a thing to a billing group.
 *
 * Requires permission to access the [AddThingToBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.addThingToBillingGroup(crossinline block: AddThingToBillingGroupRequest.Builder.() -> Unit): AddThingToBillingGroupResponse = addThingToBillingGroup(AddThingToBillingGroupRequest.Builder().apply(block).build())

/**
 * Adds a thing to a thing group.
 *
 * Requires permission to access the [AddThingToThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.addThingToThingGroup(crossinline block: AddThingToThingGroupRequest.Builder.() -> Unit): AddThingToThingGroupResponse = addThingToThingGroup(AddThingToThingGroupRequest.Builder().apply(block).build())

/**
 * Associates a group with a continuous job. The following criteria must be met:
 * + The job must have been created with the `targetSelection` field set to "CONTINUOUS".
 * + The job status must currently be "IN_PROGRESS".
 * + The total number of targets associated with a job must not exceed 100.
 *
 * Requires permission to access the [AssociateTargetsWithJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.associateTargetsWithJob(crossinline block: AssociateTargetsWithJobRequest.Builder.() -> Unit): AssociateTargetsWithJobResponse = associateTargetsWithJob(AssociateTargetsWithJobRequest.Builder().apply(block).build())

/**
 * Attaches the specified policy to the specified principal (certificate or other credential).
 *
 * Requires permission to access the [AttachPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.attachPolicy(crossinline block: AttachPolicyRequest.Builder.() -> Unit): AttachPolicyResponse = attachPolicy(AttachPolicyRequest.Builder().apply(block).build())

/**
 * Attaches the specified policy to the specified principal (certificate or other credential).
 *
 * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use AttachPolicy instead.
 *
 * Requires permission to access the [AttachPrincipalPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IotClient.attachPrincipalPolicy(crossinline block: AttachPrincipalPolicyRequest.Builder.() -> Unit): AttachPrincipalPolicyResponse = attachPrincipalPolicy(AttachPrincipalPolicyRequest.Builder().apply(block).build())

/**
 * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can have up to five security profiles associated with it.
 *
 * Requires permission to access the [AttachSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.attachSecurityProfile(crossinline block: AttachSecurityProfileRequest.Builder.() -> Unit): AttachSecurityProfileResponse = attachSecurityProfile(AttachSecurityProfileRequest.Builder().apply(block).build())

/**
 * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, Amazon Cognito identities or federated identities.
 *
 * Requires permission to access the [AttachThingPrincipal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.attachThingPrincipal(crossinline block: AttachThingPrincipalRequest.Builder.() -> Unit): AttachThingPrincipalResponse = attachThingPrincipal(AttachThingPrincipalRequest.Builder().apply(block).build())

/**
 * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException occurs.
 *
 * Requires permission to access the [CancelAuditMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.cancelAuditMitigationActionsTask(crossinline block: CancelAuditMitigationActionsTaskRequest.Builder.() -> Unit): CancelAuditMitigationActionsTaskResponse = cancelAuditMitigationActionsTask(CancelAuditMitigationActionsTaskRequest.Builder().apply(block).build())

/**
 * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.
 *
 * Requires permission to access the [CancelAuditTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.cancelAuditTask(crossinline block: CancelAuditTaskRequest.Builder.() -> Unit): CancelAuditTaskResponse = cancelAuditTask(CancelAuditTaskRequest.Builder().apply(block).build())

/**
 * Cancels a pending transfer for the specified certificate.
 *
 * **Note** Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use RejectCertificateTransfer instead.) After transfer, IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled.
 *
 * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.
 *
 * Requires permission to access the [CancelCertificateTransfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.cancelCertificateTransfer(crossinline block: CancelCertificateTransferRequest.Builder.() -> Unit): CancelCertificateTransferResponse = cancelCertificateTransfer(CancelCertificateTransferRequest.Builder().apply(block).build())

/**
 * Cancels a Device Defender ML Detect mitigation action.
 *
 * Requires permission to access the [CancelDetectMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.cancelDetectMitigationActionsTask(crossinline block: CancelDetectMitigationActionsTaskRequest.Builder.() -> Unit): CancelDetectMitigationActionsTaskResponse = cancelDetectMitigationActionsTask(CancelDetectMitigationActionsTaskRequest.Builder().apply(block).build())

/**
 * Cancels a job.
 *
 * Requires permission to access the [CancelJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * Cancels the execution of a job for a given thing.
 *
 * Requires permission to access the [CancelJobExecution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.cancelJobExecution(crossinline block: CancelJobExecutionRequest.Builder.() -> Unit): CancelJobExecutionResponse = cancelJobExecution(CancelJobExecutionRequest.Builder().apply(block).build())

/**
 * Clears the default authorizer.
 *
 * Requires permission to access the [ClearDefaultAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.clearDefaultAuthorizer(crossinline block: ClearDefaultAuthorizerRequest.Builder.() -> Unit): ClearDefaultAuthorizerResponse = clearDefaultAuthorizer(ClearDefaultAuthorizerRequest.Builder().apply(block).build())

/**
 * Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation message to the endpoint or base address you specify. The message includes a token which you pass back when calling `ConfirmTopicRuleDestination` to confirm that you own or have access to the endpoint.
 *
 * Requires permission to access the [ConfirmTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.confirmTopicRuleDestination(crossinline block: ConfirmTopicRuleDestinationRequest.Builder.() -> Unit): ConfirmTopicRuleDestinationResponse = confirmTopicRuleDestination(ConfirmTopicRuleDestinationRequest.Builder().apply(block).build())

/**
 * Creates a Device Defender audit suppression.
 *
 * Requires permission to access the [CreateAuditSuppression](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createAuditSuppression(crossinline block: CreateAuditSuppressionRequest.Builder.() -> Unit): CreateAuditSuppressionResponse = createAuditSuppression(CreateAuditSuppressionRequest.Builder().apply(block).build())

/**
 * Creates an authorizer.
 *
 * Requires permission to access the [CreateAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createAuthorizer(crossinline block: CreateAuthorizerRequest.Builder.() -> Unit): CreateAuthorizerResponse = createAuthorizer(CreateAuthorizerRequest.Builder().apply(block).build())

/**
 * Creates a billing group.
 *
 * Requires permission to access the [CreateBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createBillingGroup(crossinline block: CreateBillingGroupRequest.Builder.() -> Unit): CreateBillingGroupResponse = createBillingGroup(CreateBillingGroupRequest.Builder().apply(block).build())

/**
 * Creates an X.509 certificate using the specified certificate signing request.
 *
 * Requires permission to access the [CreateCertificateFromCsr](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult [ Certificate signing algorithms supported by IoT](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms).
 *
 * Reusing the same certificate signing request (CSR) results in a distinct certificate.
 *
 * You can create multiple certificates in a batch by creating a directory, copying multiple `.csr` files into that directory, and then specifying that directory on the command line. The following commands show how to create a batch of certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs are located inside of the directory my-csr-directory:
 *
 * On Linux and OS X, the command is:
 *
 * `$ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}`
 *
 * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the `aws iot create-certificate-from-csr` Amazon Web Services CLI command to create a certificate for the corresponding CSR.
 *
 * You can also run the `aws iot create-certificate-from-csr` part of the command in parallel to speed up the certificate creation process:
 *
 * `$ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{} `
 *
 * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
 *
 * `> ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/$_} `
 *
 * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
 *
 * `> forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path" `
 */
public suspend inline fun IotClient.createCertificateFromCsr(crossinline block: CreateCertificateFromCsrRequest.Builder.() -> Unit): CreateCertificateFromCsrResponse = createCertificateFromCsr(CreateCertificateFromCsrRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services IoT Core certificate provider. You can use Amazon Web Services IoT Core certificate provider to customize how to sign a certificate signing request (CSR) in IoT fleet provisioning. For more information, see [Customizing certificate signing using Amazon Web Services IoT Core certificate provider](https://docs.aws.amazon.com/iot/latest/developerguide/provisioning-cert-provider.html) from *Amazon Web Services IoT Core Developer Guide*.
 *
 * Requires permission to access the [CreateCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * After you create a certificate provider, the behavior of `CreateCertificateFromCsr`[ API for fleet provisioning](https://docs.aws.amazon.com/iot/latest/developerguide/fleet-provision-api.html#create-cert-csr) will change and all API calls to `CreateCertificateFromCsr` will invoke the certificate provider to create the certificates. It can take up to a few minutes for this behavior to change after a certificate provider is created.
 */
public suspend inline fun IotClient.createCertificateProvider(crossinline block: CreateCertificateProviderRequest.Builder.() -> Unit): CreateCertificateProviderResponse = createCertificateProvider(CreateCertificateProviderRequest.Builder().apply(block).build())

/**
 * Use this API to define a Custom Metric published by your devices to Device Defender.
 *
 * Requires permission to access the [CreateCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createCustomMetric(crossinline block: CreateCustomMetricRequest.Builder.() -> Unit): CreateCustomMetricResponse = createCustomMetric(CreateCustomMetricRequest.Builder().apply(block).build())

/**
 * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender. For example, using a `TOPIC_FILTER` dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.
 *
 * Requires permission to access the [CreateDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createDimension(crossinline block: CreateDimensionRequest.Builder.() -> Unit): CreateDimensionResponse = createDimension(CreateDimensionRequest.Builder().apply(block).build())

/**
 * Creates a domain configuration.
 *
 * Requires permission to access the [CreateDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createDomainConfiguration(crossinline block: CreateDomainConfigurationRequest.Builder.() -> Unit): CreateDomainConfigurationResponse = createDomainConfiguration(CreateDomainConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a dynamic thing group.
 *
 * Requires permission to access the [CreateDynamicThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createDynamicThingGroup(crossinline block: CreateDynamicThingGroupRequest.Builder.() -> Unit): CreateDynamicThingGroupResponse = createDynamicThingGroup(CreateDynamicThingGroupRequest.Builder().apply(block).build())

/**
 * Creates a fleet metric.
 *
 * Requires permission to access the [CreateFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createFleetMetric(crossinline block: CreateFleetMetricRequest.Builder.() -> Unit): CreateFleetMetricResponse = createFleetMetric(CreateFleetMetricRequest.Builder().apply(block).build())

/**
 * Creates a job.
 *
 * Requires permission to access the [CreateJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * Creates a job template.
 *
 * Requires permission to access the [CreateJobTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createJobTemplate(crossinline block: CreateJobTemplateRequest.Builder.() -> Unit): CreateJobTemplateResponse = createJobTemplate(CreateJobTemplateRequest.Builder().apply(block).build())

/**
 * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call `CreateKeysAndCertificate` over MQTT from a device, for more information, see [Provisioning MQTT API](https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api).
 *
 * **Note** This is the only time IoT issues the private key for this certificate, so it is important to keep it in a secure location.
 *
 * Requires permission to access the [CreateKeysAndCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createKeysAndCertificate(crossinline block: CreateKeysAndCertificateRequest.Builder.() -> Unit): CreateKeysAndCertificateResponse = createKeysAndCertificate(CreateKeysAndCertificateRequest.Builder().apply(block).build())

/**
 * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names. For more information, see [Mitigation actions](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html). Each mitigation action can apply only one type of change.
 *
 * Requires permission to access the [CreateMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createMitigationAction(crossinline block: CreateMitigationActionRequest.Builder.() -> Unit): CreateMitigationActionResponse = createMitigationAction(CreateMitigationActionRequest.Builder().apply(block).build())

/**
 * Creates an IoT OTA update on a target group of things or groups.
 *
 * Requires permission to access the [CreateOTAUpdate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createOtaUpdate(crossinline block: CreateOtaUpdateRequest.Builder.() -> Unit): CreateOtaUpdateResponse = createOtaUpdate(CreateOtaUpdateRequest.Builder().apply(block).build())

/**
 * Creates an IoT software package that can be deployed to your fleet.
 *
 * Requires permission to access the [CreatePackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
 */
public suspend inline fun IotClient.createPackage(crossinline block: CreatePackageRequest.Builder.() -> Unit): CreatePackageResponse = createPackage(CreatePackageRequest.Builder().apply(block).build())

/**
 * Creates a new version for an existing IoT software package.
 *
 * Requires permission to access the [CreatePackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
 */
public suspend inline fun IotClient.createPackageVersion(crossinline block: CreatePackageVersionRequest.Builder.() -> Unit): CreatePackageVersionResponse = createPackageVersion(CreatePackageVersionRequest.Builder().apply(block).build())

/**
 * Creates an IoT policy.
 *
 * The created policy is the default version for the policy. This operation creates a policy version with a version identifier of **1** and sets **1** as the policy's default version.
 *
 * Requires permission to access the [CreatePolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createPolicy(crossinline block: CreatePolicyRequest.Builder.() -> Unit): CreatePolicyResponse = createPolicy(CreatePolicyRequest.Builder().apply(block).build())

/**
 * Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use DeletePolicyVersion to delete an existing version before you create a new one.
 *
 * Optionally, you can set the new version as the policy's default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).
 *
 * Requires permission to access the [CreatePolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createPolicyVersion(crossinline block: CreatePolicyVersionRequest.Builder.() -> Unit): CreatePolicyVersionResponse = createPolicyVersion(CreatePolicyVersionRequest.Builder().apply(block).build())

/**
 * Creates a provisioning claim.
 *
 * Requires permission to access the [CreateProvisioningClaim](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createProvisioningClaim(crossinline block: CreateProvisioningClaimRequest.Builder.() -> Unit): CreateProvisioningClaimResponse = createProvisioningClaim(CreateProvisioningClaimRequest.Builder().apply(block).build())

/**
 * Creates a provisioning template.
 *
 * Requires permission to access the [CreateProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createProvisioningTemplate(crossinline block: CreateProvisioningTemplateRequest.Builder.() -> Unit): CreateProvisioningTemplateResponse = createProvisioningTemplate(CreateProvisioningTemplateRequest.Builder().apply(block).build())

/**
 * Creates a new version of a provisioning template.
 *
 * Requires permission to access the [CreateProvisioningTemplateVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createProvisioningTemplateVersion(crossinline block: CreateProvisioningTemplateVersionRequest.Builder.() -> Unit): CreateProvisioningTemplateVersionResponse = createProvisioningTemplateVersion(CreateProvisioningTemplateVersionRequest.Builder().apply(block).build())

/**
 * Creates a role alias.
 *
 * Requires permission to access the [CreateRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createRoleAlias(crossinline block: CreateRoleAliasRequest.Builder.() -> Unit): CreateRoleAliasResponse = createRoleAlias(CreateRoleAliasRequest.Builder().apply(block).build())

/**
 * Creates a scheduled audit that is run at a specified time interval.
 *
 * Requires permission to access the [CreateScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createScheduledAudit(crossinline block: CreateScheduledAuditRequest.Builder.() -> Unit): CreateScheduledAuditResponse = createScheduledAudit(CreateScheduledAuditRequest.Builder().apply(block).build())

/**
 * Creates a Device Defender security profile.
 *
 * Requires permission to access the [CreateSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createSecurityProfile(crossinline block: CreateSecurityProfileRequest.Builder.() -> Unit): CreateSecurityProfileResponse = createSecurityProfile(CreateSecurityProfileRequest.Builder().apply(block).build())

/**
 * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with a stream.
 *
 * Requires permission to access the [CreateStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createStream(crossinline block: CreateStreamRequest.Builder.() -> Unit): CreateStreamResponse = createStream(CreateStreamRequest.Builder().apply(block).build())

/**
 * Creates a thing record in the registry. If this call is made multiple times using the same thing name and configuration, the call will succeed. If this call is made with the same thing name but different configuration a `ResourceAlreadyExistsException` is thrown.
 *
 * This is a control plane operation. See [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html) for information about authorizing control plane actions.
 *
 * Requires permission to access the [CreateThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createThing(crossinline block: CreateThingRequest.Builder.() -> Unit): CreateThingResponse = createThing(CreateThingRequest.Builder().apply(block).build())

/**
 * Create a thing group.
 *
 * This is a control plane operation. See [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html) for information about authorizing control plane actions.
 *
 * If the `ThingGroup` that you create has the exact same attributes as an existing `ThingGroup`, you will get a 200 success response.
 *
 * Requires permission to access the [CreateThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createThingGroup(crossinline block: CreateThingGroupRequest.Builder.() -> Unit): CreateThingGroupResponse = createThingGroup(CreateThingGroupRequest.Builder().apply(block).build())

/**
 * Creates a new thing type.
 *
 * Requires permission to access the [CreateThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createThingType(crossinline block: CreateThingTypeRequest.Builder.() -> Unit): CreateThingTypeResponse = createThingType(CreateThingTypeRequest.Builder().apply(block).build())

/**
 * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.
 *
 * Requires permission to access the [CreateTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createTopicRule(crossinline block: CreateTopicRuleRequest.Builder.() -> Unit): CreateTopicRuleResponse = createTopicRule(CreateTopicRuleRequest.Builder().apply(block).build())

/**
 * Creates a topic rule destination. The destination must be confirmed prior to use.
 *
 * Requires permission to access the [CreateTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.createTopicRuleDestination(crossinline block: CreateTopicRuleDestinationRequest.Builder.() -> Unit): CreateTopicRuleDestinationResponse = createTopicRuleDestination(CreateTopicRuleDestinationRequest.Builder().apply(block).build())

/**
 * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is deleted and all audit checks are reset to disabled.
 *
 * Requires permission to access the [DeleteAccountAuditConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteAccountAuditConfiguration(crossinline block: DeleteAccountAuditConfigurationRequest.Builder.() -> Unit): DeleteAccountAuditConfigurationResponse = deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a Device Defender audit suppression.
 *
 * Requires permission to access the [DeleteAuditSuppression](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteAuditSuppression(crossinline block: DeleteAuditSuppressionRequest.Builder.() -> Unit): DeleteAuditSuppressionResponse = deleteAuditSuppression(DeleteAuditSuppressionRequest.Builder().apply(block).build())

/**
 * Deletes an authorizer.
 *
 * Requires permission to access the [DeleteAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteAuthorizer(crossinline block: DeleteAuthorizerRequest.Builder.() -> Unit): DeleteAuthorizerResponse = deleteAuthorizer(DeleteAuthorizerRequest.Builder().apply(block).build())

/**
 * Deletes the billing group.
 *
 * Requires permission to access the [DeleteBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteBillingGroup(crossinline block: DeleteBillingGroupRequest.Builder.() -> Unit): DeleteBillingGroupResponse = deleteBillingGroup(DeleteBillingGroupRequest.Builder().apply(block).build())

/**
 * Deletes a registered CA certificate.
 *
 * Requires permission to access the [DeleteCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteCaCertificate(crossinline block: DeleteCaCertificateRequest.Builder.() -> Unit): DeleteCaCertificateResponse = deleteCaCertificate(DeleteCaCertificateRequest.Builder().apply(block).build())

/**
 * Deletes the specified certificate.
 *
 * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE. To delete a certificate, first use the DetachPolicy action to detach all policies. Next, use the UpdateCertificate action to set the certificate to the INACTIVE status.
 *
 * Requires permission to access the [DeleteCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteCertificate(crossinline block: DeleteCertificateRequest.Builder.() -> Unit): DeleteCertificateResponse = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

/**
 * Deletes a certificate provider.
 *
 * Requires permission to access the [DeleteCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * If you delete the certificate provider resource, the behavior of `CreateCertificateFromCsr` will resume, and IoT will create certificates signed by IoT from a certificate signing request (CSR).
 */
public suspend inline fun IotClient.deleteCertificateProvider(crossinline block: DeleteCertificateProviderRequest.Builder.() -> Unit): DeleteCertificateProviderResponse = deleteCertificateProvider(DeleteCertificateProviderRequest.Builder().apply(block).build())

/**
 * Deletes a Device Defender detect custom metric.
 *
 * Requires permission to access the [DeleteCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a part of. The security profile associated with the custom metric can be found using the [ListSecurityProfiles](https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html) API with `metricName` set to your custom metric name.
 */
public suspend inline fun IotClient.deleteCustomMetric(crossinline block: DeleteCustomMetricRequest.Builder.() -> Unit): DeleteCustomMetricResponse = deleteCustomMetric(DeleteCustomMetricRequest.Builder().apply(block).build())

/**
 * Removes the specified dimension from your Amazon Web Services accounts.
 *
 * Requires permission to access the [DeleteDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteDimension(crossinline block: DeleteDimensionRequest.Builder.() -> Unit): DeleteDimensionResponse = deleteDimension(DeleteDimensionRequest.Builder().apply(block).build())

/**
 * Deletes the specified domain configuration.
 *
 * Requires permission to access the [DeleteDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteDomainConfiguration(crossinline block: DeleteDomainConfigurationRequest.Builder.() -> Unit): DeleteDomainConfigurationResponse = deleteDomainConfiguration(DeleteDomainConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a dynamic thing group.
 *
 * Requires permission to access the [DeleteDynamicThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteDynamicThingGroup(crossinline block: DeleteDynamicThingGroupRequest.Builder.() -> Unit): DeleteDynamicThingGroupResponse = deleteDynamicThingGroup(DeleteDynamicThingGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.
 *
 * Requires permission to access the [DeleteFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteFleetMetric(crossinline block: DeleteFleetMetricRequest.Builder.() -> Unit): DeleteFleetMetricResponse = deleteFleetMetric(DeleteFleetMetricRequest.Builder().apply(block).build())

/**
 * Deletes a job and its related job executions.
 *
 * Deleting a job may take time, depending on the number of job executions created for the job and various other factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
 *
 * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
 *
 * Requires permission to access the [DeleteJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteJob(crossinline block: DeleteJobRequest.Builder.() -> Unit): DeleteJobResponse = deleteJob(DeleteJobRequest.Builder().apply(block).build())

/**
 * Deletes a job execution.
 *
 * Requires permission to access the [DeleteJobExecution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteJobExecution(crossinline block: DeleteJobExecutionRequest.Builder.() -> Unit): DeleteJobExecutionResponse = deleteJobExecution(DeleteJobExecutionRequest.Builder().apply(block).build())

/**
 * Deletes the specified job template.
 */
public suspend inline fun IotClient.deleteJobTemplate(crossinline block: DeleteJobTemplateRequest.Builder.() -> Unit): DeleteJobTemplateResponse = deleteJobTemplate(DeleteJobTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a defined mitigation action from your Amazon Web Services accounts.
 *
 * Requires permission to access the [DeleteMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteMitigationAction(crossinline block: DeleteMitigationActionRequest.Builder.() -> Unit): DeleteMitigationActionResponse = deleteMitigationAction(DeleteMitigationActionRequest.Builder().apply(block).build())

/**
 * Delete an OTA update.
 *
 * Requires permission to access the [DeleteOTAUpdate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteOtaUpdate(crossinline block: DeleteOtaUpdateRequest.Builder.() -> Unit): DeleteOtaUpdateResponse = deleteOtaUpdate(DeleteOtaUpdateRequest.Builder().apply(block).build())

/**
 * Deletes a specific version from a software package.
 *
 * **Note:** All package versions must be deleted before deleting the software package.
 *
 * Requires permission to access the [DeletePackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deletePackage(crossinline block: DeletePackageRequest.Builder.() -> Unit): DeletePackageResponse = deletePackage(DeletePackageRequest.Builder().apply(block).build())

/**
 * Deletes a specific version from a software package.
 *
 * **Note:** If a package version is designated as default, you must remove the designation from the software package using the UpdatePackage action.
 */
public suspend inline fun IotClient.deletePackageVersion(crossinline block: DeletePackageVersionRequest.Builder.() -> Unit): DeletePackageVersionResponse = deletePackageVersion(DeletePackageVersionRequest.Builder().apply(block).build())

/**
 * Deletes the specified policy.
 *
 * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
 *
 * To delete a policy, use the DeletePolicyVersion action to delete all non-default versions of the policy; use the DetachPolicy action to detach the policy from any certificate; and then use the DeletePolicy action to delete the policy.
 *
 * When a policy is deleted using DeletePolicy, its default version is deleted with it.
 *
 * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.
 *
 * Requires permission to access the [DeletePolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this action. To delete the default version of a policy, use DeletePolicy. To find out which version of a policy is marked as the default version, use ListPolicyVersions.
 *
 * Requires permission to access the [DeletePolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deletePolicyVersion(crossinline block: DeletePolicyVersionRequest.Builder.() -> Unit): DeletePolicyVersionResponse = deletePolicyVersion(DeletePolicyVersionRequest.Builder().apply(block).build())

/**
 * Deletes a provisioning template.
 *
 * Requires permission to access the [DeleteProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteProvisioningTemplate(crossinline block: DeleteProvisioningTemplateRequest.Builder.() -> Unit): DeleteProvisioningTemplateResponse = deleteProvisioningTemplate(DeleteProvisioningTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a provisioning template version.
 *
 * Requires permission to access the [DeleteProvisioningTemplateVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteProvisioningTemplateVersion(crossinline block: DeleteProvisioningTemplateVersionRequest.Builder.() -> Unit): DeleteProvisioningTemplateVersionResponse = deleteProvisioningTemplateVersion(DeleteProvisioningTemplateVersionRequest.Builder().apply(block).build())

/**
 * Deletes a CA certificate registration code.
 *
 * Requires permission to access the [DeleteRegistrationCode](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteRegistrationCode(crossinline block: DeleteRegistrationCodeRequest.Builder.() -> Unit): DeleteRegistrationCodeResponse = deleteRegistrationCode(DeleteRegistrationCodeRequest.Builder().apply(block).build())

/**
 * Deletes a role alias
 *
 * Requires permission to access the [DeleteRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteRoleAlias(crossinline block: DeleteRoleAliasRequest.Builder.() -> Unit): DeleteRoleAliasResponse = deleteRoleAlias(DeleteRoleAliasRequest.Builder().apply(block).build())

/**
 * Deletes a scheduled audit.
 *
 * Requires permission to access the [DeleteScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteScheduledAudit(crossinline block: DeleteScheduledAuditRequest.Builder.() -> Unit): DeleteScheduledAuditResponse = deleteScheduledAudit(DeleteScheduledAuditRequest.Builder().apply(block).build())

/**
 * Deletes a Device Defender security profile.
 *
 * Requires permission to access the [DeleteSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteSecurityProfile(crossinline block: DeleteSecurityProfileRequest.Builder.() -> Unit): DeleteSecurityProfileResponse = deleteSecurityProfile(DeleteSecurityProfileRequest.Builder().apply(block).build())

/**
 * Deletes a stream.
 *
 * Requires permission to access the [DeleteStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteStream(crossinline block: DeleteStreamRequest.Builder.() -> Unit): DeleteStreamResponse = deleteStream(DeleteStreamRequest.Builder().apply(block).build())

/**
 * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a thing that doesn't exist.
 *
 * Requires permission to access the [DeleteThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteThing(crossinline block: DeleteThingRequest.Builder.() -> Unit): DeleteThingResponse = deleteThing(DeleteThingRequest.Builder().apply(block).build())

/**
 * Deletes a thing group.
 *
 * Requires permission to access the [DeleteThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteThingGroup(crossinline block: DeleteThingGroupRequest.Builder.() -> Unit): DeleteThingGroupResponse = deleteThingGroup(DeleteThingGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling DeprecateThingType, then remove any associated things by calling UpdateThing to change the thing type on any associated thing, and finally use DeleteThingType to delete the thing type.
 *
 * Requires permission to access the [DeleteThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteThingType(crossinline block: DeleteThingTypeRequest.Builder.() -> Unit): DeleteThingTypeResponse = deleteThingType(DeleteThingTypeRequest.Builder().apply(block).build())

/**
 * Deletes the rule.
 *
 * Requires permission to access the [DeleteTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteTopicRule(crossinline block: DeleteTopicRuleRequest.Builder.() -> Unit): DeleteTopicRuleResponse = deleteTopicRule(DeleteTopicRuleRequest.Builder().apply(block).build())

/**
 * Deletes a topic rule destination.
 *
 * Requires permission to access the [DeleteTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteTopicRuleDestination(crossinline block: DeleteTopicRuleDestinationRequest.Builder.() -> Unit): DeleteTopicRuleDestinationResponse = deleteTopicRuleDestination(DeleteTopicRuleDestinationRequest.Builder().apply(block).build())

/**
 * Deletes a logging level.
 *
 * Requires permission to access the [DeleteV2LoggingLevel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deleteV2LoggingLevel(crossinline block: DeleteV2LoggingLevelRequest.Builder.() -> Unit): DeleteV2LoggingLevelResponse = deleteV2LoggingLevel(DeleteV2LoggingLevelRequest.Builder().apply(block).build())

/**
 * Deprecates a thing type. You can not associate new things with deprecated thing type.
 *
 * Requires permission to access the [DeprecateThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.deprecateThingType(crossinline block: DeprecateThingTypeRequest.Builder.() -> Unit): DeprecateThingTypeResponse = deprecateThingType(DeprecateThingTypeRequest.Builder().apply(block).build())

/**
 * Gets information about the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.
 *
 * Requires permission to access the [DescribeAccountAuditConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeAccountAuditConfiguration(crossinline block: DescribeAccountAuditConfigurationRequest.Builder.() -> Unit): DescribeAccountAuditConfigurationResponse = describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and the start time when the audit that returned the finding.
 *
 * Requires permission to access the [DescribeAuditFinding](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeAuditFinding(crossinline block: DescribeAuditFindingRequest.Builder.() -> Unit): DescribeAuditFindingResponse = describeAuditFinding(DescribeAuditFindingRequest.Builder().apply(block).build())

/**
 * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.
 */
public suspend inline fun IotClient.describeAuditMitigationActionsTask(crossinline block: DescribeAuditMitigationActionsTaskRequest.Builder.() -> Unit): DescribeAuditMitigationActionsTaskResponse = describeAuditMitigationActionsTask(DescribeAuditMitigationActionsTaskRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Defender audit suppression.
 */
public suspend inline fun IotClient.describeAuditSuppression(crossinline block: DescribeAuditSuppressionRequest.Builder.() -> Unit): DescribeAuditSuppressionResponse = describeAuditSuppression(DescribeAuditSuppressionRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Defender audit.
 *
 * Requires permission to access the [DescribeAuditTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeAuditTask(crossinline block: DescribeAuditTaskRequest.Builder.() -> Unit): DescribeAuditTaskResponse = describeAuditTask(DescribeAuditTaskRequest.Builder().apply(block).build())

/**
 * Describes an authorizer.
 *
 * Requires permission to access the [DescribeAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeAuthorizer(crossinline block: DescribeAuthorizerRequest.Builder.() -> Unit): DescribeAuthorizerResponse = describeAuthorizer(DescribeAuthorizerRequest.Builder().apply(block).build())

/**
 * Returns information about a billing group.
 *
 * Requires permission to access the [DescribeBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeBillingGroup(crossinline block: DescribeBillingGroupRequest.Builder.() -> Unit): DescribeBillingGroupResponse = describeBillingGroup(DescribeBillingGroupRequest.Builder().apply(block).build())

/**
 * Describes a registered CA certificate.
 *
 * Requires permission to access the [DescribeCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeCaCertificate(crossinline block: DescribeCaCertificateRequest.Builder.() -> Unit): DescribeCaCertificateResponse = describeCaCertificate(DescribeCaCertificateRequest.Builder().apply(block).build())

/**
 * Gets information about the specified certificate.
 *
 * Requires permission to access the [DescribeCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeCertificate(crossinline block: DescribeCertificateRequest.Builder.() -> Unit): DescribeCertificateResponse = describeCertificate(DescribeCertificateRequest.Builder().apply(block).build())

/**
 * Describes a certificate provider.
 *
 * Requires permission to access the [DescribeCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeCertificateProvider(crossinline block: DescribeCertificateProviderRequest.Builder.() -> Unit): DescribeCertificateProviderResponse = describeCertificateProvider(DescribeCertificateProviderRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Defender detect custom metric.
 *
 * Requires permission to access the [DescribeCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeCustomMetric(crossinline block: DescribeCustomMetricRequest.Builder.() -> Unit): DescribeCustomMetricResponse = describeCustomMetric(DescribeCustomMetricRequest.Builder().apply(block).build())

/**
 * Describes the default authorizer.
 *
 * Requires permission to access the [DescribeDefaultAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeDefaultAuthorizer(crossinline block: DescribeDefaultAuthorizerRequest.Builder.() -> Unit): DescribeDefaultAuthorizerResponse = describeDefaultAuthorizer(DescribeDefaultAuthorizerRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Defender ML Detect mitigation action.
 *
 * Requires permission to access the [DescribeDetectMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeDetectMitigationActionsTask(crossinline block: DescribeDetectMitigationActionsTaskRequest.Builder.() -> Unit): DescribeDetectMitigationActionsTaskResponse = describeDetectMitigationActionsTask(DescribeDetectMitigationActionsTaskRequest.Builder().apply(block).build())

/**
 * Provides details about a dimension that is defined in your Amazon Web Services accounts.
 *
 * Requires permission to access the [DescribeDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeDimension(crossinline block: DescribeDimensionRequest.Builder.() -> Unit): DescribeDimensionResponse = describeDimension(DescribeDimensionRequest.Builder().apply(block).build())

/**
 * Gets summary information about a domain configuration.
 *
 * Requires permission to access the [DescribeDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeDomainConfiguration(crossinline block: DescribeDomainConfigurationRequest.Builder.() -> Unit): DescribeDomainConfigurationResponse = describeDomainConfiguration(DescribeDomainConfigurationRequest.Builder().apply(block).build())

/**
 * Returns or creates a unique endpoint specific to the Amazon Web Services account making the call.
 *
 * The first time `DescribeEndpoint` is called, an endpoint is created. All subsequent calls to `DescribeEndpoint` return the same endpoint.
 *
 * Requires permission to access the [DescribeEndpoint](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeEndpoint(crossinline block: DescribeEndpointRequest.Builder.() -> Unit): DescribeEndpointResponse = describeEndpoint(DescribeEndpointRequest.Builder().apply(block).build())

/**
 * Describes event configurations.
 *
 * Requires permission to access the [DescribeEventConfigurations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeEventConfigurations(crossinline block: DescribeEventConfigurationsRequest.Builder.() -> Unit): DescribeEventConfigurationsResponse = describeEventConfigurations(DescribeEventConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets information about the specified fleet metric.
 *
 * Requires permission to access the [DescribeFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeFleetMetric(crossinline block: DescribeFleetMetricRequest.Builder.() -> Unit): DescribeFleetMetricResponse = describeFleetMetric(DescribeFleetMetricRequest.Builder().apply(block).build())

/**
 * Describes a search index.
 *
 * Requires permission to access the [DescribeIndex](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeIndex(crossinline block: DescribeIndexRequest.Builder.() -> Unit): DescribeIndexResponse = describeIndex(DescribeIndexRequest.Builder().apply(block).build())

/**
 * Describes a job.
 *
 * Requires permission to access the [DescribeJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeJob(crossinline block: DescribeJobRequest.Builder.() -> Unit): DescribeJobResponse = describeJob(DescribeJobRequest.Builder().apply(block).build())

/**
 * Describes a job execution.
 *
 * Requires permission to access the [DescribeJobExecution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeJobExecution(crossinline block: DescribeJobExecutionRequest.Builder.() -> Unit): DescribeJobExecutionResponse = describeJobExecution(DescribeJobExecutionRequest.Builder().apply(block).build())

/**
 * Returns information about a job template.
 */
public suspend inline fun IotClient.describeJobTemplate(crossinline block: DescribeJobTemplateRequest.Builder.() -> Unit): DescribeJobTemplateResponse = describeJobTemplate(DescribeJobTemplateRequest.Builder().apply(block).build())

/**
 * View details of a managed job template.
 */
public suspend inline fun IotClient.describeManagedJobTemplate(crossinline block: DescribeManagedJobTemplateRequest.Builder.() -> Unit): DescribeManagedJobTemplateResponse = describeManagedJobTemplate(DescribeManagedJobTemplateRequest.Builder().apply(block).build())

/**
 * Gets information about a mitigation action.
 *
 * Requires permission to access the [DescribeMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeMitigationAction(crossinline block: DescribeMitigationActionRequest.Builder.() -> Unit): DescribeMitigationActionResponse = describeMitigationAction(DescribeMitigationActionRequest.Builder().apply(block).build())

/**
 * Returns information about a provisioning template.
 *
 * Requires permission to access the [DescribeProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeProvisioningTemplate(crossinline block: DescribeProvisioningTemplateRequest.Builder.() -> Unit): DescribeProvisioningTemplateResponse = describeProvisioningTemplate(DescribeProvisioningTemplateRequest.Builder().apply(block).build())

/**
 * Returns information about a provisioning template version.
 *
 * Requires permission to access the [DescribeProvisioningTemplateVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeProvisioningTemplateVersion(crossinline block: DescribeProvisioningTemplateVersionRequest.Builder.() -> Unit): DescribeProvisioningTemplateVersionResponse = describeProvisioningTemplateVersion(DescribeProvisioningTemplateVersionRequest.Builder().apply(block).build())

/**
 * Describes a role alias.
 *
 * Requires permission to access the [DescribeRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeRoleAlias(crossinline block: DescribeRoleAliasRequest.Builder.() -> Unit): DescribeRoleAliasResponse = describeRoleAlias(DescribeRoleAliasRequest.Builder().apply(block).build())

/**
 * Gets information about a scheduled audit.
 *
 * Requires permission to access the [DescribeScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeScheduledAudit(crossinline block: DescribeScheduledAuditRequest.Builder.() -> Unit): DescribeScheduledAuditResponse = describeScheduledAudit(DescribeScheduledAuditRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Defender security profile.
 *
 * Requires permission to access the [DescribeSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeSecurityProfile(crossinline block: DescribeSecurityProfileRequest.Builder.() -> Unit): DescribeSecurityProfileResponse = describeSecurityProfile(DescribeSecurityProfileRequest.Builder().apply(block).build())

/**
 * Gets information about a stream.
 *
 * Requires permission to access the [DescribeStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeStream(crossinline block: DescribeStreamRequest.Builder.() -> Unit): DescribeStreamResponse = describeStream(DescribeStreamRequest.Builder().apply(block).build())

/**
 * Gets information about the specified thing.
 *
 * Requires permission to access the [DescribeThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeThing(crossinline block: DescribeThingRequest.Builder.() -> Unit): DescribeThingResponse = describeThing(DescribeThingRequest.Builder().apply(block).build())

/**
 * Describe a thing group.
 *
 * Requires permission to access the [DescribeThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeThingGroup(crossinline block: DescribeThingGroupRequest.Builder.() -> Unit): DescribeThingGroupResponse = describeThingGroup(DescribeThingGroupRequest.Builder().apply(block).build())

/**
 * Describes a bulk thing provisioning task.
 *
 * Requires permission to access the [DescribeThingRegistrationTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeThingRegistrationTask(crossinline block: DescribeThingRegistrationTaskRequest.Builder.() -> Unit): DescribeThingRegistrationTaskResponse = describeThingRegistrationTask(DescribeThingRegistrationTaskRequest.Builder().apply(block).build())

/**
 * Gets information about the specified thing type.
 *
 * Requires permission to access the [DescribeThingType](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.describeThingType(crossinline block: DescribeThingTypeRequest.Builder.() -> Unit): DescribeThingTypeResponse = describeThingType(DescribeThingTypeRequest.Builder().apply(block).build())

/**
 * Detaches a policy from the specified target.
 *
 * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.
 *
 * Requires permission to access the [DetachPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.detachPolicy(crossinline block: DetachPolicyRequest.Builder.() -> Unit): DetachPolicyResponse = detachPolicy(DetachPolicyRequest.Builder().apply(block).build())

/**
 * Removes the specified policy from the specified certificate.
 *
 * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use DetachPolicy instead.
 *
 * Requires permission to access the [DetachPrincipalPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IotClient.detachPrincipalPolicy(crossinline block: DetachPrincipalPolicyRequest.Builder.() -> Unit): DetachPrincipalPolicyResponse = detachPrincipalPolicy(DetachPrincipalPolicyRequest.Builder().apply(block).build())

/**
 * Disassociates a Device Defender security profile from a thing group or from this account.
 *
 * Requires permission to access the [DetachSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.detachSecurityProfile(crossinline block: DetachSecurityProfileRequest.Builder.() -> Unit): DetachSecurityProfileResponse = detachSecurityProfile(DetachSecurityProfileRequest.Builder().apply(block).build())

/**
 * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.
 *
 * This call is asynchronous. It might take several seconds for the detachment to propagate.
 *
 * Requires permission to access the [DetachThingPrincipal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.detachThingPrincipal(crossinline block: DetachThingPrincipalRequest.Builder.() -> Unit): DetachThingPrincipalResponse = detachThingPrincipal(DetachThingPrincipalRequest.Builder().apply(block).build())

/**
 * Disables the rule.
 *
 * Requires permission to access the [DisableTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.disableTopicRule(crossinline block: DisableTopicRuleRequest.Builder.() -> Unit): DisableTopicRuleResponse = disableTopicRule(DisableTopicRuleRequest.Builder().apply(block).build())

/**
 * Enables the rule.
 *
 * Requires permission to access the [EnableTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.enableTopicRule(crossinline block: EnableTopicRuleRequest.Builder.() -> Unit): EnableTopicRuleResponse = enableTopicRule(EnableTopicRuleRequest.Builder().apply(block).build())

/**
 * Returns a Device Defender's ML Detect Security Profile training model's status.
 *
 * Requires permission to access the [GetBehaviorModelTrainingSummaries](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getBehaviorModelTrainingSummaries(crossinline block: GetBehaviorModelTrainingSummariesRequest.Builder.() -> Unit): GetBehaviorModelTrainingSummariesResponse = getBehaviorModelTrainingSummaries(GetBehaviorModelTrainingSummariesRequest.Builder().apply(block).build())

/**
 * Aggregates on indexed data with search queries pertaining to particular fields.
 *
 * Requires permission to access the [GetBucketsAggregation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getBucketsAggregation(crossinline block: GetBucketsAggregationRequest.Builder.() -> Unit): GetBucketsAggregationResponse = getBucketsAggregation(GetBucketsAggregationRequest.Builder().apply(block).build())

/**
 * Returns the approximate count of unique values that match the query.
 *
 * Requires permission to access the [GetCardinality](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getCardinality(crossinline block: GetCardinalityRequest.Builder.() -> Unit): GetCardinalityResponse = getCardinality(GetCardinalityRequest.Builder().apply(block).build())

/**
 * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it connects to the IoT device gateway.
 *
 * Requires permission to access the [GetEffectivePolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getEffectivePolicies(crossinline block: GetEffectivePoliciesRequest.Builder.() -> Unit): GetEffectivePoliciesResponse = getEffectivePolicies(GetEffectivePoliciesRequest.Builder().apply(block).build())

/**
 * Gets the indexing configuration.
 *
 * Requires permission to access the [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getIndexingConfiguration(crossinline block: GetIndexingConfigurationRequest.Builder.() -> Unit): GetIndexingConfigurationResponse = getIndexingConfiguration(GetIndexingConfigurationRequest.Builder().apply(block).build())

/**
 * Gets a job document.
 *
 * Requires permission to access the [GetJobDocument](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getJobDocument(crossinline block: GetJobDocumentRequest.Builder.() -> Unit): GetJobDocumentResponse = getJobDocument(GetJobDocumentRequest.Builder().apply(block).build())

/**
 * Gets the logging options.
 *
 * NOTE: use of this command is not recommended. Use `GetV2LoggingOptions` instead.
 *
 * Requires permission to access the [GetLoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getLoggingOptions(crossinline block: GetLoggingOptionsRequest.Builder.() -> Unit): GetLoggingOptionsResponse = getLoggingOptions(GetLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Gets an OTA update.
 *
 * Requires permission to access the [GetOTAUpdate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getOtaUpdate(crossinline block: GetOtaUpdateRequest.Builder.() -> Unit): GetOtaUpdateResponse = getOtaUpdate(GetOtaUpdateRequest.Builder().apply(block).build())

/**
 * Gets information about the specified software package.
 *
 * Requires permission to access the [GetPackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getPackage(crossinline block: GetPackageRequest.Builder.() -> Unit): GetPackageResponse = getPackage(GetPackageRequest.Builder().apply(block).build())

/**
 * Gets information about the specified software package's configuration.
 *
 * Requires permission to access the [GetPackageConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getPackageConfiguration(crossinline block: GetPackageConfigurationRequest.Builder.() -> Unit): GetPackageConfigurationResponse = getPackageConfiguration(GetPackageConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about the specified package version.
 *
 * Requires permission to access the [GetPackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getPackageVersion(crossinline block: GetPackageVersionRequest.Builder.() -> Unit): GetPackageVersionResponse = getPackageVersion(GetPackageVersionRequest.Builder().apply(block).build())

/**
 * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own when you call `GetPercentiles`. This function returns a value for each percentile group specified (or the default percentile groupings). The percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately five percent of the values that match the query, and so on. The result is an approximation, the more values that match the query, the more accurate the percentile values.
 *
 * Requires permission to access the [GetPercentiles](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getPercentiles(crossinline block: GetPercentilesRequest.Builder.() -> Unit): GetPercentilesResponse = getPercentiles(GetPercentilesRequest.Builder().apply(block).build())

/**
 * Gets information about the specified policy with the policy document of the default version.
 *
 * Requires permission to access the [GetPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Gets information about the specified policy version.
 *
 * Requires permission to access the [GetPolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getPolicyVersion(crossinline block: GetPolicyVersionRequest.Builder.() -> Unit): GetPolicyVersionResponse = getPolicyVersion(GetPolicyVersionRequest.Builder().apply(block).build())

/**
 * Gets a registration code used to register a CA certificate with IoT.
 *
 * IoT will create a registration code as part of this API call if the registration code doesn't exist or has been deleted. If you already have a registration code, this API call will return the same registration code.
 *
 * Requires permission to access the [GetRegistrationCode](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getRegistrationCode(crossinline block: GetRegistrationCodeRequest.Builder.() -> Unit): GetRegistrationCodeResponse = getRegistrationCode(GetRegistrationCodeRequest.Builder().apply(block).build())

/**
 * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the specified aggregated field. If the aggregation field is of type `String`, only the count statistic is returned.
 *
 * Requires permission to access the [GetStatistics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getStatistics(crossinline block: GetStatisticsRequest.Builder.() -> Unit): GetStatisticsResponse = getStatistics(GetStatisticsRequest.Builder().apply(block).build())

/**
 * Gets information about the rule.
 *
 * Requires permission to access the [GetTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getTopicRule(crossinline block: GetTopicRuleRequest.Builder.() -> Unit): GetTopicRuleResponse = getTopicRule(GetTopicRuleRequest.Builder().apply(block).build())

/**
 * Gets information about a topic rule destination.
 *
 * Requires permission to access the [GetTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getTopicRuleDestination(crossinline block: GetTopicRuleDestinationRequest.Builder.() -> Unit): GetTopicRuleDestinationResponse = getTopicRuleDestination(GetTopicRuleDestinationRequest.Builder().apply(block).build())

/**
 * Gets the fine grained logging options.
 *
 * Requires permission to access the [GetV2LoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.getV2LoggingOptions(crossinline block: GetV2LoggingOptionsRequest.Builder.() -> Unit): GetV2LoggingOptionsResponse = getV2LoggingOptions(GetV2LoggingOptionsRequest.Builder().apply(block).build())

/**
 * Lists the active violations for a given Device Defender security profile.
 *
 * Requires permission to access the [ListActiveViolations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listActiveViolations(crossinline block: ListActiveViolationsRequest.Builder.() -> Unit): ListActiveViolationsResponse = listActiveViolations(ListActiveViolationsRequest.Builder().apply(block).build())

/**
 * Lists the policies attached to the specified thing group.
 *
 * Requires permission to access the [ListAttachedPolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAttachedPolicies(crossinline block: ListAttachedPoliciesRequest.Builder.() -> Unit): ListAttachedPoliciesResponse = listAttachedPolicies(ListAttachedPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time period. (Findings are retained for 90 days.)
 *
 * Requires permission to access the [ListAuditFindings](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAuditFindings(crossinline block: ListAuditFindingsRequest.Builder.() -> Unit): ListAuditFindingsResponse = listAuditFindings(ListAuditFindingsRequest.Builder().apply(block).build())

/**
 * Gets the status of audit mitigation action tasks that were executed.
 *
 * Requires permission to access the [ListAuditMitigationActionsExecutions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAuditMitigationActionsExecutions(crossinline block: ListAuditMitigationActionsExecutionsRequest.Builder.() -> Unit): ListAuditMitigationActionsExecutionsResponse = listAuditMitigationActionsExecutions(ListAuditMitigationActionsExecutionsRequest.Builder().apply(block).build())

/**
 * Gets a list of audit mitigation action tasks that match the specified filters.
 *
 * Requires permission to access the [ListAuditMitigationActionsTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAuditMitigationActionsTasks(crossinline block: ListAuditMitigationActionsTasksRequest.Builder.() -> Unit): ListAuditMitigationActionsTasksResponse = listAuditMitigationActionsTasks(ListAuditMitigationActionsTasksRequest.Builder().apply(block).build())

/**
 * Lists your Device Defender audit listings.
 *
 * Requires permission to access the [ListAuditSuppressions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAuditSuppressions(crossinline block: ListAuditSuppressionsRequest.Builder.() -> Unit): ListAuditSuppressionsResponse = listAuditSuppressions(ListAuditSuppressionsRequest.Builder().apply(block).build())

/**
 * Lists the Device Defender audits that have been performed during a given time period.
 *
 * Requires permission to access the [ListAuditTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAuditTasks(crossinline block: ListAuditTasksRequest.Builder.() -> Unit): ListAuditTasksResponse = listAuditTasks(ListAuditTasksRequest.Builder().apply(block).build())

/**
 * Lists the authorizers registered in your account.
 *
 * Requires permission to access the [ListAuthorizers](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listAuthorizers(crossinline block: ListAuthorizersRequest.Builder.() -> Unit): ListAuthorizersResponse = listAuthorizers(ListAuthorizersRequest.Builder().apply(block).build())

/**
 * Lists the billing groups you have created.
 *
 * Requires permission to access the [ListBillingGroups](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listBillingGroups(crossinline block: ListBillingGroupsRequest.Builder.() -> Unit): ListBillingGroupsResponse = listBillingGroups(ListBillingGroupsRequest.Builder().apply(block).build())

/**
 * Lists the CA certificates registered for your Amazon Web Services account.
 *
 * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.
 *
 * Requires permission to access the [ListCACertificates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listCaCertificates(crossinline block: ListCaCertificatesRequest.Builder.() -> Unit): ListCaCertificatesResponse = listCaCertificates(ListCaCertificatesRequest.Builder().apply(block).build())

/**
 * Lists all your certificate providers in your Amazon Web Services account.
 *
 * Requires permission to access the [ListCertificateProviders](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listCertificateProviders(crossinline block: ListCertificateProvidersRequest.Builder.() -> Unit): ListCertificateProvidersResponse = listCertificateProviders(ListCertificateProvidersRequest.Builder().apply(block).build())

/**
 * Lists the certificates registered in your Amazon Web Services account.
 *
 * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.
 *
 * Requires permission to access the [ListCertificates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listCertificates(crossinline block: ListCertificatesRequest.Builder.() -> Unit): ListCertificatesResponse = listCertificates(ListCertificatesRequest.Builder().apply(block).build())

/**
 * List the device certificates signed by the specified CA certificate.
 *
 * Requires permission to access the [ListCertificatesByCA](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listCertificatesByCa(crossinline block: ListCertificatesByCaRequest.Builder.() -> Unit): ListCertificatesByCaResponse = listCertificatesByCa(ListCertificatesByCaRequest.Builder().apply(block).build())

/**
 * Lists your Device Defender detect custom metrics.
 *
 * Requires permission to access the [ListCustomMetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listCustomMetrics(crossinline block: ListCustomMetricsRequest.Builder.() -> Unit): ListCustomMetricsResponse = listCustomMetrics(ListCustomMetricsRequest.Builder().apply(block).build())

/**
 * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
 *
 * Requires permission to access the [ListDetectMitigationActionsExecutions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listDetectMitigationActionsExecutions(crossinline block: ListDetectMitigationActionsExecutionsRequest.Builder.() -> Unit): ListDetectMitigationActionsExecutionsResponse = listDetectMitigationActionsExecutions(ListDetectMitigationActionsExecutionsRequest.Builder().apply(block).build())

/**
 * List of Device Defender ML Detect mitigation actions tasks.
 *
 * Requires permission to access the [ListDetectMitigationActionsTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listDetectMitigationActionsTasks(crossinline block: ListDetectMitigationActionsTasksRequest.Builder.() -> Unit): ListDetectMitigationActionsTasksResponse = listDetectMitigationActionsTasks(ListDetectMitigationActionsTasksRequest.Builder().apply(block).build())

/**
 * List the set of dimensions that are defined for your Amazon Web Services accounts.
 *
 * Requires permission to access the [ListDimensions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listDimensions(crossinline block: ListDimensionsRequest.Builder.() -> Unit): ListDimensionsResponse = listDimensions(ListDimensionsRequest.Builder().apply(block).build())

/**
 * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration name.
 *
 * Requires permission to access the [ListDomainConfigurations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listDomainConfigurations(crossinline block: ListDomainConfigurationsRequest.Builder.() -> Unit): ListDomainConfigurationsResponse = listDomainConfigurations(ListDomainConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists all your fleet metrics.
 *
 * Requires permission to access the [ListFleetMetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listFleetMetrics(crossinline block: ListFleetMetricsRequest.Builder.() -> Unit): ListFleetMetricsResponse = listFleetMetrics(ListFleetMetricsRequest.Builder().apply(block).build())

/**
 * Lists the search indices.
 *
 * Requires permission to access the [ListIndices](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listIndices(crossinline block: ListIndicesRequest.Builder.() -> Unit): ListIndicesResponse = listIndices(ListIndicesRequest.Builder().apply(block).build())

/**
 * Lists the job executions for a job.
 *
 * Requires permission to access the [ListJobExecutionsForJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listJobExecutionsForJob(crossinline block: ListJobExecutionsForJobRequest.Builder.() -> Unit): ListJobExecutionsForJobResponse = listJobExecutionsForJob(ListJobExecutionsForJobRequest.Builder().apply(block).build())

/**
 * Lists the job executions for the specified thing.
 *
 * Requires permission to access the [ListJobExecutionsForThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listJobExecutionsForThing(crossinline block: ListJobExecutionsForThingRequest.Builder.() -> Unit): ListJobExecutionsForThingResponse = listJobExecutionsForThing(ListJobExecutionsForThingRequest.Builder().apply(block).build())

/**
 * Returns a list of job templates.
 *
 * Requires permission to access the [ListJobTemplates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listJobTemplates(crossinline block: ListJobTemplatesRequest.Builder.() -> Unit): ListJobTemplatesResponse = listJobTemplates(ListJobTemplatesRequest.Builder().apply(block).build())

/**
 * Lists jobs.
 *
 * Requires permission to access the [ListJobs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of managed job templates.
 */
public suspend inline fun IotClient.listManagedJobTemplates(crossinline block: ListManagedJobTemplatesRequest.Builder.() -> Unit): ListManagedJobTemplatesResponse = listManagedJobTemplates(ListManagedJobTemplatesRequest.Builder().apply(block).build())

/**
 * Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side metric, or custom metric) by the given thing during the specified time period.
 */
public suspend inline fun IotClient.listMetricValues(crossinline block: ListMetricValuesRequest.Builder.() -> Unit): ListMetricValuesResponse = listMetricValues(ListMetricValuesRequest.Builder().apply(block).build())

/**
 * Gets a list of all mitigation actions that match the specified filter criteria.
 *
 * Requires permission to access the [ListMitigationActions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listMitigationActions(crossinline block: ListMitigationActionsRequest.Builder.() -> Unit): ListMitigationActionsResponse = listMitigationActions(ListMitigationActionsRequest.Builder().apply(block).build())

/**
 * Lists OTA updates.
 *
 * Requires permission to access the [ListOTAUpdates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listOtaUpdates(crossinline block: ListOtaUpdatesRequest.Builder.() -> Unit): ListOtaUpdatesResponse = listOtaUpdates(ListOtaUpdatesRequest.Builder().apply(block).build())

/**
 * Lists certificates that are being transferred but not yet accepted.
 *
 * Requires permission to access the [ListOutgoingCertificates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listOutgoingCertificates(crossinline block: ListOutgoingCertificatesRequest.Builder.() -> Unit): ListOutgoingCertificatesResponse = listOutgoingCertificates(ListOutgoingCertificatesRequest.Builder().apply(block).build())

/**
 * Lists the software package versions associated to the account.
 *
 * Requires permission to access the [ListPackageVersions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listPackageVersions(crossinline block: ListPackageVersionsRequest.Builder.() -> Unit): ListPackageVersionsResponse = listPackageVersions(ListPackageVersionsRequest.Builder().apply(block).build())

/**
 * Lists the software packages associated to the account.
 *
 * Requires permission to access the [ListPackages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listPackages(crossinline block: ListPackagesRequest.Builder.() -> Unit): ListPackagesResponse = listPackages(ListPackagesRequest.Builder().apply(block).build())

/**
 * Lists your policies.
 *
 * Requires permission to access the [ListPolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listPolicies(crossinline block: ListPoliciesRequest.Builder.() -> Unit): ListPoliciesResponse = listPolicies(ListPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the principals associated with the specified policy.
 *
 * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use ListTargetsForPolicy instead.
 *
 * Requires permission to access the [ListPolicyPrincipals](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IotClient.listPolicyPrincipals(crossinline block: ListPolicyPrincipalsRequest.Builder.() -> Unit): ListPolicyPrincipalsResponse = listPolicyPrincipals(ListPolicyPrincipalsRequest.Builder().apply(block).build())

/**
 * Lists the versions of the specified policy and identifies the default version.
 *
 * Requires permission to access the [ListPolicyVersions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listPolicyVersions(crossinline block: ListPolicyVersionsRequest.Builder.() -> Unit): ListPolicyVersionsResponse = listPolicyVersions(ListPolicyVersionsRequest.Builder().apply(block).build())

/**
 * Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in [AmazonCognito Identity format](https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax).
 *
 * **Note:** This action is deprecated and works as expected for backward compatibility, but we won't add enhancements. Use ListAttachedPolicies instead.
 *
 * Requires permission to access the [ListPrincipalPolicies](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IotClient.listPrincipalPolicies(crossinline block: ListPrincipalPoliciesRequest.Builder.() -> Unit): ListPrincipalPoliciesResponse = listPrincipalPolicies(ListPrincipalPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.
 *
 * Requires permission to access the [ListPrincipalThings](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listPrincipalThings(crossinline block: ListPrincipalThingsRequest.Builder.() -> Unit): ListPrincipalThingsResponse = listPrincipalThings(ListPrincipalThingsRequest.Builder().apply(block).build())

/**
 * A list of provisioning template versions.
 *
 * Requires permission to access the [ListProvisioningTemplateVersions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listProvisioningTemplateVersions(crossinline block: ListProvisioningTemplateVersionsRequest.Builder.() -> Unit): ListProvisioningTemplateVersionsResponse = listProvisioningTemplateVersions(ListProvisioningTemplateVersionsRequest.Builder().apply(block).build())

/**
 * Lists the provisioning templates in your Amazon Web Services account.
 *
 * Requires permission to access the [ListProvisioningTemplates](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listProvisioningTemplates(crossinline block: ListProvisioningTemplatesRequest.Builder.() -> Unit): ListProvisioningTemplatesResponse = listProvisioningTemplates(ListProvisioningTemplatesRequest.Builder().apply(block).build())

/**
 * The related resources of an Audit finding. The following resources can be returned from calling this API:
 * + DEVICE_CERTIFICATE
 * + CA_CERTIFICATE
 * + IOT_POLICY
 * + COGNITO_IDENTITY_POOL
 * + CLIENT_ID
 * + ACCOUNT_SETTINGS
 * + ROLE_ALIAS
 * + IAM_ROLE
 * + ISSUER_CERTIFICATE
 *
 * This API is similar to DescribeAuditFinding's [RelatedResources](https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html) but provides pagination and is not limited to 10 resources. When calling [DescribeAuditFinding](https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html) for the intermediate CA revoked for active device certificates check, RelatedResources will not be populated. You must use this API, ListRelatedResourcesForAuditFinding, to list the certificates.
 */
public suspend inline fun IotClient.listRelatedResourcesForAuditFinding(crossinline block: ListRelatedResourcesForAuditFindingRequest.Builder.() -> Unit): ListRelatedResourcesForAuditFindingResponse = listRelatedResourcesForAuditFinding(ListRelatedResourcesForAuditFindingRequest.Builder().apply(block).build())

/**
 * Lists the role aliases registered in your account.
 *
 * Requires permission to access the [ListRoleAliases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listRoleAliases(crossinline block: ListRoleAliasesRequest.Builder.() -> Unit): ListRoleAliasesResponse = listRoleAliases(ListRoleAliasesRequest.Builder().apply(block).build())

/**
 * Lists all of your scheduled audits.
 *
 * Requires permission to access the [ListScheduledAudits](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listScheduledAudits(crossinline block: ListScheduledAuditsRequest.Builder.() -> Unit): ListScheduledAuditsResponse = listScheduledAudits(ListScheduledAuditsRequest.Builder().apply(block).build())

/**
 * Lists the Device Defender security profiles you've created. You can filter security profiles by dimension or custom metric.
 *
 * Requires permission to access the [ListSecurityProfiles](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * `dimensionName` and `metricName` cannot be used in the same request.
 */
public suspend inline fun IotClient.listSecurityProfiles(crossinline block: ListSecurityProfilesRequest.Builder.() -> Unit): ListSecurityProfilesResponse = listSecurityProfiles(ListSecurityProfilesRequest.Builder().apply(block).build())

/**
 * Lists the Device Defender security profiles attached to a target (thing group).
 *
 * Requires permission to access the [ListSecurityProfilesForTarget](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listSecurityProfilesForTarget(crossinline block: ListSecurityProfilesForTargetRequest.Builder.() -> Unit): ListSecurityProfilesForTargetResponse = listSecurityProfilesForTarget(ListSecurityProfilesForTargetRequest.Builder().apply(block).build())

/**
 * Lists all of the streams in your Amazon Web Services account.
 *
 * Requires permission to access the [ListStreams](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listStreams(crossinline block: ListStreamsRequest.Builder.() -> Unit): ListStreamsResponse = listStreams(ListStreamsRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) you have assigned to the resource.
 *
 * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List targets for the specified policy.
 *
 * Requires permission to access the [ListTargetsForPolicy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listTargetsForPolicy(crossinline block: ListTargetsForPolicyRequest.Builder.() -> Unit): ListTargetsForPolicyResponse = listTargetsForPolicy(ListTargetsForPolicyRequest.Builder().apply(block).build())

/**
 * Lists the targets (thing groups) associated with a given Device Defender security profile.
 *
 * Requires permission to access the [ListTargetsForSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listTargetsForSecurityProfile(crossinline block: ListTargetsForSecurityProfileRequest.Builder.() -> Unit): ListTargetsForSecurityProfileResponse = listTargetsForSecurityProfile(ListTargetsForSecurityProfileRequest.Builder().apply(block).build())

/**
 * List the thing groups in your account.
 *
 * Requires permission to access the [ListThingGroups](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingGroups(crossinline block: ListThingGroupsRequest.Builder.() -> Unit): ListThingGroupsResponse = listThingGroups(ListThingGroupsRequest.Builder().apply(block).build())

/**
 * List the thing groups to which the specified thing belongs.
 *
 * Requires permission to access the [ListThingGroupsForThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingGroupsForThing(crossinline block: ListThingGroupsForThingRequest.Builder.() -> Unit): ListThingGroupsForThingResponse = listThingGroupsForThing(ListThingGroupsForThingRequest.Builder().apply(block).build())

/**
 * Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.
 *
 * Requires permission to access the [ListThingPrincipals](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingPrincipals(crossinline block: ListThingPrincipalsRequest.Builder.() -> Unit): ListThingPrincipalsResponse = listThingPrincipals(ListThingPrincipalsRequest.Builder().apply(block).build())

/**
 * Information about the thing registration tasks.
 */
public suspend inline fun IotClient.listThingRegistrationTaskReports(crossinline block: ListThingRegistrationTaskReportsRequest.Builder.() -> Unit): ListThingRegistrationTaskReportsResponse = listThingRegistrationTaskReports(ListThingRegistrationTaskReportsRequest.Builder().apply(block).build())

/**
 * List bulk thing provisioning tasks.
 *
 * Requires permission to access the [ListThingRegistrationTasks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingRegistrationTasks(crossinline block: ListThingRegistrationTasksRequest.Builder.() -> Unit): ListThingRegistrationTasksResponse = listThingRegistrationTasks(ListThingRegistrationTasksRequest.Builder().apply(block).build())

/**
 * Lists the existing thing types.
 *
 * Requires permission to access the [ListThingTypes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingTypes(crossinline block: ListThingTypesRequest.Builder.() -> Unit): ListThingTypesResponse = listThingTypes(ListThingTypesRequest.Builder().apply(block).build())

/**
 * Lists your things. Use the **attributeName** and **attributeValue** parameters to filter your things. For example, calling `ListThings` with attributeName=Color and attributeValue=Red retrieves all things in the registry that contain an attribute **Color** with the value **Red**. For more information, see [List Things](https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html#list-things) from the *Amazon Web Services IoT Core Developer Guide*.
 *
 * Requires permission to access the [ListThings](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * You will not be charged for calling this API if an `Access denied` error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.
 */
public suspend inline fun IotClient.listThings(crossinline block: ListThingsRequest.Builder.() -> Unit): ListThingsResponse = listThings(ListThingsRequest.Builder().apply(block).build())

/**
 * Lists the things you have added to the given billing group.
 *
 * Requires permission to access the [ListThingsInBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingsInBillingGroup(crossinline block: ListThingsInBillingGroupRequest.Builder.() -> Unit): ListThingsInBillingGroupResponse = listThingsInBillingGroup(ListThingsInBillingGroupRequest.Builder().apply(block).build())

/**
 * Lists the things in the specified group.
 *
 * Requires permission to access the [ListThingsInThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listThingsInThingGroup(crossinline block: ListThingsInThingGroupRequest.Builder.() -> Unit): ListThingsInThingGroupResponse = listThingsInThingGroup(ListThingsInThingGroupRequest.Builder().apply(block).build())

/**
 * Lists all the topic rule destinations in your Amazon Web Services account.
 *
 * Requires permission to access the [ListTopicRuleDestinations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listTopicRuleDestinations(crossinline block: ListTopicRuleDestinationsRequest.Builder.() -> Unit): ListTopicRuleDestinationsResponse = listTopicRuleDestinations(ListTopicRuleDestinationsRequest.Builder().apply(block).build())

/**
 * Lists the rules for the specific topic.
 *
 * Requires permission to access the [ListTopicRules](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listTopicRules(crossinline block: ListTopicRulesRequest.Builder.() -> Unit): ListTopicRulesResponse = listTopicRules(ListTopicRulesRequest.Builder().apply(block).build())

/**
 * Lists logging levels.
 *
 * Requires permission to access the [ListV2LoggingLevels](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listV2LoggingLevels(crossinline block: ListV2LoggingLevelsRequest.Builder.() -> Unit): ListV2LoggingLevelsResponse = listV2LoggingLevels(ListV2LoggingLevelsRequest.Builder().apply(block).build())

/**
 * Lists the Device Defender security profile violations discovered during the given time period. You can use filters to limit the results to those alerts issued for a particular security profile, behavior, or thing (device).
 *
 * Requires permission to access the [ListViolationEvents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.listViolationEvents(crossinline block: ListViolationEventsRequest.Builder.() -> Unit): ListViolationEventsResponse = listViolationEvents(ListViolationEventsRequest.Builder().apply(block).build())

/**
 * Set a verification state and provide a description of that verification state on a violation (detect alarm).
 */
public suspend inline fun IotClient.putVerificationStateOnViolation(crossinline block: PutVerificationStateOnViolationRequest.Builder.() -> Unit): PutVerificationStateOnViolationResponse = putVerificationStateOnViolation(PutVerificationStateOnViolationRequest.Builder().apply(block).build())

/**
 * Registers a CA certificate with Amazon Web Services IoT Core. There is no limit to the number of CA certificates you can register in your Amazon Web Services account. You can register up to 10 CA certificates with the same `CA subject field` per Amazon Web Services account.
 *
 * Requires permission to access the [RegisterCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.registerCaCertificate(crossinline block: RegisterCaCertificateRequest.Builder.() -> Unit): RegisterCaCertificateResponse = registerCaCertificate(RegisterCaCertificateRequest.Builder().apply(block).build())

/**
 * Registers a device certificate with IoT in the same [certificate mode](https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode) as the signing CA. If you have more than one CA certificate that has the same subject field, you must specify the CA certificate that was used to sign the device certificate being registered.
 *
 * Requires permission to access the [RegisterCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.registerCertificate(crossinline block: RegisterCertificateRequest.Builder.() -> Unit): RegisterCertificateResponse = registerCertificate(RegisterCertificateRequest.Builder().apply(block).build())

/**
 * Register a certificate that does not have a certificate authority (CA). For supported certificates, consult [ Certificate signing algorithms supported by IoT](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms).
 */
public suspend inline fun IotClient.registerCertificateWithoutCa(crossinline block: RegisterCertificateWithoutCaRequest.Builder.() -> Unit): RegisterCertificateWithoutCaResponse = registerCertificateWithoutCa(RegisterCertificateWithoutCaRequest.Builder().apply(block).build())

/**
 * Provisions a thing in the device registry. RegisterThing calls other IoT control plane APIs. These calls might exceed your account level [ IoT Throttling Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot) and cause throttle errors. Please contact [Amazon Web Services Customer Support](https://console.aws.amazon.com/support/home) to raise your throttling limits if necessary.
 *
 * Requires permission to access the [RegisterThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.registerThing(crossinline block: RegisterThingRequest.Builder.() -> Unit): RegisterThingResponse = registerThing(RegisterThingRequest.Builder().apply(block).build())

/**
 * Rejects a pending certificate transfer. After IoT rejects a certificate transfer, the certificate status changes from **PENDING_TRANSFER** to **INACTIVE**.
 *
 * To check for pending certificate transfers, call ListCertificates to enumerate your certificates.
 *
 * This operation can only be called by the transfer destination. After it is called, the certificate will be returned to the source's account in the INACTIVE state.
 *
 * Requires permission to access the [RejectCertificateTransfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.rejectCertificateTransfer(crossinline block: RejectCertificateTransferRequest.Builder.() -> Unit): RejectCertificateTransferResponse = rejectCertificateTransfer(RejectCertificateTransferRequest.Builder().apply(block).build())

/**
 * Removes the given thing from the billing group.
 *
 * Requires permission to access the [RemoveThingFromBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * This call is asynchronous. It might take several seconds for the detachment to propagate.
 */
public suspend inline fun IotClient.removeThingFromBillingGroup(crossinline block: RemoveThingFromBillingGroupRequest.Builder.() -> Unit): RemoveThingFromBillingGroupResponse = removeThingFromBillingGroup(RemoveThingFromBillingGroupRequest.Builder().apply(block).build())

/**
 * Remove the specified thing from the specified group.
 *
 * You must specify either a `thingGroupArn` or a `thingGroupName` to identify the thing group and either a `thingArn` or a `thingName` to identify the thing to remove from the thing group.
 *
 * Requires permission to access the [RemoveThingFromThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.removeThingFromThingGroup(crossinline block: RemoveThingFromThingGroupRequest.Builder.() -> Unit): RemoveThingFromThingGroupResponse = removeThingFromThingGroup(RemoveThingFromThingGroupRequest.Builder().apply(block).build())

/**
 * Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.
 *
 * Requires permission to access the [ReplaceTopicRule](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.replaceTopicRule(crossinline block: ReplaceTopicRuleRequest.Builder.() -> Unit): ReplaceTopicRuleResponse = replaceTopicRule(ReplaceTopicRuleRequest.Builder().apply(block).build())

/**
 * The query search index.
 *
 * Requires permission to access the [SearchIndex](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.searchIndex(crossinline block: SearchIndexRequest.Builder.() -> Unit): SearchIndexResponse = searchIndex(SearchIndexRequest.Builder().apply(block).build())

/**
 * Sets the default authorizer. This will be used if a websocket connection is made without specifying an authorizer.
 *
 * Requires permission to access the [SetDefaultAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.setDefaultAuthorizer(crossinline block: SetDefaultAuthorizerRequest.Builder.() -> Unit): SetDefaultAuthorizerResponse = setDefaultAuthorizer(SetDefaultAuthorizerRequest.Builder().apply(block).build())

/**
 * Sets the specified version of the specified policy as the policy's default (operative) version. This action affects all certificates to which the policy is attached. To list the principals the policy is attached to, use the ListPrincipalPolicies action.
 *
 * Requires permission to access the [SetDefaultPolicyVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.setDefaultPolicyVersion(crossinline block: SetDefaultPolicyVersionRequest.Builder.() -> Unit): SetDefaultPolicyVersionResponse = setDefaultPolicyVersion(SetDefaultPolicyVersionRequest.Builder().apply(block).build())

/**
 * Sets the logging options.
 *
 * NOTE: use of this command is not recommended. Use `SetV2LoggingOptions` instead.
 *
 * Requires permission to access the [SetLoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.setLoggingOptions(crossinline block: SetLoggingOptionsRequest.Builder.() -> Unit): SetLoggingOptionsResponse = setLoggingOptions(SetLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Sets the logging level.
 *
 * Requires permission to access the [SetV2LoggingLevel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.setV2LoggingLevel(crossinline block: SetV2LoggingLevelRequest.Builder.() -> Unit): SetV2LoggingLevelResponse = setV2LoggingLevel(SetV2LoggingLevelRequest.Builder().apply(block).build())

/**
 * Sets the logging options for the V2 logging service.
 *
 * Requires permission to access the [SetV2LoggingOptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.setV2LoggingOptions(crossinline block: SetV2LoggingOptionsRequest.Builder.() -> Unit): SetV2LoggingOptionsResponse = setV2LoggingOptions(SetV2LoggingOptionsRequest.Builder().apply(block).build())

/**
 * Starts a task that applies a set of mitigation actions to the specified target.
 *
 * Requires permission to access the [StartAuditMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.startAuditMitigationActionsTask(crossinline block: StartAuditMitigationActionsTaskRequest.Builder.() -> Unit): StartAuditMitigationActionsTaskResponse = startAuditMitigationActionsTask(StartAuditMitigationActionsTaskRequest.Builder().apply(block).build())

/**
 * Starts a Device Defender ML Detect mitigation actions task.
 *
 * Requires permission to access the [StartDetectMitigationActionsTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.startDetectMitigationActionsTask(crossinline block: StartDetectMitigationActionsTaskRequest.Builder.() -> Unit): StartDetectMitigationActionsTaskResponse = startDetectMitigationActionsTask(StartDetectMitigationActionsTaskRequest.Builder().apply(block).build())

/**
 * Starts an on-demand Device Defender audit.
 *
 * Requires permission to access the [StartOnDemandAuditTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.startOnDemandAuditTask(crossinline block: StartOnDemandAuditTaskRequest.Builder.() -> Unit): StartOnDemandAuditTaskResponse = startOnDemandAuditTask(StartOnDemandAuditTaskRequest.Builder().apply(block).build())

/**
 * Creates a bulk thing provisioning task.
 *
 * Requires permission to access the [StartThingRegistrationTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.startThingRegistrationTask(crossinline block: StartThingRegistrationTaskRequest.Builder.() -> Unit): StartThingRegistrationTaskResponse = startThingRegistrationTask(StartThingRegistrationTaskRequest.Builder().apply(block).build())

/**
 * Cancels a bulk thing provisioning task.
 *
 * Requires permission to access the [StopThingRegistrationTask](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.stopThingRegistrationTask(crossinline block: StopThingRegistrationTaskRequest.Builder.() -> Unit): StopThingRegistrationTaskResponse = stopThingRegistrationTask(StopThingRegistrationTaskRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
 *
 * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests if a specified principal is authorized to perform an IoT action on a specified resource. Use this to test and debug the authorization behavior of devices that connect to the IoT device gateway.
 *
 * Requires permission to access the [TestAuthorization](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.testAuthorization(crossinline block: TestAuthorizationRequest.Builder.() -> Unit): TestAuthorizationResponse = testAuthorization(TestAuthorizationRequest.Builder().apply(block).build())

/**
 * Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the custom authorization behavior of devices that connect to the IoT device gateway.
 *
 * Requires permission to access the [TestInvokeAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.testInvokeAuthorizer(crossinline block: TestInvokeAuthorizerRequest.Builder.() -> Unit): TestInvokeAuthorizerResponse = testInvokeAuthorizer(TestInvokeAuthorizerRequest.Builder().apply(block).build())

/**
 * Transfers the specified certificate to the specified Amazon Web Services account.
 *
 * Requires permission to access the [TransferCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * You can cancel the transfer until it is acknowledged by the recipient.
 *
 * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer target.
 *
 * The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate action to deactivate it.
 *
 * The certificate must not have any policies attached to it. You can use the DetachPolicy action to detach them.
 */
public suspend inline fun IotClient.transferCertificate(crossinline block: TransferCertificateRequest.Builder.() -> Unit): TransferCertificateResponse = transferCertificate(TransferCertificateRequest.Builder().apply(block).build())

/**
 * Removes the given tags (metadata) from the resource.
 *
 * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.
 *
 * Requires permission to access the [UpdateAccountAuditConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateAccountAuditConfiguration(crossinline block: UpdateAccountAuditConfigurationRequest.Builder.() -> Unit): UpdateAccountAuditConfigurationResponse = updateAccountAuditConfiguration(UpdateAccountAuditConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a Device Defender audit suppression.
 */
public suspend inline fun IotClient.updateAuditSuppression(crossinline block: UpdateAuditSuppressionRequest.Builder.() -> Unit): UpdateAuditSuppressionResponse = updateAuditSuppression(UpdateAuditSuppressionRequest.Builder().apply(block).build())

/**
 * Updates an authorizer.
 *
 * Requires permission to access the [UpdateAuthorizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateAuthorizer(crossinline block: UpdateAuthorizerRequest.Builder.() -> Unit): UpdateAuthorizerResponse = updateAuthorizer(UpdateAuthorizerRequest.Builder().apply(block).build())

/**
 * Updates information about the billing group.
 *
 * Requires permission to access the [UpdateBillingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateBillingGroup(crossinline block: UpdateBillingGroupRequest.Builder.() -> Unit): UpdateBillingGroupResponse = updateBillingGroup(UpdateBillingGroupRequest.Builder().apply(block).build())

/**
 * Updates a registered CA certificate.
 *
 * Requires permission to access the [UpdateCACertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateCaCertificate(crossinline block: UpdateCaCertificateRequest.Builder.() -> Unit): UpdateCaCertificateResponse = updateCaCertificate(UpdateCaCertificateRequest.Builder().apply(block).build())

/**
 * Updates the status of the specified certificate. This operation is idempotent.
 *
 * Requires permission to access the [UpdateCertificate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * Certificates must be in the ACTIVE state to authenticate devices that use a certificate to connect to IoT.
 *
 * Within a few minutes of updating a certificate from the ACTIVE state to any other state, IoT disconnects all devices that used that certificate to connect. Devices cannot use a certificate that is not in the ACTIVE state to reconnect.
 */
public suspend inline fun IotClient.updateCertificate(crossinline block: UpdateCertificateRequest.Builder.() -> Unit): UpdateCertificateResponse = updateCertificate(UpdateCertificateRequest.Builder().apply(block).build())

/**
 * Updates a certificate provider.
 *
 * Requires permission to access the [UpdateCertificateProvider](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateCertificateProvider(crossinline block: UpdateCertificateProviderRequest.Builder.() -> Unit): UpdateCertificateProviderResponse = updateCertificateProvider(UpdateCertificateProviderRequest.Builder().apply(block).build())

/**
 * Updates a Device Defender detect custom metric.
 *
 * Requires permission to access the [UpdateCustomMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateCustomMetric(crossinline block: UpdateCustomMetricRequest.Builder.() -> Unit): UpdateCustomMetricResponse = updateCustomMetric(UpdateCustomMetricRequest.Builder().apply(block).build())

/**
 * Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can delete it and recreate it).
 *
 * Requires permission to access the [UpdateDimension](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateDimension(crossinline block: UpdateDimensionRequest.Builder.() -> Unit): UpdateDimensionResponse = updateDimension(UpdateDimensionRequest.Builder().apply(block).build())

/**
 * Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.
 *
 * Requires permission to access the [UpdateDomainConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateDomainConfiguration(crossinline block: UpdateDomainConfigurationRequest.Builder.() -> Unit): UpdateDomainConfigurationResponse = updateDomainConfiguration(UpdateDomainConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a dynamic thing group.
 *
 * Requires permission to access the [UpdateDynamicThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateDynamicThingGroup(crossinline block: UpdateDynamicThingGroupRequest.Builder.() -> Unit): UpdateDynamicThingGroupResponse = updateDynamicThingGroup(UpdateDynamicThingGroupRequest.Builder().apply(block).build())

/**
 * Updates the event configurations.
 *
 * Requires permission to access the [UpdateEventConfigurations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateEventConfigurations(crossinline block: UpdateEventConfigurationsRequest.Builder.() -> Unit): UpdateEventConfigurationsResponse = updateEventConfigurations(UpdateEventConfigurationsRequest.Builder().apply(block).build())

/**
 * Updates the data for a fleet metric.
 *
 * Requires permission to access the [UpdateFleetMetric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateFleetMetric(crossinline block: UpdateFleetMetricRequest.Builder.() -> Unit): UpdateFleetMetricResponse = updateFleetMetric(UpdateFleetMetricRequest.Builder().apply(block).build())

/**
 * Updates the search configuration.
 *
 * Requires permission to access the [UpdateIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateIndexingConfiguration(crossinline block: UpdateIndexingConfigurationRequest.Builder.() -> Unit): UpdateIndexingConfigurationResponse = updateIndexingConfiguration(UpdateIndexingConfigurationRequest.Builder().apply(block).build())

/**
 * Updates supported fields of the specified job.
 *
 * Requires permission to access the [UpdateJob](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateJob(crossinline block: UpdateJobRequest.Builder.() -> Unit): UpdateJobResponse = updateJob(UpdateJobRequest.Builder().apply(block).build())

/**
 * Updates the definition for the specified mitigation action.
 *
 * Requires permission to access the [UpdateMitigationAction](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateMitigationAction(crossinline block: UpdateMitigationActionRequest.Builder.() -> Unit): UpdateMitigationActionResponse = updateMitigationAction(UpdateMitigationActionRequest.Builder().apply(block).build())

/**
 * Updates the supported fields for a specific software package.
 *
 * Requires permission to access the [UpdatePackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
 */
public suspend inline fun IotClient.updatePackage(crossinline block: UpdatePackageRequest.Builder.() -> Unit): UpdatePackageResponse = updatePackage(UpdatePackageRequest.Builder().apply(block).build())

/**
 * Updates the software package configuration.
 *
 * Requires permission to access the [UpdatePackageConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [iam:PassRole](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html) actions.
 */
public suspend inline fun IotClient.updatePackageConfiguration(crossinline block: UpdatePackageConfigurationRequest.Builder.() -> Unit): UpdatePackageConfigurationResponse = updatePackageConfiguration(UpdatePackageConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the supported fields for a specific package version.
 *
 * Requires permission to access the [UpdatePackageVersion](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) and [GetIndexingConfiguration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) actions.
 */
public suspend inline fun IotClient.updatePackageVersion(crossinline block: UpdatePackageVersionRequest.Builder.() -> Unit): UpdatePackageVersionResponse = updatePackageVersion(UpdatePackageVersionRequest.Builder().apply(block).build())

/**
 * Updates a provisioning template.
 *
 * Requires permission to access the [UpdateProvisioningTemplate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateProvisioningTemplate(crossinline block: UpdateProvisioningTemplateRequest.Builder.() -> Unit): UpdateProvisioningTemplateResponse = updateProvisioningTemplate(UpdateProvisioningTemplateRequest.Builder().apply(block).build())

/**
 * Updates a role alias.
 *
 * Requires permission to access the [UpdateRoleAlias](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateRoleAlias(crossinline block: UpdateRoleAliasRequest.Builder.() -> Unit): UpdateRoleAliasResponse = updateRoleAlias(UpdateRoleAliasRequest.Builder().apply(block).build())

/**
 * Updates a scheduled audit, including which checks are performed and how often the audit takes place.
 *
 * Requires permission to access the [UpdateScheduledAudit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateScheduledAudit(crossinline block: UpdateScheduledAuditRequest.Builder.() -> Unit): UpdateScheduledAuditResponse = updateScheduledAudit(UpdateScheduledAuditRequest.Builder().apply(block).build())

/**
 * Updates a Device Defender security profile.
 *
 * Requires permission to access the [UpdateSecurityProfile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateSecurityProfile(crossinline block: UpdateSecurityProfileRequest.Builder.() -> Unit): UpdateSecurityProfileResponse = updateSecurityProfile(UpdateSecurityProfileRequest.Builder().apply(block).build())

/**
 * Updates an existing stream. The stream version will be incremented by one.
 *
 * Requires permission to access the [UpdateStream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateStream(crossinline block: UpdateStreamRequest.Builder.() -> Unit): UpdateStreamResponse = updateStream(UpdateStreamRequest.Builder().apply(block).build())

/**
 * Updates the data for a thing.
 *
 * Requires permission to access the [UpdateThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateThing(crossinline block: UpdateThingRequest.Builder.() -> Unit): UpdateThingResponse = updateThing(UpdateThingRequest.Builder().apply(block).build())

/**
 * Update a thing group.
 *
 * Requires permission to access the [UpdateThingGroup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateThingGroup(crossinline block: UpdateThingGroupRequest.Builder.() -> Unit): UpdateThingGroupResponse = updateThingGroup(UpdateThingGroupRequest.Builder().apply(block).build())

/**
 * Updates the groups to which the thing belongs.
 *
 * Requires permission to access the [UpdateThingGroupsForThing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateThingGroupsForThing(crossinline block: UpdateThingGroupsForThingRequest.Builder.() -> Unit): UpdateThingGroupsForThingResponse = updateThingGroupsForThing(UpdateThingGroupsForThingRequest.Builder().apply(block).build())

/**
 * Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the destination.
 *
 * Requires permission to access the [UpdateTopicRuleDestination](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.updateTopicRuleDestination(crossinline block: UpdateTopicRuleDestinationRequest.Builder.() -> Unit): UpdateTopicRuleDestinationResponse = updateTopicRuleDestination(UpdateTopicRuleDestinationRequest.Builder().apply(block).build())

/**
 * Validates a Device Defender security profile behaviors specification.
 *
 * Requires permission to access the [ValidateSecurityProfileBehaviors](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotClient.validateSecurityProfileBehaviors(crossinline block: ValidateSecurityProfileBehaviorsRequest.Builder.() -> Unit): ValidateSecurityProfileBehaviorsResponse = validateSecurityProfileBehaviors(ValidateSecurityProfileBehaviorsRequest.Builder().apply(block).build())
