// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AuthorizerConfig
import aws.sdk.kotlin.services.iot.model.DescribeDomainConfigurationResponse
import aws.sdk.kotlin.services.iot.model.DomainConfigurationStatus
import aws.sdk.kotlin.services.iot.model.DomainType
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ServerCertificateSummary
import aws.sdk.kotlin.services.iot.model.ServiceType
import aws.sdk.kotlin.services.iot.model.TlsConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeDomainConfigurationOperationDeserializer: HttpDeserialize<DescribeDomainConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDomainConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDomainConfigurationError(context, call)
        }
        val builder = DescribeDomainConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDomainConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDomainConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDomainConfigurationOperationBody(builder: DescribeDomainConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHORIZERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorizerConfig"))
    val DOMAINCONFIGURATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainConfigurationArn"))
    val DOMAINCONFIGURATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainConfigurationName"))
    val DOMAINCONFIGURATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("domainConfigurationStatus"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainName"))
    val DOMAINTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("domainType"))
    val LASTSTATUSCHANGEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStatusChangeDate"))
    val SERVERCERTIFICATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("serverCertificates"))
    val SERVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("serviceType"))
    val TLSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZERCONFIG_DESCRIPTOR)
        field(DOMAINCONFIGURATIONARN_DESCRIPTOR)
        field(DOMAINCONFIGURATIONNAME_DESCRIPTOR)
        field(DOMAINCONFIGURATIONSTATUS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINTYPE_DESCRIPTOR)
        field(LASTSTATUSCHANGEDATE_DESCRIPTOR)
        field(SERVERCERTIFICATES_DESCRIPTOR)
        field(SERVICETYPE_DESCRIPTOR)
        field(TLSCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHORIZERCONFIG_DESCRIPTOR.index -> builder.authorizerConfig = deserializeAuthorizerConfigDocument(deserializer)
                DOMAINCONFIGURATIONARN_DESCRIPTOR.index -> builder.domainConfigurationArn = deserializeString()
                DOMAINCONFIGURATIONNAME_DESCRIPTOR.index -> builder.domainConfigurationName = deserializeString()
                DOMAINCONFIGURATIONSTATUS_DESCRIPTOR.index -> builder.domainConfigurationStatus = deserializeString().let { DomainConfigurationStatus.fromValue(it) }
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                DOMAINTYPE_DESCRIPTOR.index -> builder.domainType = deserializeString().let { DomainType.fromValue(it) }
                LASTSTATUSCHANGEDATE_DESCRIPTOR.index -> builder.lastStatusChangeDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                SERVERCERTIFICATES_DESCRIPTOR.index -> builder.serverCertificates =
                    deserializer.deserializeList(SERVERCERTIFICATES_DESCRIPTOR) {
                        val col0 = mutableListOf<ServerCertificateSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServerCertificateSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SERVICETYPE_DESCRIPTOR.index -> builder.serviceType = deserializeString().let { ServiceType.fromValue(it) }
                TLSCONFIG_DESCRIPTOR.index -> builder.tlsConfig = deserializeTlsConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
