// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Thing group indexing configuration.
 */
public class ThingGroupIndexingConfiguration private constructor(builder: Builder) {
    /**
     * A list of thing group fields to index. This list cannot contain any managed fields. Use the GetIndexingConfiguration API to get a list of managed fields.
     *
     * Contains custom field names and their data type.
     */
    public val customFields: List<Field>? = builder.customFields
    /**
     * Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is an optional field. For more information, see [Managed fields](https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field) in the *Amazon Web Services IoT Core Developer Guide*.
     *
     * You can't modify managed fields by updating fleet indexing configuration.
     */
    public val managedFields: List<Field>? = builder.managedFields
    /**
     * Thing group indexing mode.
     */
    public val thingGroupIndexingMode: aws.sdk.kotlin.services.iot.model.ThingGroupIndexingMode = requireNotNull(builder.thingGroupIndexingMode) { "A non-null value must be provided for thingGroupIndexingMode" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ThingGroupIndexingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThingGroupIndexingConfiguration(")
        append("customFields=$customFields,")
        append("managedFields=$managedFields,")
        append("thingGroupIndexingMode=$thingGroupIndexingMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customFields?.hashCode() ?: 0
        result = 31 * result + (managedFields?.hashCode() ?: 0)
        result = 31 * result + (thingGroupIndexingMode.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThingGroupIndexingConfiguration

        if (customFields != other.customFields) return false
        if (managedFields != other.managedFields) return false
        if (thingGroupIndexingMode != other.thingGroupIndexingMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ThingGroupIndexingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of thing group fields to index. This list cannot contain any managed fields. Use the GetIndexingConfiguration API to get a list of managed fields.
         *
         * Contains custom field names and their data type.
         */
        public var customFields: List<Field>? = null
        /**
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is an optional field. For more information, see [Managed fields](https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field) in the *Amazon Web Services IoT Core Developer Guide*.
         *
         * You can't modify managed fields by updating fleet indexing configuration.
         */
        public var managedFields: List<Field>? = null
        /**
         * Thing group indexing mode.
         */
        public var thingGroupIndexingMode: aws.sdk.kotlin.services.iot.model.ThingGroupIndexingMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ThingGroupIndexingConfiguration) : this() {
            this.customFields = x.customFields
            this.managedFields = x.managedFields
            this.thingGroupIndexingMode = x.thingGroupIndexingMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ThingGroupIndexingConfiguration = ThingGroupIndexingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (thingGroupIndexingMode == null) thingGroupIndexingMode = ThingGroupIndexingMode.SdkUnknown("no value provided")
            return this
        }
    }
}
