// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Provides additional selections for named shadows and geolocation data.
 *
 * To add named shadows to your fleet indexing configuration, set `namedShadowIndexingMode` to be ON and specify your shadow names in `namedShadowNames` filter.
 *
 * To add geolocation data to your fleet indexing configuration:
 * + If you store geolocation data in a class/unnamed shadow, set `thingIndexingMode` to be `REGISTRY_AND_SHADOW` and specify your geolocation data in `geoLocations` filter.
 * + If you store geolocation data in a named shadow, set `namedShadowIndexingMode` to be `ON`, add the shadow name in `namedShadowNames` filter, and specify your geolocation data in `geoLocations` filter. For more information, see [Managing fleet indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html).
 */
public class IndexingFilter private constructor(builder: Builder) {
    /**
     * The list of geolocation targets that you select to index. The default maximum number of geolocation targets for indexing is `1`. To increase the limit, see [Amazon Web Services IoT Device Management Quotas](https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits) in the *Amazon Web Services General Reference*.
     */
    public val geoLocations: List<GeoLocationTarget>? = builder.geoLocations
    /**
     * The shadow names that you select to index. The default maximum number of shadow names for indexing is 10. To increase the limit, see [Amazon Web Services IoT Device Management Quotas](https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits) in the *Amazon Web Services General Reference*.
     */
    public val namedShadowNames: List<String>? = builder.namedShadowNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.IndexingFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexingFilter(")
        append("geoLocations=$geoLocations,")
        append("namedShadowNames=$namedShadowNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = geoLocations?.hashCode() ?: 0
        result = 31 * result + (namedShadowNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexingFilter

        if (geoLocations != other.geoLocations) return false
        if (namedShadowNames != other.namedShadowNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.IndexingFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of geolocation targets that you select to index. The default maximum number of geolocation targets for indexing is `1`. To increase the limit, see [Amazon Web Services IoT Device Management Quotas](https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits) in the *Amazon Web Services General Reference*.
         */
        public var geoLocations: List<GeoLocationTarget>? = null
        /**
         * The shadow names that you select to index. The default maximum number of shadow names for indexing is 10. To increase the limit, see [Amazon Web Services IoT Device Management Quotas](https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits) in the *Amazon Web Services General Reference*.
         */
        public var namedShadowNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.IndexingFilter) : this() {
            this.geoLocations = x.geoLocations
            this.namedShadowNames = x.namedShadowNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.IndexingFilter = IndexingFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
