// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



public class UpdateAccountAuditConfigurationRequest private constructor(builder: Builder) {
    /**
     * Specifies which audit checks are enabled and disabled for this account. Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are currently enabled.
     *
     * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted.
     *
     * You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the scheduled audit or delete the scheduled audit itself.
     *
     * On the first call to `UpdateAccountAuditConfiguration`, this parameter is required and must specify at least one enabled check.
     */
    public val auditCheckConfigurations: Map<String, AuditCheckConfiguration>? = builder.auditCheckConfigurations
    /**
     * Information about the targets to which audit notifications are sent.
     */
    public val auditNotificationTargetConfigurations: Map<String, AuditNotificationTarget>? = builder.auditNotificationTargetConfigurations
    /**
     * The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateAccountAuditConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccountAuditConfigurationRequest(")
        append("auditCheckConfigurations=$auditCheckConfigurations,")
        append("auditNotificationTargetConfigurations=$auditNotificationTargetConfigurations,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditCheckConfigurations?.hashCode() ?: 0
        result = 31 * result + (auditNotificationTargetConfigurations?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAccountAuditConfigurationRequest

        if (auditCheckConfigurations != other.auditCheckConfigurations) return false
        if (auditNotificationTargetConfigurations != other.auditNotificationTargetConfigurations) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateAccountAuditConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies which audit checks are enabled and disabled for this account. Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are currently enabled.
         *
         * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted.
         *
         * You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the scheduled audit or delete the scheduled audit itself.
         *
         * On the first call to `UpdateAccountAuditConfiguration`, this parameter is required and must specify at least one enabled check.
         */
        public var auditCheckConfigurations: Map<String, AuditCheckConfiguration>? = null
        /**
         * Information about the targets to which audit notifications are sent.
         */
        public var auditNotificationTargetConfigurations: Map<String, AuditNotificationTarget>? = null
        /**
         * The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateAccountAuditConfigurationRequest) : this() {
            this.auditCheckConfigurations = x.auditCheckConfigurations
            this.auditNotificationTargetConfigurations = x.auditNotificationTargetConfigurations
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateAccountAuditConfigurationRequest = UpdateAccountAuditConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
