// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



public class SearchIndexRequest private constructor(builder: Builder) {
    /**
     * The search index name.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * The maximum number of results to return per page at one time. The response might contain fewer results but will never contain more.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token used to get the next set of results, or `null` if there are no additional results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The search query string. For more information about the search query syntax, see [Query syntax](https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html).
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * The query version.
     */
    public val queryVersion: kotlin.String? = builder.queryVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.SearchIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchIndexRequest(")
        append("indexName=$indexName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("queryString=$queryString,")
        append("queryVersion=$queryVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (queryVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchIndexRequest

        if (indexName != other.indexName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (queryString != other.queryString) return false
        if (queryVersion != other.queryVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.SearchIndexRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The search index name.
         */
        public var indexName: kotlin.String? = null
        /**
         * The maximum number of results to return per page at one time. The response might contain fewer results but will never contain more.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token used to get the next set of results, or `null` if there are no additional results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The search query string. For more information about the search query syntax, see [Query syntax](https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html).
         */
        public var queryString: kotlin.String? = null
        /**
         * The query version.
         */
        public var queryVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.SearchIndexRequest) : this() {
            this.indexName = x.indexName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.queryString = x.queryString
            this.queryVersion = x.queryVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.SearchIndexRequest = SearchIndexRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
