// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes a rule.
 */
public class TopicRulePayload private constructor(builder: Builder) {
    /**
     * The actions associated with the rule.
     */
    public val actions: List<Action> = requireNotNull(builder.actions) { "A non-null value must be provided for actions" }
    /**
     * The version of the SQL rules engine to use when evaluating the rule.
     */
    public val awsIotSqlVersion: kotlin.String? = builder.awsIotSqlVersion
    /**
     * The description of the rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The action to take when an error occurs.
     */
    public val errorAction: aws.sdk.kotlin.services.iot.model.Action? = builder.errorAction
    /**
     * Specifies whether the rule is disabled.
     */
    public val ruleDisabled: kotlin.Boolean? = builder.ruleDisabled
    /**
     * The SQL statement used to query the topic. For more information, see [IoT SQL Reference](https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html) in the *IoT Developer Guide*.
     */
    public val sql: kotlin.String = requireNotNull(builder.sql) { "A non-null value must be provided for sql" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TopicRulePayload = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicRulePayload(")
        append("actions=$actions,")
        append("awsIotSqlVersion=$awsIotSqlVersion,")
        append("description=$description,")
        append("errorAction=$errorAction,")
        append("ruleDisabled=$ruleDisabled,")
        append("sql=$sql")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions.hashCode()
        result = 31 * result + (awsIotSqlVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorAction?.hashCode() ?: 0)
        result = 31 * result + (ruleDisabled?.hashCode() ?: 0)
        result = 31 * result + (sql.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicRulePayload

        if (actions != other.actions) return false
        if (awsIotSqlVersion != other.awsIotSqlVersion) return false
        if (description != other.description) return false
        if (errorAction != other.errorAction) return false
        if (ruleDisabled != other.ruleDisabled) return false
        if (sql != other.sql) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TopicRulePayload = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions associated with the rule.
         */
        public var actions: List<Action>? = null
        /**
         * The version of the SQL rules engine to use when evaluating the rule.
         */
        public var awsIotSqlVersion: kotlin.String? = null
        /**
         * The description of the rule.
         */
        public var description: kotlin.String? = null
        /**
         * The action to take when an error occurs.
         */
        public var errorAction: aws.sdk.kotlin.services.iot.model.Action? = null
        /**
         * Specifies whether the rule is disabled.
         */
        public var ruleDisabled: kotlin.Boolean? = null
        /**
         * The SQL statement used to query the topic. For more information, see [IoT SQL Reference](https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html) in the *IoT Developer Guide*.
         */
        public var sql: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TopicRulePayload) : this() {
            this.actions = x.actions
            this.awsIotSqlVersion = x.awsIotSqlVersion
            this.description = x.description
            this.errorAction = x.errorAction
            this.ruleDisabled = x.ruleDisabled
            this.sql = x.sql
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TopicRulePayload = TopicRulePayload(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.Action] inside the given [block]
         */
        public fun errorAction(block: aws.sdk.kotlin.services.iot.model.Action.Builder.() -> kotlin.Unit) {
            this.errorAction = aws.sdk.kotlin.services.iot.model.Action.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (actions == null) actions = emptyList()
            if (sql == null) sql = ""
            return this
        }
    }
}
