// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action to publish to an Amazon SNS topic.
 */
public class SnsAction private constructor(builder: Builder) {
    /**
     * (Optional) The message format of the message to publish. Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats, see [https://docs.aws.amazon.com/sns/latest/dg/json-formats.html](https://docs.aws.amazon.com/sns/latest/dg/json-formats.html) refer to their official documentation.
     */
    public val messageFormat: aws.sdk.kotlin.services.iot.model.MessageFormat? = builder.messageFormat
    /**
     * The ARN of the IAM role that grants access.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The ARN of the SNS topic.
     */
    public val targetArn: kotlin.String = requireNotNull(builder.targetArn) { "A non-null value must be provided for targetArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.SnsAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnsAction(")
        append("messageFormat=$messageFormat,")
        append("roleArn=$roleArn,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = messageFormat?.hashCode() ?: 0
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (targetArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnsAction

        if (messageFormat != other.messageFormat) return false
        if (roleArn != other.roleArn) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.SnsAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (Optional) The message format of the message to publish. Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats, see [https://docs.aws.amazon.com/sns/latest/dg/json-formats.html](https://docs.aws.amazon.com/sns/latest/dg/json-formats.html) refer to their official documentation.
         */
        public var messageFormat: aws.sdk.kotlin.services.iot.model.MessageFormat? = null
        /**
         * The ARN of the IAM role that grants access.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The ARN of the SNS topic.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.SnsAction) : this() {
            this.messageFormat = x.messageFormat
            this.roleArn = x.roleArn
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.SnsAction = SnsAction(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (targetArn == null) targetArn = ""
            return this
        }
    }
}
