// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Sends message data to an IoT Analytics channel.
 */
public class IotAnalyticsAction private constructor(builder: Builder) {
    /**
     * Whether to process the action as a batch. The default value is `false`.
     *
     * When `batchMode` is `true` and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by `BatchPutMessage`[](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html) to the IoT Analytics channel. The resulting array can't have more than 100 messages.
     */
    public val batchMode: kotlin.Boolean? = builder.batchMode
    /**
     * (deprecated) The ARN of the IoT Analytics channel to which message data will be sent.
     */
    public val channelArn: kotlin.String? = builder.channelArn
    /**
     * The name of the IoT Analytics channel to which message data will be sent.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.IotAnalyticsAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IotAnalyticsAction(")
        append("batchMode=$batchMode,")
        append("channelArn=$channelArn,")
        append("channelName=$channelName,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchMode?.hashCode() ?: 0
        result = 31 * result + (channelArn?.hashCode() ?: 0)
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IotAnalyticsAction

        if (batchMode != other.batchMode) return false
        if (channelArn != other.channelArn) return false
        if (channelName != other.channelName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.IotAnalyticsAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether to process the action as a batch. The default value is `false`.
         *
         * When `batchMode` is `true` and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by `BatchPutMessage`[](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html) to the IoT Analytics channel. The resulting array can't have more than 100 messages.
         */
        public var batchMode: kotlin.Boolean? = null
        /**
         * (deprecated) The ARN of the IoT Analytics channel to which message data will be sent.
         */
        public var channelArn: kotlin.String? = null
        /**
         * The name of the IoT Analytics channel to which message data will be sent.
         */
        public var channelName: kotlin.String? = null
        /**
         * The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.IotAnalyticsAction) : this() {
            this.batchMode = x.batchMode
            this.channelArn = x.channelArn
            this.channelName = x.channelName
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.IotAnalyticsAction = IotAnalyticsAction(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
