// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Send data to an HTTPS endpoint.
 */
public class HttpAction private constructor(builder: Builder) {
    /**
     * The authentication method to use when sending data to an HTTPS endpoint.
     */
    public val auth: aws.sdk.kotlin.services.iot.model.HttpAuthorization? = builder.auth
    /**
     * The URL to which IoT sends a confirmation message. The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.
     */
    public val confirmationUrl: kotlin.String? = builder.confirmationUrl
    /**
     * The HTTP headers to send with the message data.
     */
    public val headers: List<HttpActionHeader>? = builder.headers
    /**
     * The endpoint URL. If substitution templates are used in the URL, you must also specify a `confirmationUrl`. If this is a new destination, a new `TopicRuleDestination` is created if possible.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.HttpAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpAction(")
        append("auth=$auth,")
        append("confirmationUrl=$confirmationUrl,")
        append("headers=$headers,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auth?.hashCode() ?: 0
        result = 31 * result + (confirmationUrl?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (url.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpAction

        if (auth != other.auth) return false
        if (confirmationUrl != other.confirmationUrl) return false
        if (headers != other.headers) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.HttpAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authentication method to use when sending data to an HTTPS endpoint.
         */
        public var auth: aws.sdk.kotlin.services.iot.model.HttpAuthorization? = null
        /**
         * The URL to which IoT sends a confirmation message. The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.
         */
        public var confirmationUrl: kotlin.String? = null
        /**
         * The HTTP headers to send with the message data.
         */
        public var headers: List<HttpActionHeader>? = null
        /**
         * The endpoint URL. If substitution templates are used in the URL, you must also specify a `confirmationUrl`. If this is a new destination, a new `TopicRuleDestination` is created if possible.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.HttpAction) : this() {
            this.auth = x.auth
            this.confirmationUrl = x.confirmationUrl
            this.headers = x.headers
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.HttpAction = HttpAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.HttpAuthorization] inside the given [block]
         */
        public fun auth(block: aws.sdk.kotlin.services.iot.model.HttpAuthorization.Builder.() -> kotlin.Unit) {
            this.auth = aws.sdk.kotlin.services.iot.model.HttpAuthorization.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (url == null) url = ""
            return this
        }
    }
}
