// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action that updates a CloudWatch alarm.
 */
public class CloudwatchAlarmAction private constructor(builder: Builder) {
    /**
     * The CloudWatch alarm name.
     */
    public val alarmName: kotlin.String = requireNotNull(builder.alarmName) { "A non-null value must be provided for alarmName" }
    /**
     * The IAM role that allows access to the CloudWatch alarm.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The reason for the alarm change.
     */
    public val stateReason: kotlin.String = requireNotNull(builder.stateReason) { "A non-null value must be provided for stateReason" }
    /**
     * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     */
    public val stateValue: kotlin.String = requireNotNull(builder.stateValue) { "A non-null value must be provided for stateValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudwatchAlarmAction(")
        append("alarmName=$alarmName,")
        append("roleArn=$roleArn,")
        append("stateReason=$stateReason,")
        append("stateValue=$stateValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmName.hashCode()
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (stateReason.hashCode())
        result = 31 * result + (stateValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudwatchAlarmAction

        if (alarmName != other.alarmName) return false
        if (roleArn != other.roleArn) return false
        if (stateReason != other.stateReason) return false
        if (stateValue != other.stateValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CloudWatch alarm name.
         */
        public var alarmName: kotlin.String? = null
        /**
         * The IAM role that allows access to the CloudWatch alarm.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The reason for the alarm change.
         */
        public var stateReason: kotlin.String? = null
        /**
         * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         */
        public var stateValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction) : this() {
            this.alarmName = x.alarmName
            this.roleArn = x.roleArn
            this.stateReason = x.stateReason
            this.stateValue = x.stateValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction = CloudwatchAlarmAction(this)

        internal fun correctErrors(): Builder {
            if (alarmName == null) alarmName = ""
            if (roleArn == null) roleArn = ""
            if (stateReason == null) stateReason = ""
            if (stateValue == null) stateValue = ""
            return this
        }
    }
}
