// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * A Device Defender security profile behavior.
 */
public class Behavior private constructor(builder: Builder) {
    /**
     * The criteria that determine if a device is behaving normally in regard to the `metric`.
     *
     * In the IoT console, you can choose to be sent an alert through Amazon SNS when IoT Device Defender detects that a device is behaving anomalously.
     */
    public val criteria: aws.sdk.kotlin.services.iot.model.BehaviorCriteria? = builder.criteria
    /**
     * Value indicates exporting metrics related to the behavior when it is true.
     */
    public val exportMetric: kotlin.Boolean? = builder.exportMetric
    /**
     * What is measured by the behavior.
     */
    public val metric: kotlin.String? = builder.metric
    /**
     * The dimension for a metric in your behavior. For example, using a `TOPIC_FILTER` dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.
     */
    public val metricDimension: aws.sdk.kotlin.services.iot.model.MetricDimension? = builder.metricDimension
    /**
     * The name you've given to the behavior.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Suppresses alerts.
     */
    public val suppressAlerts: kotlin.Boolean? = builder.suppressAlerts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.Behavior = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Behavior(")
        append("criteria=$criteria,")
        append("exportMetric=$exportMetric,")
        append("metric=$metric,")
        append("metricDimension=$metricDimension,")
        append("name=$name,")
        append("suppressAlerts=$suppressAlerts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = criteria?.hashCode() ?: 0
        result = 31 * result + (exportMetric?.hashCode() ?: 0)
        result = 31 * result + (metric?.hashCode() ?: 0)
        result = 31 * result + (metricDimension?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (suppressAlerts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Behavior

        if (criteria != other.criteria) return false
        if (exportMetric != other.exportMetric) return false
        if (metric != other.metric) return false
        if (metricDimension != other.metricDimension) return false
        if (name != other.name) return false
        if (suppressAlerts != other.suppressAlerts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.Behavior = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The criteria that determine if a device is behaving normally in regard to the `metric`.
         *
         * In the IoT console, you can choose to be sent an alert through Amazon SNS when IoT Device Defender detects that a device is behaving anomalously.
         */
        public var criteria: aws.sdk.kotlin.services.iot.model.BehaviorCriteria? = null
        /**
         * Value indicates exporting metrics related to the behavior when it is true.
         */
        public var exportMetric: kotlin.Boolean? = null
        /**
         * What is measured by the behavior.
         */
        public var metric: kotlin.String? = null
        /**
         * The dimension for a metric in your behavior. For example, using a `TOPIC_FILTER` dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.
         */
        public var metricDimension: aws.sdk.kotlin.services.iot.model.MetricDimension? = null
        /**
         * The name you've given to the behavior.
         */
        public var name: kotlin.String? = null
        /**
         * Suppresses alerts.
         */
        public var suppressAlerts: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.Behavior) : this() {
            this.criteria = x.criteria
            this.exportMetric = x.exportMetric
            this.metric = x.metric
            this.metricDimension = x.metricDimension
            this.name = x.name
            this.suppressAlerts = x.suppressAlerts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.Behavior = Behavior(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.BehaviorCriteria] inside the given [block]
         */
        public fun criteria(block: aws.sdk.kotlin.services.iot.model.BehaviorCriteria.Builder.() -> kotlin.Unit) {
            this.criteria = aws.sdk.kotlin.services.iot.model.BehaviorCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.MetricDimension] inside the given [block]
         */
        public fun metricDimension(block: aws.sdk.kotlin.services.iot.model.MetricDimension.Builder.() -> kotlin.Unit) {
            this.metricDimension = aws.sdk.kotlin.services.iot.model.MetricDimension.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
