// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AuditFrequency
import aws.sdk.kotlin.services.iot.model.DayOfWeek
import aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateScheduledAuditOperationSerializer: HttpSerialize<UpdateScheduledAuditRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateScheduledAuditRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "audit",
                "scheduledaudits",
                "${input.scheduledAuditName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateScheduledAuditOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateScheduledAuditOperationBody(context: ExecutionContext, input: UpdateScheduledAuditRequest): ByteArray {
    val serializer = JsonSerializer()
    val DAYOFMONTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dayOfMonth"))
    val DAYOFWEEK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dayOfWeek"))
    val FREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("frequency"))
    val TARGETCHECKNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targetCheckNames"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DAYOFMONTH_DESCRIPTOR)
        field(DAYOFWEEK_DESCRIPTOR)
        field(FREQUENCY_DESCRIPTOR)
        field(TARGETCHECKNAMES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dayOfMonth?.let { field(DAYOFMONTH_DESCRIPTOR, it) }
        input.dayOfWeek?.let { field(DAYOFWEEK_DESCRIPTOR, it.value) }
        input.frequency?.let { field(FREQUENCY_DESCRIPTOR, it.value) }
        if (input.targetCheckNames != null) {
            listField(TARGETCHECKNAMES_DESCRIPTOR) {
                for (el0 in input.targetCheckNames) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
