// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ListAttachedPoliciesResponse
import aws.sdk.kotlin.services.iot.model.Policy
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAttachedPoliciesOperationDeserializer: HttpDeserialize<ListAttachedPoliciesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListAttachedPoliciesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAttachedPoliciesError(context, call)
        }
        val builder = ListAttachedPoliciesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAttachedPoliciesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAttachedPoliciesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAttachedPoliciesOperationBody(builder: ListAttachedPoliciesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextMarker"))
    val POLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("policies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTMARKER_DESCRIPTOR)
        field(POLICIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                POLICIES_DESCRIPTOR.index -> builder.policies =
                    deserializer.deserializeList(POLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Policy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePolicyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
