// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.GetTopicRuleDestinationResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.TopicRuleDestination
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTopicRuleDestinationOperationDeserializer: HttpDeserialize<GetTopicRuleDestinationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetTopicRuleDestinationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTopicRuleDestinationError(context, call)
        }
        val builder = GetTopicRuleDestinationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTopicRuleDestinationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTopicRuleDestinationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTopicRuleDestinationOperationBody(builder: GetTopicRuleDestinationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TOPICRULEDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("topicRuleDestination"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TOPICRULEDESTINATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TOPICRULEDESTINATION_DESCRIPTOR.index -> builder.topicRuleDestination = deserializeTopicRuleDestinationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
