// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.GetPolicyResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetPolicyOperationDeserializer: HttpDeserialize<GetPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPolicyError(context, call)
        }
        val builder = GetPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPolicyOperationBody(builder: GetPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DEFAULTVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("defaultVersionId"))
    val GENERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("generationId"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyArn"))
    val POLICYDOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyDocument"))
    val POLICYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(DEFAULTVERSIONID_DESCRIPTOR)
        field(GENERATIONID_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
        field(POLICYDOCUMENT_DESCRIPTOR)
        field(POLICYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTVERSIONID_DESCRIPTOR.index -> builder.defaultVersionId = deserializeString()
                GENERATIONID_DESCRIPTOR.index -> builder.generationId = deserializeString()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                POLICYARN_DESCRIPTOR.index -> builder.policyArn = deserializeString()
                POLICYDOCUMENT_DESCRIPTOR.index -> builder.policyDocument = deserializeString()
                POLICYNAME_DESCRIPTOR.index -> builder.policyName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
