// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.DescribeThingRegistrationTaskResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.Status
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeThingRegistrationTaskOperationDeserializer: HttpDeserialize<DescribeThingRegistrationTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeThingRegistrationTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeThingRegistrationTaskError(context, call)
        }
        val builder = DescribeThingRegistrationTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeThingRegistrationTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeThingRegistrationTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeThingRegistrationTaskOperationBody(builder: DescribeThingRegistrationTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val FAILURECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("failureCount"))
    val INPUTFILEBUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inputFileBucket"))
    val INPUTFILEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inputFileKey"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val PERCENTAGEPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("percentageProgress"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUCCESSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("successCount"))
    val TASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskId"))
    val TEMPLATEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateBody"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(FAILURECOUNT_DESCRIPTOR)
        field(INPUTFILEBUCKET_DESCRIPTOR)
        field(INPUTFILEKEY_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(PERCENTAGEPROGRESS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUCCESSCOUNT_DESCRIPTOR)
        field(TASKID_DESCRIPTOR)
        field(TEMPLATEBODY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILURECOUNT_DESCRIPTOR.index -> builder.failureCount = deserializeInt()
                INPUTFILEBUCKET_DESCRIPTOR.index -> builder.inputFileBucket = deserializeString()
                INPUTFILEKEY_DESCRIPTOR.index -> builder.inputFileKey = deserializeString()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                PERCENTAGEPROGRESS_DESCRIPTOR.index -> builder.percentageProgress = deserializeInt()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                SUCCESSCOUNT_DESCRIPTOR.index -> builder.successCount = deserializeInt()
                TASKID_DESCRIPTOR.index -> builder.taskId = deserializeString()
                TEMPLATEBODY_DESCRIPTOR.index -> builder.templateBody = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
