// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.DescribeThingGroupResponse
import aws.sdk.kotlin.services.iot.model.DynamicGroupStatus
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ThingGroupMetadata
import aws.sdk.kotlin.services.iot.model.ThingGroupProperties
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeThingGroupOperationDeserializer: HttpDeserialize<DescribeThingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeThingGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeThingGroupError(context, call)
        }
        val builder = DescribeThingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeThingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeThingGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeThingGroupOperationBody(builder: DescribeThingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val THINGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupArn"))
    val THINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupId"))
    val THINGGROUPMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("thingGroupMetadata"))
    val THINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupName"))
    val THINGGROUPPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("thingGroupProperties"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INDEXNAME_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(THINGGROUPARN_DESCRIPTOR)
        field(THINGGROUPID_DESCRIPTOR)
        field(THINGGROUPMETADATA_DESCRIPTOR)
        field(THINGGROUPNAME_DESCRIPTOR)
        field(THINGGROUPPROPERTIES_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INDEXNAME_DESCRIPTOR.index -> builder.indexName = deserializeString()
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                QUERYVERSION_DESCRIPTOR.index -> builder.queryVersion = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DynamicGroupStatus.fromValue(it) }
                THINGGROUPARN_DESCRIPTOR.index -> builder.thingGroupArn = deserializeString()
                THINGGROUPID_DESCRIPTOR.index -> builder.thingGroupId = deserializeString()
                THINGGROUPMETADATA_DESCRIPTOR.index -> builder.thingGroupMetadata = deserializeThingGroupMetadataDocument(deserializer)
                THINGGROUPNAME_DESCRIPTOR.index -> builder.thingGroupName = deserializeString()
                THINGGROUPPROPERTIES_DESCRIPTOR.index -> builder.thingGroupProperties = deserializeThingGroupPropertiesDocument(deserializer)
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
