// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AbortConfig
import aws.sdk.kotlin.services.iot.model.DescribeJobTemplateResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig
import aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig
import aws.sdk.kotlin.services.iot.model.MaintenanceWindow
import aws.sdk.kotlin.services.iot.model.PresignedUrlConfig
import aws.sdk.kotlin.services.iot.model.TimeoutConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeJobTemplateOperationDeserializer: HttpDeserialize<DescribeJobTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeJobTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeJobTemplateError(context, call)
        }
        val builder = DescribeJobTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeJobTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeJobTemplateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeJobTemplateOperationBody(builder: DescribeJobTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ABORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("abortConfig"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DESTINATIONPACKAGEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinationPackageVersions"))
    val DOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("document"))
    val DOCUMENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("documentSource"))
    val JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRetryConfig"))
    val JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRolloutConfig"))
    val JOBTEMPLATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobTemplateArn"))
    val JOBTEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobTemplateId"))
    val MAINTENANCEWINDOWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("maintenanceWindows"))
    val PRESIGNEDURLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("presignedUrlConfig"))
    val TIMEOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timeoutConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABORTCONFIG_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATIONPACKAGEVERSIONS_DESCRIPTOR)
        field(DOCUMENT_DESCRIPTOR)
        field(DOCUMENTSOURCE_DESCRIPTOR)
        field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR)
        field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR)
        field(JOBTEMPLATEARN_DESCRIPTOR)
        field(JOBTEMPLATEID_DESCRIPTOR)
        field(MAINTENANCEWINDOWS_DESCRIPTOR)
        field(PRESIGNEDURLCONFIG_DESCRIPTOR)
        field(TIMEOUTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ABORTCONFIG_DESCRIPTOR.index -> builder.abortConfig = deserializeAbortConfigDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DESTINATIONPACKAGEVERSIONS_DESCRIPTOR.index -> builder.destinationPackageVersions =
                    deserializer.deserializeList(DESTINATIONPACKAGEVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DOCUMENT_DESCRIPTOR.index -> builder.document = deserializeString()
                DOCUMENTSOURCE_DESCRIPTOR.index -> builder.documentSource = deserializeString()
                JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR.index -> builder.jobExecutionsRetryConfig = deserializeJobExecutionsRetryConfigDocument(deserializer)
                JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR.index -> builder.jobExecutionsRolloutConfig = deserializeJobExecutionsRolloutConfigDocument(deserializer)
                JOBTEMPLATEARN_DESCRIPTOR.index -> builder.jobTemplateArn = deserializeString()
                JOBTEMPLATEID_DESCRIPTOR.index -> builder.jobTemplateId = deserializeString()
                MAINTENANCEWINDOWS_DESCRIPTOR.index -> builder.maintenanceWindows =
                    deserializer.deserializeList(MAINTENANCEWINDOWS_DESCRIPTOR) {
                        val col0 = mutableListOf<MaintenanceWindow>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMaintenanceWindowDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRESIGNEDURLCONFIG_DESCRIPTOR.index -> builder.presignedUrlConfig = deserializePresignedUrlConfigDocument(deserializer)
                TIMEOUTCONFIG_DESCRIPTOR.index -> builder.timeoutConfig = deserializeTimeoutConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
