// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.DescribeAuditSuppressionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ResourceIdentifier
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAuditSuppressionOperationDeserializer: HttpDeserialize<DescribeAuditSuppressionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeAuditSuppressionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAuditSuppressionError(context, call)
        }
        val builder = DescribeAuditSuppressionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAuditSuppressionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAuditSuppressionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAuditSuppressionOperationBody(builder: DescribeAuditSuppressionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHECKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("checkName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXPIRATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expirationDate"))
    val RESOURCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceIdentifier"))
    val SUPPRESSINDEFINITELY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("suppressIndefinitely"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHECKNAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXPIRATIONDATE_DESCRIPTOR)
        field(RESOURCEIDENTIFIER_DESCRIPTOR)
        field(SUPPRESSINDEFINITELY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHECKNAME_DESCRIPTOR.index -> builder.checkName = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXPIRATIONDATE_DESCRIPTOR.index -> builder.expirationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESOURCEIDENTIFIER_DESCRIPTOR.index -> builder.resourceIdentifier = deserializeResourceIdentifierDocument(deserializer)
                SUPPRESSINDEFINITELY_DESCRIPTOR.index -> builder.suppressIndefinitely = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
