// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



public class CreateJobTemplateRequest private constructor(builder: Builder) {
    /**
     * The criteria that determine when and how a job abort takes place.
     */
    public val abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = builder.abortConfig
    /**
     * A description of the job document.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully completes.
     *
     * **Note:**The following Length Constraints relates to a single string. Up to five strings are allowed.
     */
    public val destinationPackageVersions: List<String>? = builder.destinationPackageVersions
    /**
     * The job document. Required if you don't specify a value for `documentSource`.
     */
    public val document: kotlin.String? = builder.document
    /**
     * An S3 link to the job document to use in the template. Required if you don't specify a value for `document`.
     *
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     *
     * The placeholder link is of the following form:
     *
     * `${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}`
     *
     * where *bucket* is your bucket name and *key* is the object in the bucket to which you are linking.
     */
    public val documentSource: kotlin.String? = builder.documentSource
    /**
     * The ARN of the job to use as the basis for the job template.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * Allows you to create the criteria to retry a job.
     */
    public val jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = builder.jobExecutionsRetryConfig
    /**
     * Allows you to create a staged rollout of a job.
     */
    public val jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
     */
    public val jobTemplateId: kotlin.String? = requireNotNull(builder.jobTemplateId) { "A non-null value must be provided for jobTemplateId" }
    /**
     * Allows you to configure an optional maintenance window for the rollout of a job document to all devices in the target group for a job.
     */
    public val maintenanceWindows: List<MaintenanceWindow>? = builder.maintenanceWindows
    /**
     * Configuration for pre-signed S3 URLs.
     */
    public val presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = builder.presignedUrlConfig
    /**
     * Metadata that can be used to manage the job template.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
     */
    public val timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = builder.timeoutConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobTemplateRequest(")
        append("abortConfig=$abortConfig,")
        append("description=$description,")
        append("destinationPackageVersions=$destinationPackageVersions,")
        append("document=$document,")
        append("documentSource=$documentSource,")
        append("jobArn=$jobArn,")
        append("jobExecutionsRetryConfig=$jobExecutionsRetryConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("jobTemplateId=$jobTemplateId,")
        append("maintenanceWindows=$maintenanceWindows,")
        append("presignedUrlConfig=$presignedUrlConfig,")
        append("tags=$tags,")
        append("timeoutConfig=$timeoutConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationPackageVersions?.hashCode() ?: 0)
        result = 31 * result + (document?.hashCode() ?: 0)
        result = 31 * result + (documentSource?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRetryConfig?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (jobTemplateId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindows?.hashCode() ?: 0)
        result = 31 * result + (presignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobTemplateRequest

        if (abortConfig != other.abortConfig) return false
        if (description != other.description) return false
        if (destinationPackageVersions != other.destinationPackageVersions) return false
        if (document != other.document) return false
        if (documentSource != other.documentSource) return false
        if (jobArn != other.jobArn) return false
        if (jobExecutionsRetryConfig != other.jobExecutionsRetryConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (jobTemplateId != other.jobTemplateId) return false
        if (maintenanceWindows != other.maintenanceWindows) return false
        if (presignedUrlConfig != other.presignedUrlConfig) return false
        if (tags != other.tags) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The criteria that determine when and how a job abort takes place.
         */
        public var abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = null
        /**
         * A description of the job document.
         */
        public var description: kotlin.String? = null
        /**
         * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully completes.
         *
         * **Note:**The following Length Constraints relates to a single string. Up to five strings are allowed.
         */
        public var destinationPackageVersions: List<String>? = null
        /**
         * The job document. Required if you don't specify a value for `documentSource`.
         */
        public var document: kotlin.String? = null
        /**
         * An S3 link to the job document to use in the template. Required if you don't specify a value for `document`.
         *
         * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
         *
         * The placeholder link is of the following form:
         *
         * `${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}`
         *
         * where *bucket* is your bucket name and *key* is the object in the bucket to which you are linking.
         */
        public var documentSource: kotlin.String? = null
        /**
         * The ARN of the job to use as the basis for the job template.
         */
        public var jobArn: kotlin.String? = null
        /**
         * Allows you to create the criteria to retry a job.
         */
        public var jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = null
        /**
         * Allows you to create a staged rollout of a job.
         */
        public var jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = null
        /**
         * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
         */
        public var jobTemplateId: kotlin.String? = null
        /**
         * Allows you to configure an optional maintenance window for the rollout of a job document to all devices in the target group for a job.
         */
        public var maintenanceWindows: List<MaintenanceWindow>? = null
        /**
         * Configuration for pre-signed S3 URLs.
         */
        public var presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = null
        /**
         * Metadata that can be used to manage the job template.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
         */
        public var timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest) : this() {
            this.abortConfig = x.abortConfig
            this.description = x.description
            this.destinationPackageVersions = x.destinationPackageVersions
            this.document = x.document
            this.documentSource = x.documentSource
            this.jobArn = x.jobArn
            this.jobExecutionsRetryConfig = x.jobExecutionsRetryConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.jobTemplateId = x.jobTemplateId
            this.maintenanceWindows = x.maintenanceWindows
            this.presignedUrlConfig = x.presignedUrlConfig
            this.tags = x.tags
            this.timeoutConfig = x.timeoutConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest = CreateJobTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AbortConfig] inside the given [block]
         */
        public fun abortConfig(block: aws.sdk.kotlin.services.iot.model.AbortConfig.Builder.() -> kotlin.Unit) {
            this.abortConfig = aws.sdk.kotlin.services.iot.model.AbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig] inside the given [block]
         */
        public fun jobExecutionsRetryConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRetryConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig] inside the given [block]
         */
        public fun jobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PresignedUrlConfig] inside the given [block]
         */
        public fun presignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.presignedUrlConfig = aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimeoutConfig] inside the given [block]
         */
        public fun timeoutConfig(block: aws.sdk.kotlin.services.iot.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iot.model.TimeoutConfig.invoke(block)
        }
    }
}
