// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AggregationType
import aws.sdk.kotlin.services.iot.model.FleetMetricUnit
import aws.sdk.kotlin.services.iot.model.UpdateFleetMetricRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFleetMetricOperationSerializer: HttpSerialize<UpdateFleetMetricRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFleetMetricRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "fleet-metric",
                "${input.metricName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateFleetMetricOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFleetMetricOperationBody(context: ExecutionContext, input: UpdateFleetMetricRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGGREGATIONFIELD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("aggregationField"))
    val AGGREGATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("aggregationType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXPECTEDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("expectedVersion"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val PERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("period"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val UNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("unit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATIONFIELD_DESCRIPTOR)
        field(AGGREGATIONTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXPECTEDVERSION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(PERIOD_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(UNIT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.aggregationField?.let { field(AGGREGATIONFIELD_DESCRIPTOR, it) }
        input.aggregationType?.let { field(AGGREGATIONTYPE_DESCRIPTOR, it, ::serializeAggregationTypeDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.expectedVersion?.let { field(EXPECTEDVERSION_DESCRIPTOR, it) }
        input.indexName?.let { field(INDEXNAME_DESCRIPTOR, it) }
        input.period?.let { field(PERIOD_DESCRIPTOR, it) }
        input.queryString?.let { field(QUERYSTRING_DESCRIPTOR, it) }
        input.queryVersion?.let { field(QUERYVERSION_DESCRIPTOR, it) }
        input.unit?.let { field(UNIT_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
